package com.yy.mobile.framework.revenuesdk.gift.bean

import org.json.JSONObject

/**
 * Created by nls on 2019-11-11.
{
"id":1, //用户包裹使用优惠券id
"uid":50012928, // uid
"appid": 25, // 业务id
"acquireTime": 1535186629000, // 获得优惠券时间
"validStartTime": 1535186629000, // 优惠券有效时间
"validEndTime": 1535792400000, // 优惠券失效时间
"lockReleaseTime": null, // 优惠券锁定，被解开时间
"status": 1, // 优惠券状态，1=未使用
"couponId": 40, // 优惠券ID
"couponType": 1, // 优惠券类型，1=代金券，2=满减券，3=折扣券，4=满赠券
"couponName": "开心斗充值1元代金券",
"couponLimitAmount": 6.0, // 优惠券使用需满足的条件，如充值6元以上可用此券
"couponAmount": 1.0, // 优惠券金额
"couponUseWay": 8, // 优惠券使用途径
"couponUseWayInfo": "", // 优惠券使用途径限制，如有是json
"srcType": 9,  // 优惠券来源，9=活动优惠券发放
"humanId": "1juPnq" // 展示给用户看的优惠券ID
}
 */
class CouponStore {
    var id: Long = 0 //用户包裹使用优惠券id
    var uid: Long = 0 // uid
    var appid: Int = 0 // 业务id
    var acquireTime: Long = 0 // 获得优惠券时间
    var validStartTime: Long = 0 // 优惠券有效时间
    var validEndTime: Long = 0 // 优惠券失效时间
    var lockReleaseTime: Long = 0 // 优惠券锁定，被解开时间
    var status: Int = 1 // 优惠券状态，1=未使用
    var couponId: Int = 0 // 优惠券ID
    var couponType: Int = 1 // 优惠券类型，1=代金券，2=满减券，3=折扣券，4=满赠券
    var couponName: String = ""
    var couponLimitAmount: Double = 0.0 // 优惠券使用需满足的条件，如充值6元以上可用此券
    var couponAmount: Double = 0.0 // 优惠券金额
    var couponUseWay: Int = 0 // 优惠券使用途径
    var couponUseWayInfo: String = "" // 优惠券使用途径限制，如有是json
    var srcType: Int = 9  // 优惠券来源，9=活动优惠券发放
    var humanId: String = "" // 展示给用户看的优惠券ID

    companion object {
        fun fromJson(json: String): CouponStore {
            val item = CouponStore()
            return item
        }

        fun fromJson(json: JSONObject): CouponStore {
            val item = CouponStore()
            item.id = json.optLong("id")
            item.uid = json.optLong("uid")
            item.appid = json.optInt("appid")
            item.acquireTime = json.optLong("acquireTime")
            item.validStartTime = json.optLong("validStartTime")
            item.validEndTime = json.optLong("validEndTime")
            item.lockReleaseTime = json.optLong("lockReleaseTime")
            item.status = json.optInt("status")
            item.couponId = json.optInt("couponId")
            item.couponType = json.optInt("couponType")
            item.couponName = json.optString("couponName")
            item.couponLimitAmount = json.optDouble("couponLimitAmount")
            item.couponAmount = json.optDouble("couponAmount")
            item.couponUseWay = json.optInt("couponUseWay")
            item.srcType = json.optInt("srcType")
            item.couponUseWayInfo = json.optString("couponUseWayInfo")
            item.humanId = json.optString("humanId")
            return item
        }
    }
}