package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.BaseJsonRequest;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageRequest;
import com.yy.mobile.framework.revenuesdk.gift.cmd.ProtocolCmd;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by lhf on 2018/7/12.
 * <p>
 * YY.Inc
 */
public class GetPropsByAppIdRequest extends BaseJsonRequest {

//    # Request
//    {
//            "cmd": 1010,
//            "seq":"$seq",   //
//            "ticket":"$ticket",   // 不需验证，选填
//            "uid": $uid,     // uid，必填
//            "appId": 2,          //业务appid，必填
//            "usedChannel":usedChannel,   // 渠道id，分配而得，必填
//            "ip":$ip,   // ip地址，选传
//            "sid":$sid,      //当前频道，可以针对频道设置礼物的价格和是否展示
//            "ssid":$ssid,    //当前子频道，可以针对频道设置礼物的价格和是否展示
//            "recvUid":$recvUid,//当前主播，可以针对频道设置礼物的价格和是否展示
//            "version": "$version", //用于获取礼物列表时，不同版本的礼物图片和特效（目前指针对手机端、交友PC端）
//            "md5VersionOnly": 0 , //是否只返回礼物列表json串对应md5版本号。由于礼物列表比较大，可以减少频繁拉取的消耗
//            "lastMd5Hash":"",  //上次查询礼物列表返回的md5值，如果不为空，会比较本次查询和上次查询的值，如果相等，则不返回礼物列表
//            "filterPropsTypes":"1,2", // 过滤礼物类型，逗号分割，当不为空时会进行过滤处理，返回指定礼物类型的礼物配置
//            "compress":0, //是否对礼物列表进行压缩（propsList），0-否，1-是
//            "countryCode":"MY", //国家代码，采用ISO 3166-1二位字母代码，海外营收必填
//            "liveCategoryId":0 //直播品类，海外营收必填
//    }

    public String seq;
    public long uid;
    public int appId;
    public int usedChannel;
    public String ticket;
    public long sid;
    public long ssid;
    public long recvUid;
    public String filterPropsTypes;
    public String countryCode;
    public int liveCategoryId;
    public String lastMd5Hash;
    public String clientVersion;
    public int version = 0;

    @Override
    public void constructPSCIMessageRequest() {
        String jsonMsg = "";
        try {
            JSONObject jMsg = new JSONObject();
            jMsg.put("cmd", ProtocolCmd.GetPropsByAppIdRequest);
            jMsg.put("seq", seq);
            jMsg.put("uid", uid);
            // jMsg.put("ticket", ticket); // data 不需要传递ticket，否则是service协议出错
            jMsg.put("appId", appId);
            jMsg.put("usedChannel", usedChannel);
            jMsg.put("sid", sid);
            jMsg.put("ssid", ssid);
            jMsg.put("recvUid", recvUid);
            jMsg.put("md5VersionOnly", 0);
            jMsg.put("filterPropsTypes", filterPropsTypes);
            jMsg.put("compress", 1);
            jMsg.put("countryCode", countryCode);
            jMsg.put("liveCategoryId", liveCategoryId);
            jMsg.put("lastMd5Hash", lastMd5Hash);
            jMsg.put("clientVersion", clientVersion);
            jMsg.put("version", version);
            jsonMsg = jMsg.toString();
        } catch (JSONException e) {
            RLog.error("GetPropsByAppIdRequest", "constructPSCIMessageRequest", e);
        }
        psciMessageRequest = new PSCIMessageRequest(ProtocolCmd.GetPropsByAppIdRequest, appId, 0,
                ticket, "", jsonMsg);
    }
}
