package com.yy.mobile.framework.revenuesdk.gift;

import android.os.Handler;
import android.os.Looper;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import static com.yy.mobile.framework.revenuesdk.payapi.PurchaseStatusImpl.TAG;

/**
 * Created by lhf on 2018/8/7.
 * <p>
 * YY.Inc
 */
public class CallbackMode {

    private static CallbackMode mInstance;

    public static CallbackMode getInstance() {
        synchronized (CallbackMode.class) {
            if (mInstance == null) {
                mInstance = new CallbackMode();
            }
        }
        return mInstance;
    }

    private final Handler handler = new Handler(Looper.getMainLooper());
    private ConcurrentHashMap<String, IGiftRequestCallback> callbackMap = new ConcurrentHashMap<>();

    public void registerCallback(String seq, IGiftRequestCallback callback) {
        callbackMap.put(seq, callback);
    }

    public IGiftRequestCallback getCallback(String seq) {
        return callbackMap.get(seq);
    }

    @SuppressWarnings("unchecked")
    public <T> void onCallbackSuccess(String seq, T data) {

        IGiftRequestCallback<T> callback = callbackMap.remove(seq);
        if (callback != null) {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                callback.onSuccess(data);
            } else {
                handler.post(() -> callback.onSuccess(data));
            }
        } else {
            RLog.error(TAG,
                    "onCallbackSuccess--- callback can not find! seq=" + seq);
        }

    }

    public void onCallbackFail(String seq, int code, String message) {
        IGiftRequestCallback callback = callbackMap.remove(seq);
        if (callback != null) {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                callback.onFail(code, message);
            } else {
                handler.post(() -> callback.onFail(code, message));
            }
        } else {
            RLog.error(TAG,
                    "onCallbackFail--- callback can not find! seq=" + seq);
        }
    }
}
