package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.payapi.bean.RevenueRecord;
import com.yy.mobile.framework.revenuesdk.payapi.bean.UserCouponStore;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueServerConst;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class GetUserCouponStoreResponse implements IBaseJsonResponse {
    public int cmd = RevenueServerConst.GetUserCouponStoreResponse;
    public long uid;
    public String seq;
    public int appId;
    public int result;
    public String message;
    public long serverCurrentTime;
    public List<UserCouponStore> userCouponStoreList = new ArrayList<>();
    public boolean hasMore;

    /**
     * 构造函数
     */
    public GetUserCouponStoreResponse(String jsonMsg) {
        parserResponse(jsonMsg);
    }

    @Override
    public void parserResponse(String jsonMsg) {
        if (null == jsonMsg || "".equals(jsonMsg.trim())) {
            RLog.error("GetUserCouponStoreResponse", "parserResponse error, jsonMsg is empty.");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonMsg);
            int cmd = jsonObject.optInt("cmd");
            if (this.cmd != cmd) {
                throw new Exception(this.cmd + " != " + cmd);
            }
            this.uid = jsonObject.optLong("uid");
            this.seq = jsonObject.optString("seq");
            this.appId = jsonObject.optInt("appId");
            this.result = jsonObject.optInt("result");
            this.message = jsonObject.optString("message");
            this.serverCurrentTime = jsonObject.optLong("serverCurrentTime");
            this.userCouponStoreList.addAll(optUserCouponStore(jsonObject.optJSONArray(
                    "userCouponList")));
            this.hasMore = jsonObject.optBoolean("hasMore");
        } catch (JSONException e) {
            RLog.error("GetUserAccountHistoryResponse", "parserResponse error.", e);
        } catch (Exception e) {
            RLog.error("GetUserAccountHistoryResponse", "parserResponse error.", e);
        }
    }

    /**
     * 解析流水记录
     *
     * @param array
     * @return
     */
    private List<UserCouponStore> optUserCouponStore(JSONArray array) {
        List<UserCouponStore> list = new ArrayList<>();
        if (null == array) {
            return list;
        }
        int len = array.length();
        JSONObject object;
        UserCouponStore record;
        for (int i = 0; i < len; i++) {
            object = array.optJSONObject(i);
            if (null == object) {
                continue;
            }
            record = new UserCouponStore();

            record.id = object.optInt("id");
            record.uid = object.optLong("uid");
            record.appid = object.optInt("appid");
            record.acquireTime = object.optLong("acquireTime");
            record.validStartTime = object.optLong("validStartTime");
            record.validEndTime = object.optLong("validEndTime");
            record.lockReleaseTime = object.optLong("lockReleaseTime");
            record.status = object.optInt("status");
            record.couponId = object.optInt("couponId");
            record.couponType = object.optInt("couponType");
            record.couponName = object.optString("couponName");
            record.couponLimitAmount = object.optDouble("couponLimitAmount");
            record.couponAmount = object.optDouble("couponAmount");
            record.couponUseWay = object.optInt("couponUseWay");
            record.couponUseWayInfo = object.optString("couponUseWayInfo");
            record.srcType = object.optInt("srcType");
            record.humanId = object.optString("humanId");

            list.add(record);
        }
        return list;
    }
}
