package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueServerConst;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.request.IRequestProtocol;

import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

public class GetHasChargeInActivityRequest implements IRequestProtocol {
    public String seq;
    public long uid;
    public int appId;
    public int usedChannel;
    public int currencyType;
    public int activityId;
    // public String ticket;

    public GetHasChargeInActivityRequest(String seq, long uid, int appId, int usedChannel,
                                         int currencyType, int activityId, String ticket) {
        this.seq = seq;
        this.uid = uid;
        this.appId = appId;
        this.usedChannel = usedChannel;
        this.currencyType = currencyType;
        this.activityId = activityId;
        // this.ticket = ticket;
    }

    @NotNull
    @Override
    public String getProtocol() {
        String jsonMsg = "";
        JSONObject jMsg = new JSONObject();
        try {
            jMsg.put("cmd", RevenueServerConst.GetHasChargeInActivityRequest);
            jMsg.put("seq", seq);
            jMsg.put("uid", uid);
            jMsg.put("appId", appId);
            jMsg.put("usedChannel", usedChannel);
            jMsg.put("currencyType", currencyType);
            jMsg.put("activityId", activityId);
            // jMsg.put("ticket", ticket);
            jsonMsg = jMsg.toString();
        } catch (JSONException e) {
            RLog.error("GetHasChargeInActivityRequest", "constructPSCIMessageRequest error.", e);
        }
        return jsonMsg;
    }
}

