package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.payapi.bean.CouponDiscountInfo;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueServerConst;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class GetChargeCouponDiscountResponse implements IBaseJsonResponse {
    public int cmd = RevenueServerConst.GetChargeCouponDiscountResponse;
    public long uid;
    public String seq;
    public int appId;
    public int result;
    public String message;
    public int userCouponId;
    public List<CouponDiscountInfo> couponDiscountInfoList = new ArrayList<CouponDiscountInfo>();
    public boolean hasMore;

    /**
     * 构造函数
     */
    public GetChargeCouponDiscountResponse(String jsonMsg) {
        parserResponse(jsonMsg);
    }

    @Override
    public void parserResponse(String jsonMsg) {
        if (null == jsonMsg || "".equals(jsonMsg.trim())) {
            RLog.error("GetChargeCouponDiscountResponse",
                    "parserResponse error, jsonMsg is empty.");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonMsg);
            int cmd = jsonObject.optInt("cmd");
            if (this.cmd != cmd) {
                throw new Exception(this.cmd + " != " + cmd);
            }
            this.uid = jsonObject.optLong("uid");
            this.seq = jsonObject.optString("seq");
            this.appId = jsonObject.optInt("appId");
            this.result = jsonObject.optInt("result");
            this.message = jsonObject.optString("message");
            this.userCouponId = jsonObject.optInt("userCouponId");
            this.couponDiscountInfoList.addAll(optCouponDiscountInfo(jsonObject.optJSONArray(
                    "discountList")));
        } catch (JSONException e) {
            RLog.error("GetChargeCouponDiscountResponse", "parserResponse error.", e);
        } catch (Exception e) {
            RLog.error("GetChargeCouponDiscountResponse", "parserResponse error.", e);
        }
    }

    private List<CouponDiscountInfo> optCouponDiscountInfo(JSONArray array) {
        List<CouponDiscountInfo> list = new ArrayList<>();
        if (null == array) {
            return list;
        }
        int len = array.length();
        JSONObject object;
        CouponDiscountInfo record;
        for (int i = 0; i < len; i++) {
            object = array.optJSONObject(i);
            if (null == object) {
                continue;
            }
            record = new CouponDiscountInfo();

            record.cid = object.optInt("cid");
            record.couponEnabled = object.optBoolean("couponEnabled");
            record.srcAmount = object.optDouble("srcAmount",0.0);
            record.discountAmount = object.optDouble("discountAmount",0.0);
            record.discountProductId = object.optString("discountProductId");
            record.srcCurrencySymbol = object.optString("srcCurrencySymbol");

            list.add(record);
        }
        return list;
    }
}

