package com.yy.mobile.framework.revenuesdk.payservice;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.payapi.PayType;
import com.yy.mobile.framework.revenuesdk.payapi.payservice.DefaultPayMethod;
import com.yy.mobile.framework.revenuesdk.payapi.payservice.H5PayMethod;
import com.yy.mobile.framework.revenuesdk.payapi.payservice.IPayMethod;

enum PayMethodFactory {

    GOOGLE_PLAY("com.yy.mobile.framework.revenue.gppay.PayMethodImpl"),
    WECHAT_PAY("com.yy.mobile.framework.revenue.wxpay.RevenueWechatPayImpl"),
    ALIPAY_PAY("com.yy.mobile.framework.revenue.alipay.RevenueAlipayImpl");

    final String clazz;

    /**
     * 构造函数
     *
     * @param clazz
     */
    PayMethodFactory(String clazz) {
        this.clazz = clazz;
    }

    IPayMethod method;

    /**
     * 创建method并返回
     *
     * @return
     */
    private IPayMethod getPayMethodImpl() {
        if (null != method) {
            return method;
        }
        initPayMethod();
        return method;
    }

    /**
     * 初始化pay method实例
     */
    private void initPayMethod() {
        try {
            method = (IPayMethod) Class.forName(clazz).newInstance();
        } catch (Exception e) {
            method = new DefaultPayMethod();
            RLog.error("AppPayServiceImpl", "init PayMethod error.clazz = " + clazz, e);
        }
    }

    /**
     * 获取对应的支付实现
     *
     * @return
     */
    public static IPayMethod valueOf(PayType type) {
        switch (type) {
            case GOOGLE_PLAY:
                return GOOGLE_PLAY.getPayMethodImpl();
            case WECHAT_PAY:
                return WECHAT_PAY.getPayMethodImpl();
            case ALI_PAY:
                return ALIPAY_PAY.getPayMethodImpl();
            case PAYTM_PAY:
                return new H5PayMethod();
            default:
                //默认返回，不用报错
                return new DefaultPayMethod();
        }
    }
}
