/*
 * Decompiled with CFR 0.152.
 */
package com.yy.sdk.crashreport.anr;

import android.os.Process;
import android.util.Log;
import com.yy.sdk.crashreport.anr.AbstractSampler;
import com.yy.sdk.crashreport.anr.StackNode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;

class StackSampler
extends AbstractSampler {
    private final String TAG = "StackSampler";
    public static final SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.US);
    public static final String SEPARATOR = "\n";
    private static final int DEFAULT_MAX_ENTRY_COUNT = 200;
    private static final ConcurrentLinkedQueue<StackNode> mStackQueue = new ConcurrentLinkedQueue();
    private int mMaxEntryCount = 200;
    private Thread mCurrentThread;

    StackSampler(Thread thread, long sampleIntervalMillis) {
        super(sampleIntervalMillis);
        this.mCurrentThread = thread;
    }

    public ArrayList<String> getThreadStackEntries(long startTime, long endTime) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            StringBuilder stringBuffer = new StringBuilder();
            StringBuilder stringSampleBuilder = new StringBuilder();
            int pid = Process.myPid();
            for (StackNode node : mStackQueue) {
                StackTraceElement[] stackTraceElements;
                if (startTime >= node.getTime() || node.getTime() >= endTime || (stackTraceElements = node.getStackTraceElements()) == null) continue;
                stringBuffer.delete(0, stringBuffer.length());
                stringSampleBuilder.delete(0, stringSampleBuilder.length());
                for (StackTraceElement stackTraceElement : stackTraceElements) {
                    stringSampleBuilder.append("at ").append(stackTraceElement.toString()).append(SEPARATOR);
                }
                stringBuffer.append("----- pid " + pid + " " + TIME_FORMATTER.format(node.getTime())).append(SEPARATOR).append("Cmd line: com.duowan.mobile").append(SEPARATOR).append(" tid=1 ").append(SEPARATOR).append(" sysTid=" + pid + " ").append(SEPARATOR).append(stringSampleBuilder.toString()).append(SEPARATOR).append("----- end " + pid).append(SEPARATOR);
                result.add(stringBuffer.toString());
            }
        }
        catch (Exception e) {
            Log.e((String)"StackSampler", (String)e.getMessage());
        }
        return result;
    }

    public ArrayList<String> getOriStackEntries(long startTime, long endTime) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            StringBuilder stringSampleBuilder = new StringBuilder();
            for (StackNode node : mStackQueue) {
                if (startTime >= node.getTime() || node.getTime() >= endTime) continue;
                StackTraceElement[] stackTraceElements = node.getStackTraceElements();
                stringSampleBuilder.delete(0, stringSampleBuilder.length());
                if (stackTraceElements == null) continue;
                for (StackTraceElement stackTraceElement : stackTraceElements) {
                    stringSampleBuilder.append("at ").append(stackTraceElement.toString()).append(SEPARATOR);
                }
                result.add(stringSampleBuilder.toString());
            }
        }
        catch (Exception e) {
            Log.e((String)"StackSampler", (String)e.getMessage());
        }
        return result;
    }

    @Override
    protected void doSample() {
        try {
            if (mStackQueue.size() >= this.mMaxEntryCount) {
                mStackQueue.remove();
            }
            StackNode node = StackNode.Companion.obtain();
            node.setTime(System.currentTimeMillis());
            node.setStackTraceElements(this.mCurrentThread.getStackTrace());
            mStackQueue.add(node);
        }
        catch (Exception e) {
            Log.e((String)"StackSampler", (String)e.getMessage());
        }
    }
}

