/*
 * Decompiled with CFR 0.152.
 */
package com.yy.sdk.crashreport.anr;

import android.os.Handler;
import android.os.HandlerThread;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class AbstractSampler {
    private static final int DEFAULT_SAMPLE_INTERVAL = 53;
    protected AtomicBoolean mShouldSample = new AtomicBoolean(false);
    protected long mSampleInterval;
    private static HandlerThreadWrapper sLoopThread = new HandlerThreadWrapper("loop");
    private Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            AbstractSampler.this.doSample();
            if (AbstractSampler.this.mShouldSample.get()) {
                sLoopThread.getHandler().postDelayed(AbstractSampler.this.mRunnable, AbstractSampler.this.mSampleInterval);
            }
        }
    };

    public void setSampleInterval(long sampleInterval) {
        this.mSampleInterval = sampleInterval < 10L ? 1000L : sampleInterval;
    }

    AbstractSampler(long sampleIntervalMillis) {
        if (0L == sampleIntervalMillis) {
            sampleIntervalMillis = 53L;
        }
        this.mSampleInterval = sampleIntervalMillis;
    }

    public void start() {
        if (this.mShouldSample.get()) {
            return;
        }
        this.mShouldSample.set(true);
        sLoopThread.getHandler().removeCallbacks(this.mRunnable);
        sLoopThread.getHandler().post(this.mRunnable);
    }

    public void stop() {
        if (!this.mShouldSample.get()) {
            return;
        }
        this.mShouldSample.set(false);
        sLoopThread.getHandler().removeCallbacks(this.mRunnable);
    }

    abstract void doSample();

    private static class HandlerThreadWrapper {
        private Handler handler = null;

        HandlerThreadWrapper(String threadName) {
            HandlerThread handlerThread = new HandlerThread("AnrChecker-" + threadName);
            handlerThread.start();
            this.handler = new Handler(handlerThread.getLooper());
        }

        public Handler getHandler() {
            return this.handler;
        }
    }
}

