/*
 * Decompiled with CFR 0.152.
 */
package com.yy.sdk.crashreport.anr;

import android.os.Looper;
import android.util.Log;
import com.yy.sdk.crashreport.anr.StackSampler;
import java.util.ArrayList;

public class CatonChecker {
    public static final String TAG = "CatonChecker";
    public static final long DEFAULT_SAMPLE_INTERVAL = 53L;
    private StackSampler mStackSampler;
    Object mStackSamplerLock = new Object();
    private boolean mMonitorStarted = false;
    static CatonChecker s_INS = null;

    CatonChecker() {
        Log.i((String)TAG, (String)"caton init, use 2.2.10");
    }

    public static synchronized CatonChecker getIns() {
        if (s_INS == null) {
            s_INS = new CatonChecker();
        }
        return s_INS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackSampler getStackSampler() {
        if (this.mStackSampler == null) {
            Object object = this.mStackSamplerLock;
            synchronized (object) {
                if (this.mStackSampler == null) {
                    this.mStackSampler = new StackSampler(Looper.getMainLooper().getThread(), 53L);
                }
            }
        }
        return this.mStackSampler;
    }

    public synchronized void start(long sampleInterval) {
        if (this.mMonitorStarted) {
            return;
        }
        this.mMonitorStarted = true;
        this.getStackSampler().setSampleInterval(sampleInterval);
        this.getStackSampler().start();
    }

    public void setSampleInterval(long sampleInterval) {
        this.getStackSampler().setSampleInterval(sampleInterval);
    }

    public ArrayList<String> getThreadStackEntries(long realStartTime, long realTimeEnd) {
        ArrayList<String> threadStackEntries = this.getStackSampler().getThreadStackEntries(realStartTime, realTimeEnd);
        return threadStackEntries;
    }

    public ArrayList<String> getOriStackEntries(long realStartTime, long realTimeEnd) {
        ArrayList<String> threadStackEntries = this.getStackSampler().getOriStackEntries(realStartTime, realTimeEnd);
        return threadStackEntries;
    }

    public static interface ANRListener {
        public void onAppAnr(String var1);
    }
}

