package com.yy.sdk.crashreport.anr;

import android.os.Looper;
import android.util.Log;

import java.util.ArrayList;

import static com.yy.sdk.crashreport.anr.BuildConfig.VERSION_NAME;

public class CatonChecker {
    public static final String TAG = "CatonChecker";
    public static final long DEFAULT_SAMPLE_INTERVAL = 53;

    private StackSampler mStackSampler;
    Object mStackSamplerLock = new Object();


    private boolean mMonitorStarted = false;

    static CatonChecker s_INS = null;

    CatonChecker () {
        Log.i(TAG, "caton init, use " + VERSION_NAME);
    }

    public interface ANRListener {
        void onAppAnr(String info);
    }

    public static synchronized CatonChecker getIns() {
        if (s_INS == null) {
            s_INS = new CatonChecker();
        }
        return s_INS;
    }

    public StackSampler getStackSampler() {
        if(mStackSampler == null) {
            synchronized (mStackSamplerLock ) {
                if (mStackSampler == null) {
                    mStackSampler = new StackSampler(
                            Looper.getMainLooper().getThread(),
                            DEFAULT_SAMPLE_INTERVAL);
                }
            }
        }
        return mStackSampler;
    }

    public synchronized void start(long sampleInterval) {
        if (mMonitorStarted) {
            return;
        }

        mMonitorStarted = true;

        getStackSampler().setSampleInterval(sampleInterval);
        //这里改成不等setMessageLogging的启动和结束，直接开一个不会停的线程取堆栈
        getStackSampler().start();
    }

    /**
     * 设置检测的时间,最大值为Long.MAX_VALUE
     *
     * @param sampleInterval
     */
    public void setSampleInterval(long sampleInterval) {
        getStackSampler().setSampleInterval(sampleInterval);
    }

    /**
     * 返回一个新的数组存放卡顿堆栈
     *
     * @param realStartTime 查询卡顿堆栈开始时间戳
     * @param realTimeEnd 查询卡顿堆栈开始结束戳
     * @return ArrayList<String>
     */
    public ArrayList<String> getThreadStackEntries(long realStartTime, long realTimeEnd) {
        ArrayList<String> threadStackEntries = getStackSampler()
                        .getThreadStackEntries(realStartTime, realTimeEnd);
        return threadStackEntries;
    }

    /**
     * 返回一个新的数组存放原始卡顿堆栈
     *
     * @param realStartTime 查询卡顿堆栈开始时间戳
     * @param realTimeEnd 查询卡顿堆栈开始结束戳
     * @return ArrayList<String>
     */
    public ArrayList<String> getOriStackEntries(long realStartTime, long realTimeEnd) {
        ArrayList<String> threadStackEntries = getStackSampler()
                .getOriStackEntries(realStartTime, realTimeEnd);
        return threadStackEntries;
    }
}
