package com.yy.sdk.crashreport.anr;

import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;

import java.util.concurrent.atomic.AtomicBoolean;


abstract class AbstractSampler {

    private static final int DEFAULT_SAMPLE_INTERVAL = 53;

    protected AtomicBoolean mShouldSample = new AtomicBoolean(false);
    protected long mSampleInterval;

    public void setSampleInterval(long sampleInterval) {
        if(sampleInterval < 10) {
            mSampleInterval = CatonChecker.DEFAULT_SAMPLE_INTERVAL;
        }
        else {
            mSampleInterval = sampleInterval;
        }
    }

    private static class HandlerThreadWrapper {
        private Handler handler = null;

        HandlerThreadWrapper(String threadName) {
            HandlerThread handlerThread = new HandlerThread("AnrChecker-" + threadName);
            handlerThread.start();
            handler = new Handler(handlerThread.getLooper());
        }

        public Handler getHandler() {
            return handler;
        }
    }

    private static HandlerThreadWrapper sLoopThread = new HandlerThreadWrapper("loop");

    private Runnable mRunnable = new Runnable() {
        @Override
        public void run() {
            doSample();

            if (mShouldSample.get()) {
                sLoopThread.getHandler().postDelayed(mRunnable, mSampleInterval);
            }
        }
    };

    AbstractSampler(long sampleIntervalMillis) {
        if (0 == sampleIntervalMillis) {
            sampleIntervalMillis = DEFAULT_SAMPLE_INTERVAL;
        }
        mSampleInterval = sampleIntervalMillis;
    }

    public void start() {
        if (mShouldSample.get()) {
            return;
        }
        mShouldSample.set(true);

        sLoopThread.getHandler().removeCallbacks(mRunnable);
        sLoopThread.getHandler().post(mRunnable);
    }

    public void stop() {
        if (!mShouldSample.get()) {
            return;
        }
        mShouldSample.set(false);
        sLoopThread.getHandler().removeCallbacks(mRunnable);
    }

    abstract void doSample();
}
