/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Path;
import android.graphics.PointF;
import android.text.TextUtils;
import android.view.animation.Interpolator;
import com.unionyy.mobile.meipai.gift.animation.BasicTransformations;
import com.unionyy.mobile.meipai.gift.animation.FrameAnimator;
import com.unionyy.mobile.meipai.gift.animation.evaluator.BezierCurvesEvaluator;
import com.unionyy.mobile.meipai.gift.animation.interpolator.QuadEaseInInterpolator;
import com.unionyy.mobile.meipai.gift.animation.interpolator.QuadEaseInOutInterpolator;
import com.unionyy.mobile.meipai.gift.animation.interpolator.QuadEaseOutInterpolator;
import com.unionyy.mobile.meipai.gift.animation.model.GiftAnimationParams;
import java.util.Random;

public class GiftAnimation
implements ValueAnimator.AnimatorUpdateListener {
    private GiftAnimationParams animationParams;
    private float scaleFrom;
    private float scaleTo;
    private float alphaFrom;
    private float alphaTo;
    private float rotationFrom;
    private float rotationTo;
    private float transFromX;
    private float transToX;
    private float transFromY;
    private float transToY;
    private long duration;
    private long start_offset;
    private int repeatCount;
    private int repeatMode;
    private float mInitScaleX;
    private float mInitScaleY;
    private boolean mEnableInitScale = true;
    private Path mPath;
    private boolean mAutoUpdate = true;
    private Interpolator mInterpolator;
    protected BasicTransformations mTarget;
    private FrameAnimator mAnimator;
    private ValueAnimator.AnimatorUpdateListener mAnimatorUpdateListener;

    public GiftAnimation() {
    }

    public GiftAnimation(GiftAnimationParams params) {
        this.animationParams = params;
        this.createTransformations();
    }

    public void setScaleFrom(float from) {
        this.scaleFrom = from;
    }

    public float getScaleFrom() {
        return this.scaleFrom;
    }

    public void setScaleTo(float to) {
        this.scaleTo = to;
    }

    public float getScaleTo() {
        return this.scaleTo;
    }

    public void setAlphaFrom(float from) {
        this.alphaFrom = from;
    }

    public float getAlphaFrom() {
        return this.alphaFrom;
    }

    public void setAlphaTo(float to) {
        this.alphaTo = to;
    }

    public float getAlphaTo() {
        return this.alphaTo;
    }

    public void setRotationFrom(float from) {
        this.rotationFrom = from;
    }

    public float getRotationFrom() {
        return this.rotationFrom;
    }

    public void setRotationTo(float to) {
        this.rotationTo = to;
    }

    public float getRotationTo() {
        return this.rotationTo;
    }

    public float getTransToX() {
        return this.transToX;
    }

    public void setTransToX(float transToX) {
        this.transToX = transToX;
    }

    public float getTransFromX() {
        return this.transFromX;
    }

    public void setTransFromX(float transFromX) {
        this.transFromX = transFromX;
    }

    public float getTransToY() {
        return this.transToY;
    }

    public void setTransToY(float transToY) {
        this.transToY = transToY;
    }

    public float getTransFromY() {
        return this.transFromY;
    }

    public void setTransFromY(float transFromY) {
        this.transFromY = transFromY;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setStart_offset(long startOffset) {
        this.start_offset = startOffset;
    }

    public long getStart_offset() {
        return this.start_offset;
    }

    public int getRepeatMode() {
        return this.repeatMode;
    }

    public void setRepeatMode(int repeatMode) {
        this.repeatMode = repeatMode;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    public boolean isAutoUpdate() {
        return this.mAutoUpdate;
    }

    public void initPath(PointF[] positions, PointF[] controls) {
        this.mPath = new Path();
        int j = 0;
        for (int i = 0; i < positions.length; ++i) {
            if (i == 0) {
                this.mPath.moveTo(positions[i].x, positions[i].y);
                continue;
            }
            if (controls == null) {
                this.mPath.lineTo(positions[i].x, positions[i].y);
                continue;
            }
            this.mPath.cubicTo(controls[j].x, controls[j].y, controls[j + 1].x, controls[j + 1].y, positions[i].x, positions[i].y);
            j += 2;
        }
    }

    public boolean hasPath() {
        return this.mPath != null;
    }

    public void offsetPath(float dx, float dy) {
        if (this.mPath != null) {
            this.mPath.offset(dx, dy);
        }
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.mAutoUpdate = autoUpdate;
    }

    public void start(BasicTransformations target) {
        this.start(target, null);
    }

    private float decodeNumber(String number) {
        int index = number.indexOf(",");
        if (index > 0 && index < number.length() - 1) {
            float num1 = Float.valueOf(number.substring(0, index)).floatValue();
            float num2 = Float.valueOf(number.substring(index + 1)).floatValue();
            Random random = new Random();
            float factor = random.nextFloat();
            return num1 + (num2 - num1) * factor;
        }
        if (index < 0) {
            float num1 = Float.valueOf(number).floatValue();
            return num1;
        }
        return 0.0f;
    }

    private void createTransformations() {
        String rotation_to;
        String rotation_from;
        String alpha_to;
        String alpha_from;
        String scale_to;
        if (this.animationParams == null) {
            return;
        }
        String scale_from = this.animationParams.getScale_from();
        if (!TextUtils.isEmpty((CharSequence)scale_from)) {
            this.scaleFrom = this.decodeNumber(scale_from);
        }
        if (!TextUtils.isEmpty((CharSequence)(scale_to = this.animationParams.getScale_to()))) {
            this.scaleTo = this.decodeNumber(scale_to);
        }
        if (!TextUtils.isEmpty((CharSequence)(alpha_from = this.animationParams.getAlpha_from()))) {
            this.alphaFrom = this.decodeNumber(alpha_from);
        }
        if (!TextUtils.isEmpty((CharSequence)(alpha_to = this.animationParams.getAlpha_to()))) {
            this.alphaTo = this.decodeNumber(alpha_to);
        }
        if (!TextUtils.isEmpty((CharSequence)(rotation_from = this.animationParams.getRotation_from()))) {
            this.rotationFrom = this.decodeNumber(rotation_from);
        }
        if (!TextUtils.isEmpty((CharSequence)(rotation_to = this.animationParams.getRotation_to()))) {
            this.rotationTo = this.decodeNumber(rotation_to);
        }
        if (this.animationParams.getInterpolator() > 0) {
            this.mInterpolator = this.getInterpolator(this.animationParams.getInterpolator());
        }
        if (this.animationParams.getRepeat_count() != 0) {
            this.repeatCount = this.animationParams.getRepeat_count();
        }
        if (this.animationParams.getRepeat_mode() > 0) {
            this.repeatMode = this.animationParams.getRepeat_mode() == 1 ? 1 : 2;
        }
        this.duration = this.animationParams.getDuration();
        this.start_offset = this.animationParams.getDelay();
    }

    private Interpolator getInterpolator(int type2) {
        if (type2 == 1) {
            return new QuadEaseInInterpolator();
        }
        if (type2 == 2) {
            return new QuadEaseOutInterpolator();
        }
        return new QuadEaseInOutInterpolator();
    }

    public void start(BasicTransformations target, Animator.AnimatorListener listener2) {
        if (target == null) {
            return;
        }
        this.mTarget = target;
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
        this.mInitScaleX = target.getScaleX();
        this.mInitScaleY = target.getScaleY();
        if (this.mPath == null) {
            this.mAnimator = FrameAnimator.ofFloat(0.0f, 1.0f);
        } else {
            BezierCurvesEvaluator bezierCurvesEvaluator = new BezierCurvesEvaluator(this.mPath);
            this.mAnimator = FrameAnimator.ofObject(bezierCurvesEvaluator, new float[2], new float[2]);
        }
        if (this.mInterpolator != null) {
            this.mAnimator.setInterpolator((TimeInterpolator)this.mInterpolator);
        }
        this.mAnimator.setDuration(this.duration);
        this.mAnimator.addUpdateListener(this);
        this.mAnimator.setStartDelay(this.start_offset);
        if (this.repeatCount != 0) {
            this.mAnimator.setRepeatCount(this.repeatCount);
        }
        if (this.repeatMode != 0) {
            this.mAnimator.setRepeatMode(this.repeatMode);
        }
        if (listener2 != null) {
            this.mAnimator.addListener(listener2);
        }
        if (this.mAutoUpdate) {
            this.mAnimator.start();
        }
    }

    public void setEnableInitScale(boolean enable) {
        this.mEnableInitScale = enable;
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        float fraction = animation.getAnimatedFraction();
        if (this.mTarget != null) {
            if (this.scaleTo > 0.0f || this.scaleFrom > 0.0f) {
                float scale = this.scaleFrom + (this.scaleTo - this.scaleFrom) * fraction;
                if (this.mEnableInitScale) {
                    this.mTarget.setScaleX(scale * this.mInitScaleX);
                    this.mTarget.setScaleY(scale * this.mInitScaleY);
                } else {
                    this.mTarget.setScaleX(scale);
                    this.mTarget.setScaleY(scale);
                }
            }
            if (this.alphaFrom > 0.0f || this.alphaTo > 0.0f) {
                this.mTarget.setAlpha(this.alphaFrom + (this.alphaTo - this.alphaFrom) * fraction);
            }
            if (this.rotationFrom != 0.0f || this.rotationTo != 0.0f) {
                this.mTarget.setRotation(this.rotationFrom + (this.rotationTo - this.rotationFrom) * fraction);
            }
            if (this.transFromX > 0.0f || this.transToX > 0.0f) {
                this.mTarget.setTranslationX(this.transFromX + (this.transToX - this.transFromX) * fraction);
            }
            if (this.transFromY > 0.0f || this.transToY > 0.0f) {
                this.mTarget.setTranslationY(this.transFromY + (this.transToY - this.transFromY) * fraction);
            }
            if (this.mPath != null) {
                float[] point = (float[])animation.getAnimatedValue();
                this.mTarget.setTranslationX(point[0]);
                this.mTarget.setTranslationY(point[1]);
            }
            if (this.mAnimatorUpdateListener != null) {
                this.mAnimatorUpdateListener.onAnimationUpdate(animation);
            }
        }
    }

    public void requestUpdate() {
        if (!this.mAutoUpdate && this.mAnimator != null) {
            this.mAnimator.requestUpdate();
        }
    }

    public void setAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener listener2) {
        this.mAnimatorUpdateListener = listener2;
    }

    public void cancel() {
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
        }
        this.mAnimator = null;
        this.mTarget = null;
    }
}

