/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.presenter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.pk.event.EventPKFightingOver;
import com.unionyy.mobile.meipai.pk.presenter.MeiPaiPkBasePresenter;
import com.unionyy.mobile.meipai.pk.presenter.MeiPaiPkGuestPresenter$$EventBinder;
import com.unionyy.mobile.meipai.pk.ui.IPkComponentView;
import com.unionyy.mobile.meipai.pk.ui.model.PkStatusInfo;
import com.unionyy.mobile.meipai.pk.utils.PkChannelMsgSendUtils;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.config.BasicConfig;

public class MeiPaiPkGuestPresenter
extends MeiPaiPkBasePresenter {
    private boolean isNoticeStart;
    private boolean isOpenPk;
    private EventBinder mMeiPaiPkGuestPresenterSniperEventBinder;

    public MeiPaiPkGuestPresenter(@NonNull IPkComponentView pkComponentView) {
        super(pkComponentView);
    }

    @Override
    protected void onPkStatusUpdate() {
        PkStatusInfo info = this.core.getPkStatusInfo();
        if (this.isPkGameTime(info)) {
            this.onGuestPkStart(info);
        }
        if (info.type == 6) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        if (info.state != 0 && this.lastType == 4 && info.type == 5) {
            if (!this.isNoticeStart) {
                PkChannelMsgSendUtils.INSTANCE.pkStartNotice(info.leftName, info.rightName);
                this.isNoticeStart = true;
            }
        } else {
            this.isNoticeStart = false;
        }
    }

    @Override
    protected void onEventCountDownFinished(PkStatusInfo info) {
        if (info.type == 4) {
            if (!this.isNoticeStart) {
                PkChannelMsgSendUtils.INSTANCE.pkStartNotice(info.leftName, info.rightName);
                this.isNoticeStart = true;
            }
            this.onGuestPkStart(info);
        }
        super.onEventCountDownFinished(info);
    }

    private void onGuestPkStart(PkStatusInfo info) {
        if (!this.isOpenPk) {
            this.isOpenPk = true;
            View bgView = LayoutInflater.from((Context)BasicConfig.getInstance().getAppContext()).inflate(R.layout.meipai_pk_video_bg, null);
            if (info.needChangeColor) {
                bgView.setBackgroundResource(R.drawable.meipai_background_blue_red_normal);
            }
            this.mPkComponentView.setPkVideoBg(bgView);
        }
    }

    @BusEvent
    public void onPKFightingOver(EventPKFightingOver event) {
        if (this.core.getPkStatusInfo().type == 5) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (MeiPaiPkGuestPresenter.this.core.getPkStatusInfo().type == 5 && MeiPaiPkGuestPresenter.this.mPkComponentView != null) {
                        MeiPaiPkGuestPresenter.this.mPkComponentView.showTips("\u7531\u4e8e\u60a8\u7684\u7f51\u7edc\u5f02\u5e38,\u672c\u5c40PK\u7ed3\u679c\u65e0\u6cd5\u83b7\u53d6");
                    }
                }
            }, 5000L);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    MeiPaiPkGuestPresenter.this.onClosePk();
                }
            }, (long)(this.core.getPkStatusInfo().punishmentTime * 1000));
        }
    }

    @Override
    protected void onClosePk() {
        if (this.isOpenPk) {
            this.isOpenPk = false;
            this.mPkComponentView.setPkVideoBg(null);
        }
        this.isNoticeStart = false;
        this.mHandler.removeCallbacksAndMessages(null);
        super.onClosePk();
    }

    @Override
    public void onEventBind() {
        super.onEventBind();
        if (this.mMeiPaiPkGuestPresenterSniperEventBinder == null) {
            this.mMeiPaiPkGuestPresenterSniperEventBinder = new MeiPaiPkGuestPresenter$$EventBinder();
        }
        this.mMeiPaiPkGuestPresenterSniperEventBinder.bindEvent((Object)this);
    }

    @Override
    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mMeiPaiPkGuestPresenterSniperEventBinder != null) {
            this.mMeiPaiPkGuestPresenterSniperEventBinder.unBindEvent();
        }
    }
}

