/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.view.animation.AnimationUtils;
import com.unionyy.mobile.meipai.gift.animation.model.GiftRule;
import com.unionyy.mobile.meipai.gift.animation.utils.IImagePlayer;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.internal.NamedRunnable;

public class ImageSeqPlayer
implements IImagePlayer {
    private static final String TAG = ImageSeqPlayer.class.getSimpleName();
    public static final int MAX_CACHE_FRAMES = 5;
    public static final int DEFAULT_FRAME_RATE = 20;
    private int mFrameNumber;
    private int mLoopFrom;
    private int mLoopTo;
    private int mFrameRate;
    private int mCurrentFrame;
    private int mLoopMode;
    private String mPathFormat;
    private long mStartTime = -1L;
    private boolean isStartLoop;
    private boolean isPlayingBackWards;
    private boolean isDisplaying;
    private Bitmap lastDisplayBitmap;
    private Handler mHandler = new Handler();
    private Queue<Bitmap> mFrameQueue = new LinkedList<Bitmap>();
    private ReentrantLock mLock = new ReentrantLock();
    private Condition mCondition;
    private IImagePlayer.IDisplayCallBack mDisplayCallBack;
    private boolean isAbortRequest = false;
    private NamedRunnable mDecodeFrameThread = new NamedRunnable(TAG, new Object[0]){

        public void execute() {
            while (!ImageSeqPlayer.this.isAbortRequest) {
                String path = String.format(ImageSeqPlayer.this.mPathFormat, ImageSeqPlayer.this.mCurrentFrame);
                Bitmap bitmap = null;
                try {
                    bitmap = BitmapFactory.decodeFile((String)path);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (bitmap != null) {
                    ImageSeqPlayer.this.frameQueuePush(bitmap);
                }
                int currentFrame = ImageSeqPlayer.this.mCurrentFrame;
                ImageSeqPlayer.this.nextFrame();
                if (currentFrame != ImageSeqPlayer.this.mCurrentFrame) continue;
                break;
            }
        }
    };
    private long mNext = 0L;
    private NamedRunnable mDisplayThread = new NamedRunnable(TAG, new Object[0]){

        public void execute() {
            while (!ImageSeqPlayer.this.isAbortRequest) {
                final Bitmap bitmap = ImageSeqPlayer.this.frameQueuePeek();
                if (bitmap == null) continue;
                if (ImageSeqPlayer.this.mNext == 0L) {
                    ImageSeqPlayer.this.mNext = AnimationUtils.currentAnimationTimeMillis();
                }
                long currentTime = AnimationUtils.currentAnimationTimeMillis();
                long remainingTime = 0L;
                if (ImageSeqPlayer.this.mStartTime != -1L && ImageSeqPlayer.this.mNext > currentTime) {
                    remainingTime = ImageSeqPlayer.this.mNext - currentTime;
                }
                ImageSeqPlayer.this.mNext = ImageSeqPlayer.this.mNext + (long)ImageSeqPlayer.this.mFrameRate;
                ImageSeqPlayer.this.isDisplaying = true;
                ImageSeqPlayer.this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (ImageSeqPlayer.this.mDisplayCallBack != null && !ImageSeqPlayer.this.isAbortRequest) {
                            ImageSeqPlayer.this.mDisplayCallBack.imageRefresh(bitmap);
                            ImageSeqPlayer.this.frameQueueNext();
                            ImageSeqPlayer.this.releaseLastDisplay();
                            ImageSeqPlayer.this.lastDisplayBitmap = bitmap;
                            ImageSeqPlayer.this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                            ImageSeqPlayer.this.notifyDisplay(ImageSeqPlayer.this.mDisplayThread);
                        }
                    }
                }, remainingTime);
                ImageSeqPlayer.this.waitForDisplay((Object)this);
            }
        }
    };

    public ImageSeqPlayer(IImagePlayer.IDisplayCallBack callBack) {
        this.mCondition = this.mLock.newCondition();
        this.mDisplayCallBack = callBack;
    }

    public void setDataSource(String pathFormat, int frameNumber, int frameRate, int loopMode, int loopFrom, int loopTo) {
        this.mPathFormat = pathFormat;
        this.mFrameNumber = frameNumber;
        this.mFrameRate = frameRate != 0 ? 1000 / frameRate : 20;
        this.mLoopMode = loopMode;
        this.mLoopFrom = loopFrom;
        this.mLoopTo = loopTo;
        this.mCurrentFrame = 1;
    }

    @Override
    public void setDataSource(String imagePath, GiftRule rule) {
        this.setDataSource(imagePath, rule.frames_number, rule.frame_rate, rule.loop_mode, rule.loop_from, rule.loop_to);
    }

    @Override
    public void start() {
        YYTaskExecutor.execute((Runnable)this.mDecodeFrameThread);
        YYTaskExecutor.execute((Runnable)this.mDisplayThread);
    }

    @Override
    public void stop() {
        this.isAbortRequest = true;
        try {
            this.mLock.lock();
            this.mCondition.signalAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.unlock();
        }
        this.notifyDisplay(this.mDisplayThread);
        this.mDisplayCallBack = null;
        this.releaseLastDisplay();
        this.releaseFrameQueue();
    }

    private void releaseLastDisplay() {
        if (this.lastDisplayBitmap != null) {
            this.lastDisplayBitmap.recycle();
            this.lastDisplayBitmap = null;
        }
    }

    private void releaseFrameQueue() {
        while (!this.mFrameQueue.isEmpty()) {
            Bitmap bitmap = this.mFrameQueue.poll();
            if (bitmap == null || bitmap.isRecycled()) continue;
            bitmap.recycle();
        }
    }

    private void frameQueuePush(Bitmap bitmap) {
        this.mLock.lock();
        try {
            while (!this.isAbortRequest && this.mFrameQueue.size() >= 5) {
                this.mCondition.await();
            }
            if (!this.isAbortRequest) {
                this.mFrameQueue.offer(bitmap);
                this.mCondition.signalAll();
            } else if (bitmap != null) {
                bitmap.recycle();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.unlock();
        }
    }

    private Bitmap frameQueuePeek() {
        this.mLock.lock();
        Bitmap bitmap = null;
        try {
            while (!this.isAbortRequest && this.mFrameQueue.size() <= 0) {
                this.mCondition.await();
            }
            bitmap = this.mFrameQueue.peek();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.unlock();
        }
        if (this.isAbortRequest) {
            return null;
        }
        return bitmap;
    }

    private Bitmap frameQueueNext() {
        this.mLock.lock();
        Bitmap bitmap = null;
        try {
            bitmap = this.mFrameQueue.poll();
            this.mCondition.signalAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.unlock();
        }
        if (this.isAbortRequest) {
            return null;
        }
        return bitmap;
    }

    private void nextFrame() {
        this.mCurrentFrame += this.isPlayingBackWards ? -1 : 1;
        if (this.isStartLoop && (!this.isPlayingBackWards && this.mCurrentFrame > this.mLoopTo || this.isPlayingBackWards && this.mCurrentFrame < this.mLoopFrom) || this.mCurrentFrame > this.mFrameNumber) {
            if (this.mLoopFrom > 0) {
                if (this.mLoopMode > 0) {
                    this.mCurrentFrame = this.isStartLoop || this.mLoopTo == this.mFrameNumber ? (this.isPlayingBackWards ? this.mLoopFrom + 1 : this.mLoopTo - 1) : this.mLoopTo;
                    this.isPlayingBackWards = !this.isPlayingBackWards;
                } else {
                    this.mCurrentFrame = this.mLoopFrom;
                }
                this.isStartLoop = true;
            } else {
                this.mCurrentFrame = this.mFrameNumber;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForDisplay(Object obj) {
        try {
            Object object = obj;
            synchronized (object) {
                while (this.isDisplaying) {
                    obj.wait();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDisplay(Object obj) {
        this.isDisplaying = false;
        Object object = obj;
        synchronized (object) {
            obj.notify();
        }
    }
}

