/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.gifttarget;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftTarget;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GlImageTarget;
import com.unionyy.mobile.meipai.gift.animation.model.GiftMessage;
import com.unionyy.mobile.meipai.gift.animation.model.GiftRule;
import com.unionyy.mobile.meipai.gift.animation.utils.LedBitmapLoader;
import com.unionyy.mobile.meipai.gift.animation.view.GlAnimationView;
import com.unionyy.mobile.meipai.gift.animation.view.opengl.TextureIdManager;
import com.unionyy.mobile.meipai.gift.core.config.CallBackMessage;
import com.unionyy.mobile.meipai.gift.core.config.Middleware2MPGiftMgr;
import com.unionyy.mobile.meipai.gift.event.EventShowGiftAnmi;
import com.yy.mobile.RxBus;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.StringUtils;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public class GiftLedGLTarget
extends GiftTarget
implements GlImageTarget.OnLoadImageFailedListener {
    private LedBitmapLoader mLedBitmapLoader;
    private GlImageTarget mBackgroundTarget;
    private GlImageTarget mLedBitmapTarget;
    private boolean isVisible = false;
    private boolean isStartPlayLed;
    private int mWidth;
    private int mHeight;
    private int mScroll;
    private float mMoveDis;
    private float mBackGroundLeft;
    private float mBackGroundMid;
    private float mOffsetX;
    private long mLedStartTime;

    public GiftLedGLTarget() {
        super(true);
    }

    public void loadLedTextBitmap(int width, int height, float scale, GiftMessage message, GiftRule rule, Bitmap suffix) {
        this.mLedBitmapLoader = new LedBitmapLoader(BasicConfig.getInstance().getAppContext());
        this.mLedBitmapLoader.setTextSize(32);
        String text = message.getAnchorName();
        this.mLedBitmapLoader.setText(text);
        this.mLedBitmapLoader.setDotColor(-1, 0);
        this.mWidth = width - rule.padding_left - rule.padding_right;
        this.mHeight = height - rule.padding_top - rule.padding_bottom;
        if (scale < 1.0f) {
            this.mLedBitmapLoader.createLedBitmap((int)((float)this.mWidth * scale), (int)((float)this.mHeight * scale), suffix);
        } else {
            this.mLedBitmapLoader.createLedBitmap(this.mWidth, this.mHeight, suffix);
            this.mLedBitmapLoader.setLedBitmapSize((int)((float)this.mLedBitmapLoader.getLedWidth() * scale), (int)((float)this.mLedBitmapLoader.getLedHeight() * scale));
        }
        this.mWidth = (int)((float)this.mWidth * scale);
        this.mHeight = (int)((float)this.mHeight * scale);
        this.mLedBitmapTarget = new GlImageTarget();
        this.mLedBitmapTarget.setIsDrawWhenLoadBitmap(false);
        TextureIdManager.TextureData data = new TextureIdManager.TextureData();
        data.bitmap = this.mLedBitmapLoader.getLedBitmap();
        this.mLedBitmapTarget.setTextureData(data);
        this.mLedBitmapTarget.setLayoutParams(this.mWidth, this.mHeight);
        if (rule.speed > 0.0f) {
            this.mMoveDis = (float)this.mWidth / rule.speed;
            rule.display_time = (int)((float)(this.mWidth + this.mLedBitmapLoader.getLedWidth()) / this.mMoveDis);
        }
    }

    @Override
    protected void addGiftImage(Context context, ViewGroup group, float x, float y, int z) {
        String imagePath = this.getGiftImagePath();
        this.mBackgroundTarget = new GlImageTarget();
        this.mBackgroundTarget.setOnLoadImageFailedListener(this);
        this.mLedBitmapTarget.setIsDrawWhenLoadBitmap(false);
        this.mBackgroundTarget.setLayoutParams(this.getGiftImageWidth(), this.getGiftImageHeight());
        this.mBackgroundTarget.setX(this.getGiftImageWidth() / 2);
        this.mBackgroundTarget.setY(this.getGiftImageHeight() / 2);
        this.mBackgroundTarget.setTranslationX(x);
        this.mBackgroundTarget.setTranslationY(y);
        this.mBackgroundTarget.addDrawable(imagePath);
        this.mLedBitmapTarget.setY(this.mBackgroundTarget.getY() + y);
        this.mBackGroundLeft = x + (float)this.mGiftRule.padding_left * this.mImageScale;
        this.mBackGroundMid = x + this.mBackgroundTarget.getX();
        this.isVisible = false;
        this.isStartPlayLed = false;
    }

    @Override
    protected Object getGiftImage() {
        return this.mBackgroundTarget;
    }

    @Override
    public void startGiftAnimation(GiftRule rule) {
        super.startGiftAnimation(rule);
        this.isVisible = true;
    }

    @Override
    public void setAlpha(float alpha) {
        super.setAlpha(alpha);
        if (this.mLedBitmapTarget != null) {
            this.mLedBitmapTarget.setAlpha(alpha);
        }
    }

    @Override
    protected boolean afterBeginningAnimation() {
        if (super.afterBeginningAnimation()) {
            this.isStartPlayLed = true;
            this.mScroll = this.mWidth;
            this.mLedStartTime = AnimationUtils.currentAnimationTimeMillis();
            return true;
        }
        return false;
    }

    private void nextLedFrame() {
        int visibleLen;
        if (!this.isStartPlayLed || this.mGiftRule == null || this.mLedBitmapLoader == null || this.mLedBitmapTarget == null) {
            return;
        }
        int bitmapWidth = this.mLedBitmapLoader.getLedWidth();
        if (this.mScroll <= -bitmapWidth) {
            this.mScroll = this.mWidth;
        }
        long currentTime = AnimationUtils.currentAnimationTimeMillis();
        long past = currentTime - this.mLedStartTime;
        this.mLedStartTime = currentTime;
        int srcLeft = 0;
        float dstLeft = this.mBackGroundLeft;
        int move = (int)(this.mMoveDis * (float)past);
        this.mScroll -= move;
        if (this.mScroll < 0) {
            visibleLen = Math.min(bitmapWidth + this.mScroll, this.mWidth);
            srcLeft = -this.mScroll;
        } else {
            visibleLen = Math.min(this.mWidth - this.mScroll, bitmapWidth);
            dstLeft += (float)this.mScroll;
        }
        int srcRight = srcLeft + visibleLen;
        if (this.mLedBitmapTarget != null) {
            this.mLedBitmapTarget.setLayoutParams(visibleLen, this.mLedBitmapTarget.getHeight());
            this.mLedBitmapTarget.setTranslationX(dstLeft + (float)(visibleLen / 2));
            this.mOffsetX = this.mLedBitmapTarget.getTranslationX() - this.mBackGroundMid;
            if (this.mLedBitmapTarget.getScaleX() != 1.0f) {
                this.refreshLedBitmapScale(this.mLedBitmapTarget.getScaleX());
            }
            this.mLedBitmapTarget.setTextureMapping((float)srcLeft / (float)bitmapWidth, 0.0f, (float)srcRight / (float)bitmapWidth, 1.0f);
        }
    }

    @Override
    protected void onGiftAnimationEnd() {
        if (this.mCurrentState == 4) {
            return;
        }
        if (this.mLedBitmapLoader != null) {
            this.mLedBitmapLoader.release();
        }
        this.mLedBitmapTarget = null;
        this.mBackgroundTarget = null;
        this.mLedBitmapLoader = null;
        this.isVisible = false;
        this.isStartPlayLed = false;
        super.onGiftAnimationEnd();
    }

    @Override
    public void updateGiftPosition(float y) {
        super.updateGiftPosition(y);
        if ((this.mCurrentState == 1 || this.mCurrentState == 2) && this.mLedBitmapTarget != null) {
            this.mLedBitmapTarget.setTranslationY(this.mLedBitmapTarget.getTranslationY() + y);
        }
    }

    private void refreshLedBitmapScale(float scale) {
        if (this.mLedBitmapTarget != null) {
            this.mLedBitmapTarget.setScaleX(scale);
            this.mLedBitmapTarget.setScaleY(scale);
            float transX = this.mBackGroundMid + this.mOffsetX * scale;
            this.mLedBitmapTarget.setTranslationX(transX);
        }
    }

    @Override
    public int onChildTextureDraw(GlAnimationView gl, int z) {
        if (!this.isVisible) {
            return z;
        }
        if (this.mBackgroundTarget != null) {
            this.mBackgroundTarget.onTextureDraw(gl, z++);
        }
        this.nextLedFrame();
        if (this.isStartPlayLed && this.mLedBitmapTarget != null) {
            this.mLedBitmapTarget.onTextureDraw(gl, z++);
        }
        return z;
    }

    @Override
    public void onLoadFailed() {
        if (this.mBackgroundTarget != null && this.mCurrentState != 4) {
            if (this.mGiftMessage != null) {
                if (this.mGiftMessage.getGiftId().contains("cg_")) {
                    Middleware2MPGiftMgr.Companion.getInstances().downloadColorEggResZip(this.mGiftMessage.getGiftName(), this.mGiftMessage.getLevel(), this.mGiftMessage, (Function1<? super CallBackMessage, Unit>)new Function1<CallBackMessage, Unit>(){

                        public Unit invoke(CallBackMessage callBackMessage) {
                            if (callBackMessage.getBoolean()) {
                                EventShowGiftAnmi event = new EventShowGiftAnmi(callBackMessage.getMessage());
                                RxBus.getDefault().post((Object)event);
                            }
                            return null;
                        }
                    });
                } else {
                    Middleware2MPGiftMgr.Companion.getInstances().loadMaterialFailed(StringUtils.safeParseInt((String)this.mGiftMessage.getGiftId()), this.mGiftMessage);
                }
            }
            this.onGiftAnimationFailed();
        }
    }
}

