/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.gifttarget;

import android.content.Context;
import android.view.ViewGroup;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftTarget;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GlImageTarget;
import com.unionyy.mobile.meipai.gift.animation.model.GiftRule;
import com.unionyy.mobile.meipai.gift.animation.view.GlAnimationView;

public class GiftImageGLTarget
extends GiftTarget
implements GlImageTarget.OnLoadImageFailedListener {
    private GlImageTarget mGlImageTarget;
    private boolean isVisible = false;

    public GiftImageGLTarget() {
        super(true);
    }

    @Override
    protected void addGiftImage(Context context, ViewGroup group, float x, float y, int z) {
        String imagePath = this.getGiftImagePath();
        int w = this.getGiftImageWidth();
        int h = this.getGiftImageHeight();
        this.mGlImageTarget = new GlImageTarget();
        this.mGlImageTarget.setOnLoadImageFailedListener(this);
        this.mGlImageTarget.setIsDrawWhenLoadBitmap(false);
        this.isVisible = false;
        this.mGlImageTarget.setLayoutParams(w, h);
        this.mGlImageTarget.addDrawable(imagePath);
        this.mGlImageTarget.setX(w / 2);
        this.mGlImageTarget.setY(h / 2);
        this.mGlImageTarget.setTranslationX(x);
        this.mGlImageTarget.setTranslationY(y);
        GiftRule rule = this.mGiftRule;
        if (rule.type == 2) {
            this.mGlImageTarget.setGifParams(rule.frames_number, rule.frame_rate, rule.loop_mode, rule.loop_from, rule.loop_to, rule.h_frames, rule.v_frames);
            if (rule.play_at_start) {
                this.startGifAnimation();
            }
        }
    }

    @Override
    protected Object getGiftImage() {
        return this.mGlImageTarget;
    }

    @Override
    public void startGiftAnimation(GiftRule rule) {
        super.startGiftAnimation(rule);
        this.isVisible = true;
    }

    @Override
    protected boolean afterBeginningAnimation() {
        if (super.afterBeginningAnimation()) {
            if (this.mGiftRule.type == 2 && !this.mGiftRule.play_at_start) {
                this.startGifAnimation();
            }
            return true;
        }
        return false;
    }

    private void startGifAnimation() {
        if (this.mGlImageTarget == null) {
            return;
        }
        this.mGlImageTarget.startGifAnimation();
    }

    @Override
    protected void onGiftAnimationEnd() {
        if (this.mCurrentState == 4) {
            return;
        }
        this.isVisible = false;
        this.mGlImageTarget = null;
        super.onGiftAnimationEnd();
    }

    @Override
    public int onChildTextureDraw(GlAnimationView gl, int z) {
        if (!this.isVisible || this.mGlImageTarget == null) {
            return z;
        }
        this.mGlImageTarget.onTextureDraw(gl, z);
        return z + 1;
    }

    @Override
    public void onLoadFailed() {
        if (this.mGlImageTarget != null && this.mCurrentState != 4) {
            if (this.mGiftMessage != null) {
                // empty if block
            }
            this.onGiftAnimationFailed();
        }
    }
}

