/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.view;

import android.app.Activity;
import android.content.Context;
import android.support.constraint.ConstraintLayout;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.pk.event.EventClosePk;
import com.unionyy.mobile.meipai.pk.event.EventPKFightingOver;
import com.unionyy.mobile.meipai.pk.event.EventPubOverCanclePkAgain;
import com.unionyy.mobile.meipai.pk.event.EventStartPKOverCountdown;
import com.unionyy.mobile.meipai.pk.ui.view.PKSeekBar;
import com.unionyy.mobile.meipai.pk.utils.ContextUtils;
import com.unionyy.mobile.meipai.pk.utils.NumberUtils;
import com.unionyy.mobile.meipai.pk.utils.TimeUtil;
import com.yy.mobile.RxBus;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.ScreenUtil;
import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;

public class LivePKSeekBar
extends ConstraintLayout {
    private static final int TIMER_LIVE_STREAM_PERIOD = 1000;
    private View baseView;
    private TextView mPKTitleText;
    private PKSeekBar mPKSeekBar;
    private PKSeekBar mPKSeekBarDe;
    private PKSeekBar mPKSeekBarCg;
    private ImageView mSeekBarThumbGif;
    private ImageView mPKTitleImage;
    private TextView mPKRedSeekText;
    private TextView mPKBlueSeekText;
    private Timer mLivePKTimer;
    private long pkTime;

    public LivePKSeekBar(Context context) {
        super(context);
        this.initView();
    }

    public LivePKSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public LivePKSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        LivePKSeekBar.inflate((Context)this.getContext(), (int)R.layout.meipai_pk_title_bar_layout, (ViewGroup)this);
        this.mPKTitleText = (TextView)this.findViewById(R.id.live_pk_title_textview);
        this.mPKSeekBarDe = (PKSeekBar)this.findViewById(R.id.live_pk_seek_bar);
        this.mPKSeekBarCg = (PKSeekBar)this.findViewById(R.id.live_pk_seek_bar_cg);
        this.mSeekBarThumbGif = (ImageView)this.findViewById(R.id.live_pk_seekbar_thumb_gif);
        this.mPKRedSeekText = (TextView)this.findViewById(R.id.live_pk_red_text);
        this.mPKBlueSeekText = (TextView)this.findViewById(R.id.live_pk_blue_text);
        this.mPKTitleImage = (ImageView)this.findViewById(R.id.live_pk_title_imageview);
        Glide.with((Context)this.mPKTitleText.getContext()).asGif().load(Integer.valueOf(R.drawable.meipai_pk_seek_bar_thumb)).into(this.mSeekBarThumbGif);
        Glide.with((View)this.mPKTitleImage).load(Integer.valueOf(R.drawable.meipai_pk_title)).into(this.mPKTitleImage);
        this.mPKRedSeekText.setText((CharSequence)String.format(BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_pk_my_side_count), NumberUtils.less10WWith1(0)));
        this.mPKBlueSeekText.setText((CharSequence)String.format(BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_pk_oppo_side_count), NumberUtils.less10WWith1(0)));
    }

    public void setSeekbarRedBlueProgressDrawable(boolean needChange) {
        if (needChange) {
            this.mPKSeekBar = this.mPKSeekBarCg;
            this.mPKSeekBarDe.setVisibility(8);
        } else {
            this.mPKSeekBar = this.mPKSeekBarDe;
            this.mPKSeekBarCg.setVisibility(8);
        }
        this.mPKSeekBar.setVisibility(0);
    }

    public void startVsTitleCountDown(long seconds, Activity activity, final boolean needOverCountDown) {
        if (seconds <= 0L || null == activity || activity.isFinishing()) {
            return;
        }
        this.pkTime = seconds;
        this.mPKTitleText.setText((CharSequence)TimeUtil.formatLiveLengthDuring(seconds * 1000L));
        this.stopTimer();
        final WeakReference<Activity> actWr = new WeakReference<Activity>(activity);
        this.mLivePKTimer = new Timer("live-pk-timer");
        this.mLivePKTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                Activity act = (Activity)actWr.get();
                if (!ContextUtils.isContextValid((Context)act)) {
                    LivePKSeekBar.this.stopTimer();
                    return;
                }
                act.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        LivePKSeekBar.this.pkTime = LivePKSeekBar.this.pkTime - 1L;
                        if (needOverCountDown) {
                            LivePKSeekBar.this.mPKTitleText.setText((CharSequence)TimeUtil.formatLiveLengthDuring(LivePKSeekBar.this.pkTime * 1000L));
                        } else {
                            LivePKSeekBar.this.mPKTitleText.setText((CharSequence)(BasicConfig.getInstance().getAppContext().getString(R.string.meipai_pk_publish) + TimeUtil.formatLiveLengthDuring(LivePKSeekBar.this.pkTime * 1000L)));
                        }
                        if (LivePKSeekBar.this.pkTime == 15L && !needOverCountDown) {
                            RxBus.getDefault().post((Object)new EventPubOverCanclePkAgain());
                        }
                        if (LivePKSeekBar.this.pkTime == 0L && !needOverCountDown) {
                            RxBus.getDefault().post((Object)new EventClosePk());
                        }
                        if (LivePKSeekBar.this.pkTime == 10L && needOverCountDown) {
                            RxBus.getDefault().post((Object)new EventStartPKOverCountdown());
                        }
                        if (LivePKSeekBar.this.pkTime == 0L && needOverCountDown) {
                            RxBus.getDefault().post((Object)new EventPKFightingOver());
                        }
                        if (LivePKSeekBar.this.pkTime <= 0L && LivePKSeekBar.this.mLivePKTimer != null) {
                            LivePKSeekBar.this.stopTimer();
                        }
                    }
                });
            }
        }, 1000L, 1000L);
    }

    public void updatePrograss(long leftCounts, long rightCounts) {
        if (null == this.mPKSeekBar || leftCounts <= 0L && rightCounts <= 0L) {
            return;
        }
        this.mPKRedSeekText.setText((CharSequence)String.format(BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_pk_my_side_count), NumberUtils.formatNumber(leftCounts, 1, 1, 1, 1, 1)));
        this.mPKBlueSeekText.setText((CharSequence)String.format(BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_pk_oppo_side_count), NumberUtils.formatNumber(rightCounts, 1, 1, 1, 1, 1)));
        int progress = (int)(leftCounts * 100L / (leftCounts + rightCounts));
        int oldGress = this.mPKSeekBar.getProgress();
        int sub = progress - oldGress;
        if (sub == 3 && (progress == 0 && oldGress == 3 || progress == 100 && oldGress == 97)) {
            return;
        }
        this.updateProgressWithGifImage(sub, oldGress, progress);
    }

    private void updateProgressWithGifImage(int sub, int oldGress, int newGress) {
        int screen_width = ScreenUtil.getInstance().getWidthPixels();
        float per = (float)screen_width / 100.0f;
        int gifW = this.mSeekBarThumbGif.getWidth();
        float endPositon = (float)newGress * per;
        if (newGress == 0) {
            endPositon = 3.0f * per;
        } else if (newGress == 100) {
            endPositon = 97.0f * per;
        }
        this.mSeekBarThumbGif.setX(endPositon -= (float)(gifW > 0 ? gifW / 2 : ScreenUtil.getInstance().dip2px(4)));
        if (null != this.mPKSeekBar) {
            int newp;
            int n = newp = newGress == 0 ? 3 : newGress;
            if (newGress == 100) {
                newp = 97;
            }
            this.mPKSeekBar.setProgress(newp);
        }
    }

    public void resetPosition() {
        if (null != this.mPKSeekBar) {
            int oldProgress = this.mPKSeekBar.getProgress();
            int newProgress = 50;
            this.updateProgressWithGifImage(newProgress - oldProgress, oldProgress, newProgress);
            this.mPKRedSeekText.setText((CharSequence)String.format(BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_pk_my_side_count), NumberUtils.less10WWith1(0)));
            this.mPKBlueSeekText.setText((CharSequence)String.format(BasicConfig.getInstance().getAppContext().getResources().getString(R.string.meipai_pk_oppo_side_count), NumberUtils.less10WWith1(0)));
        }
    }

    public void release() {
        this.stopTimer();
    }

    private void stopTimer() {
        try {
            if (null != this.mLivePKTimer) {
                this.mLivePKTimer.cancel();
                this.mLivePKTimer.purge();
                this.mLivePKTimer = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.release();
    }

    public long getPkTime() {
        return this.pkTime;
    }
}

