/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.utils.plist;

import com.unionyy.mobile.meipai.gift.animation.utils.plist.Array;
import com.unionyy.mobile.meipai.gift.animation.utils.plist.Data;
import com.unionyy.mobile.meipai.gift.animation.utils.plist.Date;
import com.unionyy.mobile.meipai.gift.animation.utils.plist.Dict;
import com.unionyy.mobile.meipai.gift.animation.utils.plist.False;
import com.unionyy.mobile.meipai.gift.animation.utils.plist.PListInteger;
import com.unionyy.mobile.meipai.gift.animation.utils.plist.PListObject;
import com.unionyy.mobile.meipai.gift.animation.utils.plist.PListString;
import com.unionyy.mobile.meipai.gift.animation.utils.plist.Real;
import com.unionyy.mobile.meipai.gift.animation.utils.plist.Stringer;
import com.unionyy.mobile.meipai.gift.animation.utils.plist.True;
import java.util.Stack;

public class PList {
    private Stringer stringer = new Stringer();
    private PListObject root;
    private boolean stackCtxInDict = false;
    private boolean stackCtxInArray = false;
    private int stackCtxNestedDepth = 0;
    private Stack<PListObject> stack = new Stack();

    public PListObject getRootElement() {
        return this.root;
    }

    public void setRootElement(PListObject root) {
        this.root = root;
    }

    private void attachPListObjToParent(PListObject obj, String key) {
        if (this.stackCtxInArray) {
            this.attachPListObjToArrayParent(this.stack, obj);
        } else if (this.stackCtxInDict) {
            this.attachPListObjToDictParent(obj, key);
        } else if (this.stackCtxNestedDepth == 0) {
            this.setRootElement(obj);
        }
    }

    private void attachPListObjToDictParent(PListObject obj, String key) {
        Dict parent = (Dict)this.stack.pop();
        parent.putConfig(key, obj);
        this.stack.push(parent);
    }

    private void attachPListObjToArrayParent(Stack<PListObject> stack, PListObject obj) {
        Array parent = (Array)stack.pop();
        parent.add(obj);
        stack.push(parent);
    }

    public void stackObject(PListObject obj, String key) throws Exception {
        if (null == key && this.stackCtxInDict) {
            throw new Exception("PList objects with Dict parents require a key.");
        }
        if (this.stackCtxNestedDepth > 0 && !this.stackCtxInDict && !this.stackCtxInArray) {
            throw new Exception("PList elements that are not at the root should have an Array or Dict parent.");
        }
        switch (obj.getType()) {
            case DICT: {
                this.attachPListObjToParent(obj, key);
                this.stack.push(obj);
                this.stackCtxInArray = false;
                this.stackCtxInDict = true;
                ++this.stackCtxNestedDepth;
                break;
            }
            case ARRAY: {
                this.attachPListObjToParent(obj, key);
                this.stack.push(obj);
                this.stackCtxInArray = true;
                this.stackCtxInDict = false;
                ++this.stackCtxNestedDepth;
                break;
            }
            default: {
                this.attachPListObjToParent(obj, key);
            }
        }
    }

    public PListObject popStack() {
        if (this.stack.isEmpty()) {
            return null;
        }
        PListObject ret = this.stack.pop();
        --this.stackCtxNestedDepth;
        if (!this.stack.isEmpty()) {
            switch (((PListObject)this.stack.lastElement()).getType()) {
                case DICT: {
                    this.stackCtxInArray = false;
                    this.stackCtxInDict = true;
                    break;
                }
                case ARRAY: {
                    this.stackCtxInArray = true;
                    this.stackCtxInDict = false;
                    break;
                }
            }
        } else {
            this.stackCtxInArray = false;
            this.stackCtxInDict = false;
        }
        return ret;
    }

    public PListObject buildObject(String tag, String value) throws Exception {
        if (null == tag) {
            throw new Exception("Cannot add a child with a null tag to a PList.");
        }
        PListObject ret = null;
        if (tag.equalsIgnoreCase("integer")) {
            ret = new PListInteger();
            ret.setValue(value);
        } else if (tag.equalsIgnoreCase("string")) {
            ret = new PListString();
            ((PListString)ret).setValue(value);
        } else if (tag.equalsIgnoreCase("real")) {
            ret = new Real();
            ((Real)ret).setValue(value);
        } else if (tag.equalsIgnoreCase("date")) {
            ret = new Date();
            ((Date)ret).setValue(value);
        } else if (tag.equalsIgnoreCase("false")) {
            ret = new False();
        } else if (tag.equalsIgnoreCase("true")) {
            ret = new True();
        } else if (tag.equalsIgnoreCase("data")) {
            ret = new Data();
            ((Data)ret).setValue(value.trim(), true);
        } else if (tag.equalsIgnoreCase("dict")) {
            ret = new Dict();
        } else if (tag.equalsIgnoreCase("array")) {
            ret = new Array();
        }
        return ret;
    }

    public String toString() {
        if (null == this.root) {
            return null;
        }
        return this.root.toString();
    }
}

