/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.danmaku.basic;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextPaint;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.danmaku.BarrageEntity;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.android.AndroidDisplayer;
import master.flame.danmaku.danmaku.model.android.ViewCacheStuffer;

public class BarrageViewCacheStuffer
extends ViewCacheStuffer<MyViewHolder> {
    private Context mContext;

    public BarrageViewCacheStuffer(Context applicationContext) {
        this.mContext = applicationContext;
    }

    public MyViewHolder onCreateViewHolder(int viewType) {
        Log.e((String)"BarrageViewCacheStuffer", (String)("onCreateViewHolder:" + viewType));
        return new MyViewHolder(View.inflate((Context)this.mContext, (int)R.layout.meipai_layout_barrage_view_cache, null));
    }

    public void onBindViewHolder(int viewType, MyViewHolder viewHolder, BaseDanmaku danmaku, AndroidDisplayer.DisplayerConfig displayerConfig, TextPaint paint) {
        BarrageEntity barrageEntity;
        if (paint != null) {
            viewHolder.mTvContent.getPaint().set(paint);
        }
        if ((barrageEntity = (BarrageEntity)danmaku.tag) != null) {
            Bitmap avatarBitmap = barrageEntity.avatarBitmap;
            if (avatarBitmap != null) {
                viewHolder.mIcon.setImageBitmap(avatarBitmap);
                viewHolder.mIcon.postInvalidate();
            }
            viewHolder.mTvNick.setText((CharSequence)barrageEntity.senderNickname);
            viewHolder.mTvContent.setTextSize(12.0f);
            viewHolder.mTvContent.setText((CharSequence)barrageEntity.sendContent);
            if (barrageEntity.style.equals("2")) {
                viewHolder.mTvContent.setBackgroundResource(R.drawable.barrage_bg_style_one);
            } else {
                viewHolder.mTvContent.setBackgroundResource(R.drawable.barrage_bg_style_default);
            }
        }
    }

    public void releaseResource(BaseDanmaku danmaku) {
        danmaku.setTag(null);
        Log.d((String)"BarrageViewCacheStuffer", (String)("releaseResource url:" + danmaku.text));
        this.mContext = null;
    }

    public class MyViewHolder
    extends ViewCacheStuffer.ViewHolder {
        private final ImageView mIcon;
        private final TextView mTvContent;
        private final TextView mTvNick;

        public MyViewHolder(View itemView) {
            super(itemView);
            this.mIcon = (ImageView)itemView.findViewById(R.id.icon);
            this.mTvContent = (TextView)itemView.findViewById(R.id.tv_content);
            this.mTvNick = (TextView)itemView.findViewById(R.id.tv_nick);
        }

        public void measure(int widthMeasureSpec, int heightMeasureSpec) {
            try {
                super.measure(widthMeasureSpec, heightMeasureSpec);
            }
            catch (Exception e) {
                Log.e((String)"BarrageViewCacheStuffer", (String)("BarrageViewCacheStuffer.measure: CRASH!  :   " + e.getMessage()));
            }
        }
    }
}

