/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view;

import android.content.Context;
import android.util.AttributeSet;
import com.unionyy.mobile.meipai.gift.animation.RequestRenderCallBack;
import com.unionyy.mobile.meipai.gift.animation.decoder.AnimationDecoder;
import com.unionyy.mobile.meipai.gift.animation.view.opengl.GLCanvas;
import com.unionyy.mobile.meipai.gift.animation.view.opengl.GlCanvasSurfaceView;
import java.util.ArrayList;

public class GlAnimationView
extends GlCanvasSurfaceView
implements RequestRenderCallBack {
    private ArrayList<AnimationDecoder> mAnimationDecoders = new ArrayList();
    private boolean isSupportNpot = true;
    private int mWidth;
    private int mHeight;

    public GlAnimationView(Context context) {
        super(context);
    }

    public GlAnimationView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public void onTextureDraw(GLCanvas glCanvas) {
        boolean needToDrawNext = false;
        for (int i = 0; i < this.mAnimationDecoders.size(); ++i) {
            AnimationDecoder decoder = this.mAnimationDecoders.get(i);
            if (decoder == null) continue;
            if (!this.isSupportNpot && decoder.requestNpotSupport(this.isSupportNpot)) {
                this.mAnimationDecoders.remove(i);
                --i;
                continue;
            }
            if (!decoder.onTextureDraw(this)) continue;
            needToDrawNext = true;
        }
        if (!needToDrawNext) {
            this.switchRenderMode(false);
        }
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
        for (int i = 0; i < this.mAnimationDecoders.size(); ++i) {
            AnimationDecoder decoder = this.mAnimationDecoders.get(i);
            if (decoder == null) continue;
            decoder.onSizeChanged(w, h, oldw, oldh);
        }
    }

    public void addAnimationDecoder(AnimationDecoder decoder) {
        if (this.mWidth > 0 && this.mHeight > 0) {
            decoder.onSizeChanged(this.mWidth, this.mHeight, 0, 0);
        }
        this.mAnimationDecoders.add(decoder);
    }

    public void addAnimationDecoder(int index, AnimationDecoder decoder) {
        if (this.mWidth > 0 && this.mHeight > 0) {
            decoder.onSizeChanged(this.mWidth, this.mHeight, 0, 0);
        }
        this.mAnimationDecoders.add(index, decoder);
    }

    @Override
    public void requestAutoInvalidate() {
        if (this.getRenderMode() != 1) {
            this.setRenderMode(1);
        }
    }

    @Override
    public void requestInvalidate() {
        if (this.getRenderMode() == 0) {
            this.requestRender();
        }
    }

    @Override
    protected void notSupportNpotTexture() {
        super.notSupportNpotTexture();
        this.isSupportNpot = false;
    }
}

