/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.vehicle;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.unionyy.mobile.meipai.gift.data.bean.Medals;
import com.unionyy.mobile.meipai.gift.data.bean.MountCar;
import com.unionyy.mobile.meipai.gift.data.bean.UserIn;
import com.unionyy.mobile.meipai.gift.event.EventMountCarUserIn;
import com.unionyy.mobile.meipai.vehicle.VehicleManagerBean;
import com.unionyy.mobile.meipai.vehicle.VehicleStickerItem;
import com.yy.mobile.RxBus;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.ProgressListener;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.pref2.SharedPreferencesUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.FileUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.mobilelive.MobileLiveFileUtil;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.File;

public class VehicleManager {
    private static final String TAG = "VehicleManager";
    private static final String PREFERENCE_NAME = "VehicleManagerPreferences";
    private static final String PREFERENCE_KEY_RES_MD5_PRE_FIX = "res_md5_";
    private static final String NOMEDIA = ".nomedia";
    public static final String STICKER_DIR = "vehiclestickers";
    public static final String STICKER_PATH = BasicConfig.getInstance().getRootDir() + File.separator + "config" + File.separator + "vehiclestickers" + File.separator;
    private static volatile VehicleManager instance;
    private CompositeDisposable compositeDisposable = new CompositeDisposable();
    private SharedPreferences mVehicleManagerPreferences;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VehicleManager getInstance() {
        if (instance != null) return instance;
        Class<VehicleManager> clazz = VehicleManager.class;
        synchronized (VehicleManager.class) {
            if (instance != null) return instance;
            instance = new VehicleManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @SuppressLint(value={"CheckResult"})
    public VehicleManager() {
        try {
            this.mVehicleManagerPreferences = SharedPreferencesUtils.getSharedPreferences((Context)BasicConfig.getInstance().getAppContext(), (String)PREFERENCE_NAME, (int)0);
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)("VehicleManager: " + e), (Object[])new Object[0]);
        }
    }

    public void clear() {
        this.compositeDisposable.clear();
    }

    @SuppressLint(value={"CheckResult"})
    public void startVehicle(final VehicleManagerBean bean) {
        String resPath;
        File resFile;
        if (bean == null || bean.vehicleBean == null) {
            MLog.info((Object)TAG, (String)"VehicleManagerBean= null", (Object[])new Object[0]);
            return;
        }
        String filePath = this.zipFilePath(bean.vehicleBean.userCarUrl);
        File file = new File(filePath);
        boolean needDown = false;
        if (!file.exists()) {
            needDown = true;
        } else if (!(filePath.endsWith(".mp4") || (resFile = new File(resPath = STICKER_PATH + bean.vehicleBean.userCarId + File.separator)).exists() && !FP.empty((Object[])resFile.listFiles()))) {
            needDown = true;
        }
        if (needDown) {
            this.downloadStickerFile(bean.vehicleBean.userCarUrl, new ResponseListener(){

                @SuppressLint(value={"CheckResult"})
                public void onResponse(Object response) {
                    MLog.info((Object)VehicleManager.TAG, (String)("downloadAllWhatNeed() download succeeded: " + bean.vehicleBean.userCarUrl), (Object[])new Object[0]);
                    VehicleManager.this.compositeDisposable.add(Observable.zip((ObservableSource)Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Boolean>(){

                        public void subscribe(ObservableEmitter<Boolean> emitter) throws Exception {
                            emitter.onNext((Object)true);
                        }
                    }), (ObservableSource)Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<VehicleManagerBean>(){

                        public void subscribe(ObservableEmitter<VehicleManagerBean> emitter) throws Exception {
                            MLog.info((Object)VehicleManager.TAG, (String)"ObservableOnSubscribe<VehicleManagerBean>", (Object[])new Object[0]);
                            emitter.onNext((Object)bean);
                        }
                    }).flatMap((Function)new Function<VehicleManagerBean, ObservableSource<VehicleManagerBean>>(){

                        public ObservableSource<VehicleManagerBean> apply(VehicleManagerBean bean) throws Exception {
                            if (!bean.vehicleBean.userCarUrl.endsWith(".mp4")) {
                                VehicleManager.this.decompressStickResource(bean);
                            }
                            return Observable.just((Object)bean);
                        }
                    }), (BiFunction)new BiFunction<Boolean, VehicleManagerBean, Object>(){

                        public Object apply(Boolean aBoolean, VehicleManagerBean bean) throws Exception {
                            return bean;
                        }
                    }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Object>(){

                        public void accept(Object bean) throws Exception {
                            if (bean != null) {
                                VehicleManager.this.showVehicleAnimation((VehicleManagerBean)bean);
                            }
                        }
                    }, (Consumer)new Consumer<Throwable>(){

                        public void accept(Throwable throwable) throws Exception {
                            MLog.info((Object)VehicleManager.TAG, (String)throwable.toString(), (Object[])new Object[0]);
                        }
                    }));
                }
            }, new ResponseErrorListener(){

                public void onErrorResponse(RequestError error) {
                    MLog.info((Object)VehicleManager.TAG, (String)("downloadAllWhatNeed() download failed: " + bean.vehicleBean.userCarUrl), (Object[])new Object[0]);
                }
            }, new ProgressListener(){

                public void onProgress(ProgressInfo info) {
                }
            });
        } else {
            this.showVehicleAnimation(bean);
        }
    }

    private void downloadStickerFile(String url, ResponseListener responseListener, ResponseErrorListener errorListener, ProgressListener progressListener) {
        MLog.info((Object)TAG, (String)("downloadStickerFile " + url), (Object[])new Object[0]);
        String filePath = this.zipFilePath(url);
        RequestManager.instance().submitDownloadRequest(url, filePath, responseListener, errorListener, progressListener, false);
    }

    private String zipFilePath(String url) {
        File stickerPath = new File(STICKER_PATH);
        if (!stickerPath.exists()) {
            stickerPath.mkdir();
        }
        String filePath = stickerPath.getAbsolutePath() + File.separator + VehicleStickerItem.getFileNameByUrl(url);
        return filePath;
    }

    private boolean showVehicleAnimation(VehicleManagerBean bean) {
        MountCar car = new MountCar();
        car.setAction(bean.vehicleBean.userCarAction);
        car.setId(Integer.valueOf(bean.vehicleBean.userCarId).intValue());
        car.setName(bean.vehicleBean.userCarName);
        if (bean.vehicleBean.userCarUrl.endsWith(".mp4")) {
            car.setResource(this.zipFilePath(bean.vehicleBean.userCarUrl));
        } else {
            car.setResource(STICKER_PATH + bean.vehicleBean.userCarId + File.separator);
        }
        Medals medals = new Medals();
        medals.setGuard(bean.vehicleBean.guardType);
        UserIn userIn = new UserIn();
        userIn.setId(bean.uid);
        userIn.setNick(bean.nick);
        userIn.setLevel(bean.vehicleBean.userLevel);
        userIn.setMedals(medals);
        EventMountCarUserIn event = new EventMountCarUserIn();
        event.setType(8);
        event.setUser(userIn);
        event.setMounts(car);
        if (bean.isVehicleConvert) {
            event.isVehicleConvert = true;
        }
        RxBus.getDefault().post((Object)event);
        MLog.info((Object)TAG, (String)"showVehicleAnimation() will done! EventMountCarUserIn: %s, howVehicleAnimation() will done! show vehicle now: %s", (Object[])new Object[]{event.toString(), bean.toString()});
        return true;
    }

    private synchronized void decompressStickResource(VehicleManagerBean info) {
        MLog.info((Object)TAG, (String)("method decompressStickResource ready. " + info), (Object[])new Object[0]);
        String zipPath = STICKER_PATH + info.vehicleBean.userCarId;
        File zipFile = new File(STICKER_PATH + this.getFileNameByUrl(info.vehicleBean.userCarUrl));
        if (!zipFile.exists()) {
            MLog.info((Object)TAG, (String)("method decompressStickResource ops. zip file not exists. " + info), (Object[])new Object[0]);
            return;
        }
        try {
            FileUtil.unzip((File)zipFile, (String)zipPath, (String)"");
            String md5 = this.cacheMd5(String.valueOf(info.vehicleBean.userCarId));
            this.setPreferenceResourceMd5(String.valueOf(info.vehicleBean.userCarId), md5);
            MLog.info((Object)TAG, (String)("method decompressStickResource decompressed. " + info + " md5=" + md5), (Object[])new Object[0]);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)e.toString(), (Object[])new Object[0]);
        }
        MLog.info((Object)TAG, (String)("method decompressStickResource done. " + info), (Object[])new Object[0]);
    }

    private String cacheMd5(String id2) {
        try {
            Object[] resourceFiles = new File(STICKER_PATH + id2).listFiles();
            if (FP.empty((Object[])resourceFiles)) {
                return "";
            }
            return MobileLiveFileUtil.filesMd5((File[])resourceFiles);
        }
        catch (Exception e) {
            MLog.debug((Object)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            return "";
        }
    }

    private String getPreferenceResourceMd5(String id2) {
        return this.mVehicleManagerPreferences.getString(PREFERENCE_KEY_RES_MD5_PRE_FIX + id2, "");
    }

    private void setPreferenceResourceMd5(String id2, String md5) {
        this.mVehicleManagerPreferences.edit().putString(PREFERENCE_KEY_RES_MD5_PRE_FIX + id2, md5).apply();
    }

    private String getFileNameByUrl(String url) {
        int index = url.lastIndexOf("/");
        String fileName = url.substring(index + 1, url.length());
        return fileName;
    }
}

