/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.gift.animation.utils.BitmapUtil;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;

public class GuardComingLight
extends View {
    private static final String TAG = "GuardComingLight";
    private Bitmap lightBitmap;
    private int viewHight;
    private int viewWidth;
    private int mDefaultStartPos;
    private long DURATION = -1L;
    private float mRectRadicus = 13.0f;
    private float alpha = 1.0f;
    private Paint mPaint;
    private Path mPath = new Path();
    private RectF mViewBound;
    private float left;
    private int bitmap_width;
    private boolean isAnimationStart;
    private ValueAnimator valueAnimator;
    private int animatorValue;

    public GuardComingLight(Context context) {
        super(context);
        this.init();
    }

    public GuardComingLight(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.viewHight = DeviceUtils.dip2px(26.0f);
        this.bitmap_width = DeviceUtils.dip2px(43.0f);
        this.mRectRadicus = TypedValue.applyDimension((int)1, (float)this.mRectRadicus, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mDefaultStartPos = (int)TypedValue.applyDimension((int)1, (float)this.mDefaultStartPos, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mPaint = new Paint(1);
        this.lightBitmap = BitmapUtil.drawable2Bitmap(this.getResources().getDrawable(R.drawable.meipai_live_guard_light_card));
        this.setLayerType(1, null);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isAnimationStart) {
            if (null == this.mViewBound) {
                this.mViewBound = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            } else {
                this.mViewBound.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            }
            this.mPath.reset();
            this.mPath.addRoundRect(this.mViewBound, this.mRectRadicus, this.mRectRadicus, Path.Direction.CW);
            canvas.clipPath(this.mPath);
            this.left = (long)this.viewWidth - ((long)(this.viewWidth * this.animatorValue) / this.DURATION + (long)this.bitmap_width);
            canvas.drawBitmap(this.lightBitmap, this.left, 0.0f, this.mPaint);
        }
    }

    public void startFlyLight(long duration, int wideth) {
        if (duration <= 0L || this.valueAnimator != null && this.valueAnimator.isRunning()) {
            return;
        }
        this.viewWidth = wideth;
        this.isAnimationStart = true;
        this.DURATION = duration;
        this.setVisibility(0);
        this.valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, (int)duration});
        this.valueAnimator.setDuration(duration);
        this.valueAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        this.valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                GuardComingLight.this.onAnimationUpdate(animation);
            }
        });
        this.valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                GuardComingLight.this.isAnimationStart = false;
                GuardComingLight.this.animatorValue = 0;
            }
        });
        this.valueAnimator.start();
    }

    public void resetAni() {
        if (this.valueAnimator != null && this.valueAnimator.isRunning()) {
            this.valueAnimator.cancel();
            this.valueAnimator = null;
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility != 0 && this.valueAnimator != null && this.valueAnimator.isRunning()) {
            this.valueAnimator.cancel();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.valueAnimator != null && this.valueAnimator.isRunning()) {
            this.valueAnimator.cancel();
        }
        this.getHandler().removeCallbacksAndMessages(null);
        if (null != this.lightBitmap) {
            BitmapUtil.release(this.lightBitmap);
        }
    }

    private void onAnimationUpdate(ValueAnimator animation) {
        this.animatorValue = (Integer)animation.getAnimatedValue();
        this.invalidate();
    }
}

