/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.dialog.RandomView;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;
import com.unionyy.mobile.meipai.pk.utils.MeiPaiScreenUtil;
import com.unionyy.mobile.meipai.pk.utils.UIHelper;
import java.util.Timer;
import java.util.TimerTask;

public class PKRandomConnectView
extends View {
    private Paint paint;
    private final int LINE_COUNT = 24;
    private final int PINK_STROKE_WIDTH = DeviceUtils.dip2px(2.0f);
    private int WAVE_WIDTH = DeviceUtils.dip2px(136.0f);
    private int animatedValue;
    private int ASPTIO = 12;
    private float LINE_HEIGHT_START = 40.0f;
    private float LINE_HEIGHT_END = 60.0f;
    private float LINE_HEIGHT_START2 = 20.0f;
    private float LINE_HEIGHT_END2 = 80.0f;
    private Timer timer_task;
    private TimerTask timerTask;

    public PKRandomConnectView(Context context) {
        super(context);
        this.init();
    }

    public PKRandomConnectView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PKRandomConnectView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.paint = new Paint();
        this.timer_task = new Timer("timer-anamite-random");
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeCap(Paint.Cap.ROUND);
        if (MeiPaiScreenUtil.isLow640Screen()) {
            this.WAVE_WIDTH = DeviceUtils.dip2px(106.0f);
            this.ASPTIO = 8;
            this.LINE_HEIGHT_START = 46.0f;
            this.LINE_HEIGHT_END = 54.0f;
            this.LINE_HEIGHT_START2 = 35.0f;
            this.LINE_HEIGHT_END2 = 65.0f;
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.paint.setStrokeWidth((float)this.PINK_STROKE_WIDTH);
        for (int i = 0; i < 24; ++i) {
            float stopY;
            float startY;
            float stopX;
            int r = 243 - i * 5;
            int g = (int)(45.0f + (float)i * 1.8f);
            int b = 98 + i * 4;
            this.paint.setARGB(255, r, g, b);
            float startX = stopX = (float)this.PINK_STROKE_WIDTH + (float)i * ((float)this.WAVE_WIDTH / 24.0f);
            if (i == 0 || i == 2 || i == 21 || i == 23) {
                startY = this.LINE_HEIGHT_START - (float)this.animatedValue;
                stopY = this.LINE_HEIGHT_END + (float)this.animatedValue;
            } else if (i == 1 || i == 14 || i == 22) {
                startY = this.LINE_HEIGHT_START2 - (float)this.animatedValue - 3.0f;
                stopY = this.LINE_HEIGHT_END2 + (float)this.animatedValue + 3.0f;
            } else if (i == 3 || i == 7 || i == 9 || i == 10 || i == 19) {
                startY = 42.5f - (float)this.animatedValue;
                stopY = 57.5f + (float)this.animatedValue;
            } else if (i == 4 || i == 6 || i == 11 || i == 14) {
                startY = 45.0f - (float)this.animatedValue;
                stopY = 55.0f + (float)this.animatedValue;
            } else {
                startY = 47.0f - (float)this.animatedValue;
                stopY = 54.0f + (float)this.animatedValue;
            }
            this.animatedValue = (int)(Math.random() * (double)this.ASPTIO);
            canvas.drawLine(startX, startY, stopX, stopY, this.paint);
        }
    }

    public void startTimeTask() {
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                UIHelper.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        PKRandomConnectView.this.invalidate();
                    }
                });
            }
        };
        if (this.timer_task == null) {
            this.timer_task = new Timer("timer-anamite-random");
        }
        if (this.timerTask != null) {
            this.timer_task.schedule(this.timerTask, 0L, 140L);
        }
    }

    public void stop() {
        if (this.timer_task != null) {
            this.timer_task.cancel();
            this.timer_task.purge();
            this.timer_task = null;
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.timer_task != null) {
            this.timer_task.cancel();
            this.timer_task.purge();
            this.timer_task = null;
        }
    }
}

