/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.popularity.control;

import android.os.Handler;
import android.support.v4.app.FragmentActivity;
import com.unionyy.mobile.meipai.popularity.SharedPreferencesUtils;
import com.unionyy.mobile.meipai.popularity.view.CallTipsPopWindow;
import com.unionyy.mobile.meipai.popularity.view.CallView;
import com.yy.mobile.ui.utils.DateUtils;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.Date;

public class CallTipsController {
    private static final String TAG = "CallTipsController";
    public static final int TIME_DELAY_UNLOGIN_USER_SHOW_TIPS = 30000;
    public static final int TIME_DELAY_TIPS_HIDE5 = 10000;
    public static final int TIME_DELAY_TIPS_HIDE3 = 10000;
    public static final int INDEX_UNLOGIN_TIPS = 0;
    public static final int INDEX_HAVE_NO_POPULARITY_TIPS = 1;
    public static final int INDEX_FIRST_POPULARITY_GET_TIPS = 2;
    public static final int INDEX_POPULARITY_USE_UP_TIPS = 3;
    private FragmentActivity mFragmentActivity;
    private Handler mHandler = new Handler();
    private CallView mCallView;
    private ArrayList<String> mTips;
    private CallTipsPopWindow mCallTipsPopWindow;
    public boolean isClearScreenState = false;
    private Runnable mRunnable;
    private boolean isShowFinish = false;

    public CallTipsController(FragmentActivity fragmentActivity, CallView callView, ArrayList<String> tips) {
        this.mFragmentActivity = fragmentActivity;
        this.mCallView = callView;
        this.mTips = tips;
    }

    public void showUnLoginTips() {
        if (this.isClearScreenState) {
            MLog.info((Object)TAG, (String)"isClearScreenState is true", (Object[])new Object[0]);
            return;
        }
        if (Model.isShowFirstToday(false)) {
            return;
        }
        if (this.mTips.size() - 1 < 0) {
            return;
        }
        this.mRunnable = new Runnable(){

            @Override
            public void run() {
                CallTipsController.this.dismiss();
                CallTipsController.this.mCallTipsPopWindow = new CallTipsPopWindow(CallTipsController.this.mFragmentActivity, CallTipsController.this.mCallView, 0, (String)CallTipsController.this.mTips.get(0));
                CallTipsController.this.mCallTipsPopWindow.pop();
                Model.setFirstShowDate(false);
                CallTipsController.this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        CallTipsController.this.dismiss();
                    }
                }, 10000L);
            }
        };
        this.mHandler.postDelayed(this.mRunnable, 30000L);
    }

    public void dismiss() {
        if (this.mCallTipsPopWindow != null && this.mCallTipsPopWindow.isShowing()) {
            this.mCallTipsPopWindow.dismiss();
        }
    }

    public boolean isShowing() {
        return this.mCallTipsPopWindow != null && this.mCallTipsPopWindow.isShowing();
    }

    public void showFirstGetTips() {
        if (this.isClearScreenState) {
            MLog.info((Object)TAG, (String)"isClearScreenState is true", (Object[])new Object[0]);
            return;
        }
        if (Model.isNeverShowFirstGetTips() || Model.isShowFirstToday(true)) {
            return;
        }
        if (this.mTips.size() - 1 < 2) {
            return;
        }
        this.dismiss();
        this.mCallTipsPopWindow = new CallTipsPopWindow(this.mFragmentActivity, this.mCallView, 2, this.mTips.get(2));
        this.mCallTipsPopWindow.pop();
        Model.setFirstShowDate(true);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                CallTipsController.this.dismiss();
            }
        }, 10000L);
    }

    public void showHaveNoPopularityTips() {
        if (this.isClearScreenState) {
            MLog.info((Object)TAG, (String)"isClearScreenState is true", (Object[])new Object[0]);
            return;
        }
        if (this.mTips.size() - 1 < 1 || this.isShowing()) {
            return;
        }
        this.dismiss();
        this.mCallTipsPopWindow = new CallTipsPopWindow(this.mFragmentActivity, this.mCallView, 1, this.mTips.get(1));
        this.mCallTipsPopWindow.pop();
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                CallTipsController.this.dismiss();
            }
        }, 10000L);
    }

    public void showPopularityGiftUseUp() {
        if (this.isClearScreenState) {
            MLog.info((Object)TAG, (String)"isClearScreenState is true", (Object[])new Object[0]);
            return;
        }
        if (this.isShowFinish) {
            return;
        }
        this.isShowFinish = true;
        if (this.mTips.size() - 1 < 3 || this.isShowing()) {
            return;
        }
        if (this.mCallTipsPopWindow != null) {
            if (this.mCallTipsPopWindow.isShowing()) {
                return;
            }
            if (this.mCallTipsPopWindow.isUpTipsPopShowing) {
                this.dismiss();
                return;
            }
        }
        this.dismiss();
        this.mCallTipsPopWindow = new CallTipsPopWindow(this.mFragmentActivity, this.mCallView, 3, this.mTips.get(3));
        this.mCallTipsPopWindow.pop();
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                CallTipsController.this.mCallView.setVisibility(8);
                CallTipsController.this.dismiss();
            }
        }, 10000L);
    }

    public void clearUnloinTipsMessage() {
        if (this.mHandler != null && this.mRunnable != null) {
            this.mHandler.removeCallbacks(this.mRunnable);
        }
    }

    public void clearHandleMessage() {
        this.mHandler.removeCallbacksAndMessages(null);
        this.dismiss();
    }

    public static class Model {
        private static final String TAB_NAME = "popularity_gift_tips_data";
        private static final String KEY_NEVER_SHOW_FIRST_GET = "never_show_first_get";
        private static final String KEY_NEVER_SHOW_FIRST_DATE_LOGIN = "never_show_first_date_login";
        private static final String KEY_NEVER_SHOW_FIRST_DATE_UNLOGIN = "never_show_first_date_un_login";
        private static final String KEY_NEVER_SHOW_UN_LOGIN = "never_show_un_login";

        public static void neverShowFirstGetTips() {
            SharedPreferencesUtils.setSharedPreferences(TAB_NAME, KEY_NEVER_SHOW_FIRST_GET, true);
        }

        public static boolean isNeverShowFirstGetTips() {
            return SharedPreferencesUtils.getSharedPreferencesBoolean(TAB_NAME, KEY_NEVER_SHOW_FIRST_GET, false);
        }

        public static void setFirstShowDate(boolean isLogin) {
            String key = "";
            key = isLogin ? KEY_NEVER_SHOW_FIRST_DATE_LOGIN : KEY_NEVER_SHOW_FIRST_DATE_UNLOGIN;
            String todayDate = DateUtils.dateToString((Date)new Date(), (String)"yyyyMMdd");
            SharedPreferencesUtils.setSharedPreferences(TAB_NAME, key, todayDate);
        }

        public static boolean isShowFirstToday(boolean isLogin) {
            String key = "";
            key = isLogin ? KEY_NEVER_SHOW_FIRST_DATE_LOGIN : KEY_NEVER_SHOW_FIRST_DATE_UNLOGIN;
            String todayDate = DateUtils.dateToString((Date)new Date(), (String)"yyyyMMdd");
            String localDate = SharedPreferencesUtils.getSharedPreferencesValue(TAB_NAME, key, "");
            if (localDate == null) {
                localDate = "";
            }
            return localDate.equals(todayDate);
        }
    }
}

