/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.gifttarget;

import android.view.animation.AnimationUtils;
import com.unionyy.mobile.meipai.gift.animation.BaseAnimation;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.ImageTarget;
import com.unionyy.mobile.meipai.gift.animation.view.GlAnimationView;
import com.unionyy.mobile.meipai.gift.animation.view.opengl.TextureIdManager;
import com.unionyy.mobile.meipai.gift.animation.view.opengl.TextureLayer;
import com.yy.mobile.config.BasicConfig;

public class GlImageTarget
extends ImageTarget {
    public static final float TOLERANCE = 5.0E-4f;
    private Object drawable;
    private TextureLayer mTextureLayer;
    private TextureIdManager.TextureData mTextureData;
    private boolean isDrawWhenLoadBitmap = true;
    private int mFrameNumber;
    private int mLoopFrom;
    private int mLoopTo;
    private int mWidthFrames;
    private int mHeightFrames;
    private int mFrameRate;
    private int mCurrentFrame;
    private int mLoopMode;
    private float mPerFrameWidth;
    private float mPerFrameHeight;
    private boolean isStartLoop;
    private boolean isPlayingBackWards;
    private boolean mStartPlayGif;
    private long mStartTime = -1L;
    public OnLoadImageFailedListener mOnLoadImageFailedListener = null;

    public void addDrawable(Object drawable2) {
        this.drawable = drawable2;
    }

    public Object getDrawable() {
        return this.drawable;
    }

    private void nextFrame() {
        if (this.mStartPlayGif && this.mFrameNumber > 0 && this.mFrameRate > 0) {
            long currentTime = AnimationUtils.currentAnimationTimeMillis();
            if (this.mStartTime <= 0L || currentTime > this.mStartTime + (long)this.mFrameRate) {
                float x = (float)((this.mCurrentFrame - 1) % this.mWidthFrames) * this.mPerFrameWidth;
                float y = (float)((this.mCurrentFrame - 1) / this.mWidthFrames) * this.mPerFrameHeight;
                this.mStartTime = currentTime;
                this.setTextureMapping(x + 5.0E-4f, y + 5.0E-4f, x + this.mPerFrameWidth - 5.0E-4f, y + this.mPerFrameHeight - 5.0E-4f);
                this.mCurrentFrame += this.isPlayingBackWards ? -1 : 1;
                if (this.isStartLoop && (!this.isPlayingBackWards && this.mCurrentFrame > this.mLoopTo || this.isPlayingBackWards && this.mCurrentFrame < this.mLoopFrom) || this.mCurrentFrame > this.mFrameNumber) {
                    if (this.mLoopFrom > 0) {
                        if (this.mLoopMode > 0) {
                            this.mCurrentFrame = this.isStartLoop || this.mLoopTo == this.mFrameNumber ? (this.isPlayingBackWards ? this.mLoopFrom + 1 : this.mLoopTo - 1) : this.mLoopTo;
                            this.isPlayingBackWards = !this.isPlayingBackWards;
                        } else {
                            this.mCurrentFrame = this.mLoopFrom;
                        }
                        this.isStartLoop = true;
                    } else {
                        this.mCurrentFrame = this.mFrameNumber;
                    }
                }
            }
        }
    }

    public void onTextureDraw(GlAnimationView gl, int z) {
        TextureLayer textureLayer = this.mTextureLayer;
        BaseAnimation animation = this.getAnimation();
        if (textureLayer == null) {
            this.mTextureLayer = textureLayer = new TextureLayer();
            this.mTextureLayer.setIsDrawWhenLoadBitmap(this.isDrawWhenLoadBitmap);
            if (this.mPerFrameWidth > 0.0f && this.mPerFrameHeight > 0.0f) {
                this.setTextureMapping(0.0f, 0.0f, this.mPerFrameWidth, this.mPerFrameHeight);
            }
        }
        textureLayer.setZTrans(1.0f + (float)z / 10.0f);
        if (animation != null) {
            animation.requestRender();
        }
        this.nextFrame();
        this.doDraw(gl);
    }

    private TextureIdManager.TextureData createTextureData(GlAnimationView gl) {
        if (this.mTextureData == null && this.getDrawable() != null) {
            TextureIdManager textureIdManager = gl.getTextureIdManager();
            TextureIdManager.TextureData textureData = textureIdManager.getResourceData(BasicConfig.getInstance().getAppContext(), this.getDrawable(), this.getWidth(), this.getHeight());
            if (textureData == null && this.mOnLoadImageFailedListener != null) {
                this.mOnLoadImageFailedListener.onLoadFailed();
                this.mOnLoadImageFailedListener = null;
            }
            this.mTextureData = textureData;
        }
        if (this.mTextureData != null) {
            this.mTextureData.width = gl.getGlImageWidth(this.getWidth());
            this.mTextureData.height = gl.getGlImageHeight(this.getHeight());
        }
        return this.mTextureData;
    }

    private void doDraw(GlAnimationView gl) {
        TextureIdManager.TextureData textureData = this.createTextureData(gl);
        if (textureData != null) {
            this.mTextureLayer.setTextureData(textureData);
            this.mTextureLayer.setAlpha(this.getAlpha());
            this.mTextureLayer.setTranslate(gl.getGlCoordinatesX(this.getTranslationX() + this.getX()), gl.getGlCoordinatesY(this.getTranslationY() + this.getY()));
            this.mTextureLayer.setRotate(this.getRotation());
            this.mTextureLayer.setScale(this.getScaleX(), this.getScaleY());
            this.mTextureLayer.drawSelf(gl.getCanvas());
        }
    }

    public void setGifParams(int frameNumber, int frameRate, int loopMode, int loopFrom, int loopTo, int hFrames, int vFrames) {
        this.mLoopMode = loopMode;
        this.mFrameNumber = frameNumber;
        this.mFrameRate = 1000 / frameRate;
        this.mLoopFrom = loopFrom;
        this.mLoopTo = loopTo;
        this.mWidthFrames = hFrames;
        this.mHeightFrames = vFrames;
        this.mPerFrameWidth = 1.0f / (float)hFrames;
        this.mPerFrameHeight = 1.0f / (float)vFrames;
        this.mCurrentFrame = 1;
        this.isStartLoop = false;
        this.mStartPlayGif = false;
        this.isPlayingBackWards = false;
        if (this.mPerFrameWidth > 0.0f && this.mPerFrameHeight > 0.0f) {
            this.setTextureMapping(0.0f, 0.0f, this.mPerFrameWidth, this.mPerFrameHeight);
        }
    }

    public void startGifAnimation() {
        this.mStartPlayGif = true;
    }

    public void setIsDrawWhenLoadBitmap(boolean isDraw) {
        if (this.mTextureLayer != null) {
            this.mTextureLayer.setIsDrawWhenLoadBitmap(isDraw);
        }
        this.isDrawWhenLoadBitmap = isDraw;
    }

    public void setTextureMapping(float left, float top, float right, float bottom) {
        if (this.mTextureLayer != null) {
            this.mTextureLayer.setTextureMapping(left, top, right, bottom);
        }
    }

    public void setTextureData(TextureIdManager.TextureData data) {
        this.mTextureData = data;
    }

    public boolean isAnimationEnd() {
        BaseAnimation baseAnimation = this.getAnimation();
        if (baseAnimation != null) {
            return baseAnimation.isAnimationEnd();
        }
        return false;
    }

    public void setOnLoadImageFailedListener(OnLoadImageFailedListener listener2) {
        this.mOnLoadImageFailedListener = listener2;
    }

    public static interface OnLoadImageFailedListener {
        public void onLoadFailed();
    }
}

