/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view.opengl;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.unionyy.mobile.meipai.gift.animation.view.opengl.TextureLruCache;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TextureIdManager {
    private static final float MAX_CACHE_PERCENT = 20.0f;
    private TextureLruCache textureMap = new TextureLruCache(this.getMaxCacheSize()){

        protected void entryRemoved(boolean evicted, Object key, TextureData oldValue, TextureData newValue) {
            super.entryRemoved(evicted, key, (Object)oldValue, (Object)newValue);
            if (oldValue != null) {
                if (oldValue.bitmap != null && !oldValue.bitmap.isRecycled()) {
                    oldValue.bitmap.recycle();
                    oldValue.bitmap = null;
                } else {
                    GLES20.glDeleteTextures((int)1, (int[])new int[]{oldValue.textureId}, (int)0);
                }
            }
        }
    };

    private int getMaxCacheSize() {
        long availableMemory = Runtime.getRuntime().maxMemory();
        int memoryCacheSize = (int)((float)availableMemory * 0.2f);
        return memoryCacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureData getResourceData(Context context, Object resource, int resourceWidth, int resourecHeight) {
        if (this.textureMap.get(resource) != null) {
            return (TextureData)this.textureMap.get(resource);
        }
        TextureData data = new TextureData();
        InputStream is = null;
        Bitmap bitmapTmp = null;
        try {
            if (resource instanceof Integer) {
                is = context.getResources().openRawResource(((Integer)resource).intValue());
                bitmapTmp = BitmapFactory.decodeStream((InputStream)is);
            } else if (resource instanceof String) {
                is = new FileInputStream((String)resource);
                bitmapTmp = BitmapFactory.decodeStream((InputStream)is);
            } else if (resource instanceof Bitmap) {
                bitmapTmp = (Bitmap)resource;
            }
        }
        catch (IOException e) {
        }
        catch (OutOfMemoryError e) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (bitmapTmp == null) {
            return null;
        }
        data.bitmap = bitmapTmp;
        data.size = this.getBitmapSize(bitmapTmp);
        this.textureMap.put(resource, data);
        return data;
    }

    public int getBitmapSize(Bitmap bitmap) {
        return bitmap != null ? bitmap.getRowBytes() * bitmap.getHeight() : 0;
    }

    public static int initTexture(Bitmap bitmapTmp) {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        int textureId = textures[0];
        GLES20.glBindTexture((int)3553, (int)textureId);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmapTmp, (int)0);
        bitmapTmp.recycle();
        return textureId;
    }

    public static class TextureData {
        public int textureId;
        public int size;
        public float width;
        public float height;
        public Bitmap bitmap;
    }
}

