/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.viewdelegate;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.pk.ui.model.PkStatusInfo;
import com.unionyy.mobile.meipai.pk.ui.viewdelegate.BaseViewUpdateDelegate;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;

public class EndingAnimationUpdateDelegate
extends BaseViewUpdateDelegate {
    private static final String TAG = "EndingAnimationUpdateDelegate";
    private LinearLayout mLiveEndLayout;
    private ImageView mLeftRedEndImage;
    private ImageView mRightBlueEndImage;
    AnimatorSet animatorSet = null;
    private Handler mHandler;
    private final int ALPHA_DURATION = 400;
    private final int STATIC_DURATION = 700;
    private final int TRANS_DURATION = 500;
    private boolean isPlayed;
    private int lastType;

    public EndingAnimationUpdateDelegate(View rootView, FragmentActivity activity, int videoMarginTop) {
        super(rootView, activity, videoMarginTop);
        this.mLiveEndLayout = (LinearLayout)rootView.findViewById(R.id.live_end_layout);
        this.mHandler = new SafeDispatchHandler(Looper.getMainLooper());
    }

    @Override
    public void onInit() {
        super.onInit();
        this.setEndImageTopMargin(this.getVideoHeight() / 2 + this.getVideoMarginTop() - ScreenUtil.getInstance().dip2px(55));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        PkStatusInfo info = this.core.getPkStatusInfo();
        if (!this.isPlayed && info.type == 6) {
            this.isPlayed = true;
            this.doEndingAnimation(info.endResult);
        } else if ((info.type == 4 || info.type == 5) && this.isPlayed) {
            this.clear();
        }
        this.lastType = info.type;
    }

    @Override
    public void onStateChanged(int lastState, int curState) {
        super.onStateChanged(lastState, curState);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.clear();
    }

    @Override
    public void onClosePk() {
        super.onClosePk();
        PkStatusInfo info = this.core.getPkStatusInfo();
        if (this.lastType == 5 || this.lastType == 6 || this.lastType == 4) {
            if (info.isAheadStopInPk()) {
                this.doUnNormalEndAnimation(info.endResult);
                this.isPlayed = true;
            } else if (this.isPlayed) {
                this.clear();
            }
        }
        this.lastType = info.type;
    }

    private void setEndImageTopMargin(int topMargin) {
        if (null != this.mLiveEndLayout) {
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mLiveEndLayout.getLayoutParams();
            layoutParams.topMargin = topMargin;
            this.mLiveEndLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    private ImageView createEndImageView() {
        if (null == this.mLiveEndLayout) {
            return null;
        }
        ImageView imageView = new ImageView(this.mLiveEndLayout.getContext());
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, (int)this.mLiveEndLayout.getContext().getResources().getDimension(R.dimen.meipai_pk_end_img_h));
        params.weight = 1.0f;
        imageView.setLayoutParams((ViewGroup.LayoutParams)params);
        return imageView;
    }

    public void doEndingAnimation(int isSucc) {
        MLog.info((Object)TAG, (String)"[PK][\u64ad\u653e\u60e9\u7f5a\u9636\u6bb5\u7ed3\u679c\u52a8\u753b]", (Object[])new Object[0]);
        if (null == this.mLiveEndLayout) {
            return;
        }
        this.mLiveEndLayout.removeAllViews();
        this.mLeftRedEndImage = this.createEndImageView();
        this.mRightBlueEndImage = this.createEndImageView();
        if (isSucc == 1) {
            this.mLeftRedEndImage.setImageResource(R.drawable.meipai_pk_end_succ);
            this.mRightBlueEndImage.setImageResource(R.drawable.meipai_pk_end_failed);
        } else if (isSucc == 2) {
            this.mLeftRedEndImage.setImageResource(R.drawable.meipai_pk_end_failed);
            this.mRightBlueEndImage.setImageResource(R.drawable.meipai_pk_end_succ);
        } else if (isSucc == 0) {
            this.mLeftRedEndImage.setImageResource(R.drawable.meipai_pk_end_draw);
            this.mRightBlueEndImage.setImageResource(R.drawable.meipai_pk_end_draw);
        }
        this.mLiveEndLayout.addView((View)this.mLeftRedEndImage);
        this.mLiveEndLayout.addView((View)this.mRightBlueEndImage);
        ObjectAnimator leftAlpha = ObjectAnimator.ofFloat((Object)this.mLeftRedEndImage, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        leftAlpha.setDuration(400L);
        ObjectAnimator rightAlpha = ObjectAnimator.ofFloat((Object)this.mRightBlueEndImage, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        rightAlpha.setDuration(400L);
        ObjectAnimator leftScaleX = ObjectAnimator.ofFloat((Object)this.mLeftRedEndImage, (String)"scaleX", (float[])new float[]{0.0f, 1.0f});
        leftScaleX.setDuration(400L);
        ObjectAnimator leftScaleY = ObjectAnimator.ofFloat((Object)this.mLeftRedEndImage, (String)"scaleY", (float[])new float[]{0.0f, 1.0f});
        leftScaleY.setDuration(400L);
        ObjectAnimator rightScaleX = ObjectAnimator.ofFloat((Object)this.mRightBlueEndImage, (String)"scaleX", (float[])new float[]{0.0f, 1.0f});
        rightScaleX.setDuration(400L);
        ObjectAnimator rightScaleY = ObjectAnimator.ofFloat((Object)this.mRightBlueEndImage, (String)"scaleY", (float[])new float[]{0.0f, 1.0f});
        rightScaleY.setDuration(400L);
        ObjectAnimator leftScaleX_S = ObjectAnimator.ofFloat((Object)this.mLeftRedEndImage, (String)"scaleX", (float[])new float[]{1.0f, 0.75f, 0.9f, 0.75f});
        leftScaleX_S.setDuration(700L);
        ObjectAnimator leftScaleY_S = ObjectAnimator.ofFloat((Object)this.mLeftRedEndImage, (String)"scaleY", (float[])new float[]{1.0f, 0.75f, 0.9f, 0.75f});
        leftScaleY_S.setDuration(700L);
        ObjectAnimator rightScaleX_S = ObjectAnimator.ofFloat((Object)this.mRightBlueEndImage, (String)"scaleX", (float[])new float[]{1.0f, 0.75f, 0.9f, 0.75f});
        rightScaleX_S.setDuration(700L);
        ObjectAnimator rightScaleY_S = ObjectAnimator.ofFloat((Object)this.mRightBlueEndImage, (String)"scaleY", (float[])new float[]{1.0f, 0.75f, 0.9f, 0.75f});
        rightScaleY_S.setDuration(700L);
        ObjectAnimator leftAlpha_T = ObjectAnimator.ofFloat((Object)this.mLeftRedEndImage, (String)"alpha", (float[])new float[]{1.0f, 0.75f});
        leftAlpha_T.setDuration(500L);
        ObjectAnimator rightAlpha_T = ObjectAnimator.ofFloat((Object)this.mRightBlueEndImage, (String)"alpha", (float[])new float[]{1.0f, 0.75f});
        rightAlpha_T.setDuration(500L);
        ObjectAnimator leftTransX_T = ObjectAnimator.ofFloat((Object)this.mLeftRedEndImage, (String)"translationX", (float[])new float[]{0.0f, -ScreenUtil.getInstance().getWidthPixels() / 4 + ScreenUtil.getInstance().dip2px(43)});
        leftTransX_T.setDuration(500L);
        ObjectAnimator leftTransY_T = ObjectAnimator.ofFloat((Object)this.mLeftRedEndImage, (String)"translationY", (float[])new float[]{0.0f, ScreenUtil.getInstance().dip2px(100)});
        leftTransY_T.setDuration(500L);
        ObjectAnimator rightTransX_T = ObjectAnimator.ofFloat((Object)this.mRightBlueEndImage, (String)"translationX", (float[])new float[]{0.0f, ScreenUtil.getInstance().getWidthPixels() / 4 - ScreenUtil.getInstance().dip2px(43)});
        rightTransX_T.setDuration(500L);
        ObjectAnimator rightTransY_T = ObjectAnimator.ofFloat((Object)this.mRightBlueEndImage, (String)"translationY", (float[])new float[]{0.0f, ScreenUtil.getInstance().dip2px(100)});
        rightTransY_T.setDuration(500L);
        rightTransY_T.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
            }
        });
        if (this.animatorSet != null) {
            this.animatorSet.cancel();
        }
        this.animatorSet = new AnimatorSet();
        this.animatorSet.play((Animator)leftAlpha).with((Animator)rightAlpha);
        this.animatorSet.play((Animator)rightAlpha).with((Animator)leftScaleX);
        this.animatorSet.play((Animator)leftScaleX).with((Animator)leftScaleY);
        this.animatorSet.play((Animator)leftScaleY).with((Animator)rightScaleX);
        this.animatorSet.play((Animator)rightScaleX).with((Animator)rightScaleY);
        this.animatorSet.play((Animator)leftScaleX_S).after((Animator)rightScaleX);
        this.animatorSet.play((Animator)leftScaleX_S).with((Animator)leftScaleY_S);
        this.animatorSet.play((Animator)leftScaleY_S).with((Animator)rightScaleX_S);
        this.animatorSet.play((Animator)rightScaleX_S).with((Animator)rightScaleY_S);
        this.animatorSet.play((Animator)leftAlpha_T).after((Animator)rightScaleX_S);
        this.animatorSet.play((Animator)leftAlpha_T).with((Animator)rightAlpha_T);
        this.animatorSet.play((Animator)rightAlpha_T).with((Animator)leftTransX_T);
        this.animatorSet.play((Animator)leftTransX_T).with((Animator)leftTransY_T);
        this.animatorSet.play((Animator)leftTransY_T).with((Animator)rightTransX_T);
        this.animatorSet.play((Animator)rightTransX_T).with((Animator)rightTransY_T);
        this.animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.animatorSet.start();
    }

    public void doUnNormalEndAnimation(int isSucc) {
        MLog.info((Object)TAG, (String)"[PK][\u64ad\u653e\u63d0\u524d\u7ed3\u675f\u7ed3\u679c\u52a8\u753b]", (Object[])new Object[0]);
        if (null == this.mLiveEndLayout) {
            return;
        }
        this.mLiveEndLayout.removeAllViews();
        this.mLeftRedEndImage = this.createEndImageView();
        if (isSucc == 1) {
            this.mLeftRedEndImage.setImageResource(R.drawable.meipai_pk_end_succ);
        } else if (isSucc == 2) {
            this.mLeftRedEndImage.setImageResource(R.drawable.meipai_pk_end_failed);
        } else if (isSucc == 0) {
            this.mLeftRedEndImage.setImageResource(R.drawable.meipai_pk_end_draw);
        }
        this.mLiveEndLayout.addView((View)this.mLeftRedEndImage);
        ObjectAnimator leftAlpha = ObjectAnimator.ofFloat((Object)this.mLeftRedEndImage, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        leftAlpha.setDuration(400L);
        ObjectAnimator leftScaleX = ObjectAnimator.ofFloat((Object)this.mLeftRedEndImage, (String)"scaleX", (float[])new float[]{0.0f, 1.0f});
        leftScaleX.setDuration(400L);
        ObjectAnimator leftScaleY = ObjectAnimator.ofFloat((Object)this.mLeftRedEndImage, (String)"scaleY", (float[])new float[]{0.0f, 1.0f});
        leftScaleY.setDuration(400L);
        ObjectAnimator leftScaleX_S = ObjectAnimator.ofFloat((Object)this.mLeftRedEndImage, (String)"scaleX", (float[])new float[]{1.0f, 0.75f, 0.9f, 0.75f});
        leftScaleX_S.setDuration(700L);
        ObjectAnimator leftScaleY_S = ObjectAnimator.ofFloat((Object)this.mLeftRedEndImage, (String)"scaleY", (float[])new float[]{1.0f, 0.75f, 0.9f, 0.75f});
        leftScaleY_S.setDuration(700L);
        ObjectAnimator leftAlpha_T = ObjectAnimator.ofFloat((Object)this.mLeftRedEndImage, (String)"alpha", (float[])new float[]{1.0f, 0.75f});
        leftAlpha_T.setDuration(500L);
        ObjectAnimator leftTransY_T = ObjectAnimator.ofFloat((Object)this.mLeftRedEndImage, (String)"translationY", (float[])new float[]{0.0f, ScreenUtil.getInstance().dip2px(90)});
        leftTransY_T.setDuration(500L);
        if (this.animatorSet != null) {
            this.animatorSet.cancel();
        }
        this.animatorSet = new AnimatorSet();
        this.animatorSet.play((Animator)leftAlpha).with((Animator)leftScaleX).with((Animator)leftScaleY);
        this.animatorSet.play((Animator)leftScaleX_S).after((Animator)leftAlpha);
        this.animatorSet.play((Animator)leftScaleX_S).with((Animator)leftScaleY_S);
        this.animatorSet.play((Animator)leftAlpha_T).after((Animator)leftScaleX_S);
        this.animatorSet.play((Animator)leftAlpha_T).with((Animator)leftTransY_T);
        this.animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.animatorSet.start();
        leftTransY_T.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
            }
        });
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (EndingAnimationUpdateDelegate.this.mLeftRedEndImage != null) {
                    EndingAnimationUpdateDelegate.this.mLeftRedEndImage.setVisibility(8);
                }
                if (null != EndingAnimationUpdateDelegate.this.mLiveEndLayout) {
                    EndingAnimationUpdateDelegate.this.mLiveEndLayout.removeAllViews();
                }
                EndingAnimationUpdateDelegate.this.mLeftRedEndImage = null;
            }
        }, 30000L);
    }

    private void clear() {
        this.isPlayed = false;
        this.mHandler.removeCallbacksAndMessages(null);
        if (null != this.mRightBlueEndImage) {
            this.mRightBlueEndImage.clearAnimation();
            this.mRightBlueEndImage.setVisibility(8);
        }
        if (null != this.mLeftRedEndImage) {
            this.mLeftRedEndImage.clearAnimation();
            this.mLeftRedEndImage.setVisibility(8);
        }
        if (this.mLiveEndLayout != null) {
            this.mLiveEndLayout.clearAnimation();
            this.mLiveEndLayout.removeAllViews();
        }
    }
}

