/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.down;

import com.unionyy.mobile.meipai.gift.down.PriorityRunnable;
import java.util.Comparator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class PriorityExecutor
extends ThreadPoolExecutor {
    private static final int MAX_CORE_POOL_SIZE = 20;
    private static final int MAXIMUM_POOL_SIZE = 30;
    private static final int KEEP_ALIVE = 1;
    private static final AtomicLong SEQ_SEED = new AtomicLong(0L);
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable runnable2) {
            return new Thread(runnable2, "download#" + this.mCount.getAndIncrement());
        }
    };
    private static final Comparator<Runnable> FIFO = new Comparator<Runnable>(){

        @Override
        public int compare(Runnable lhs, Runnable rhs) {
            if (lhs instanceof PriorityRunnable && rhs instanceof PriorityRunnable) {
                PriorityRunnable lpr = (PriorityRunnable)lhs;
                PriorityRunnable rpr = (PriorityRunnable)rhs;
                int result = lpr.getMDownloadPriority().ordinal() - rpr.getMDownloadPriority().ordinal();
                return result == 0 ? (int)(lpr.getSEQ() - rpr.getSEQ()) : result;
            }
            return 0;
        }
    };
    private static final Comparator<Runnable> LIFO = new Comparator<Runnable>(){

        @Override
        public int compare(Runnable lhs, Runnable rhs) {
            if (lhs instanceof PriorityRunnable && rhs instanceof PriorityRunnable) {
                PriorityRunnable lpr = (PriorityRunnable)lhs;
                PriorityRunnable rpr = (PriorityRunnable)rhs;
                int result = lpr.getMDownloadPriority().ordinal() - rpr.getMDownloadPriority().ordinal();
                return result == 0 ? (int)(rpr.getSEQ() - lpr.getSEQ()) : result;
            }
            return 0;
        }
    };

    public PriorityExecutor(boolean fifo) {
        this(20, fifo);
    }

    public PriorityExecutor(int poolSize, boolean fifo) {
        this(poolSize, 20, 1L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(30, fifo ? FIFO : LIFO), sThreadFactory);
    }

    public PriorityExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public boolean isBusy() {
        return this.getActiveCount() >= this.getCorePoolSize();
    }

    @Override
    public void execute(Runnable runnable2) {
        if (runnable2 instanceof PriorityRunnable) {
            ((PriorityRunnable)runnable2).setSEQ(SEQ_SEED.getAndIncrement());
        }
        super.execute(runnable2);
    }
}

