/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.dispatcher;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.ViewGroup;
import com.unionyy.mobile.meipai.gift.animation.callback.VipAnimBannerCallback;
import com.unionyy.mobile.meipai.gift.animation.decoder.INGiftAnimateDecoder;
import com.unionyy.mobile.meipai.gift.animation.decoder.sub.LiveCarAnimateDecoder;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftTarget;
import com.unionyy.mobile.meipai.gift.animation.model.GiftMessage;
import com.unionyy.mobile.meipai.gift.animation.utils.FileUtils;
import com.unionyy.mobile.meipai.gift.animation.view.GiftAnimationLayout;
import com.unionyy.mobile.meipai.gift.animation.view.VipUserArrivedDisplay;
import com.unionyy.mobile.meipai.gift.data.bean.Medals;
import com.unionyy.mobile.meipai.gift.data.bean.MountCar;
import com.unionyy.mobile.meipai.gift.data.bean.UserIn;
import com.unionyy.mobile.meipai.gift.dispatcher.GiftMessageDispatcher;
import com.unionyy.mobile.meipai.gift.event.EventMountCarUserIn;
import com.unionyy.mobile.meipai.vehicle.VehicleManager;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;

public class MountCarQueue
implements GiftMessageDispatcher.IGiftDispatcherListener {
    private static final String TAG = "VipUser";
    private static final long MAX_GIFT_SIZE = (long)((float)Runtime.getRuntime().maxMemory() * 0.1f) / 4L;
    private VipUserArrivedDisplay mVipBannerDisplay;
    private GiftAnimationLayout mMountCarLayout;
    private LiveCarAnimateDecoder mLiveCarAnimateDecoder;
    private LinkedList<EventMountCarUserIn> mountCarList = new LinkedList();
    private LinkedList<EventMountCarUserIn> vipBannerList = new LinkedList();
    private static final int USER_IN = 2;
    private static final int USER_IN_WITH_BANNER = 4;
    private static final int USER_IN_WITH_MOUNT_CAR = 8;
    private static final int USER_GUARD = 16;
    public static final int USER_GIFT_EGG_BROADCAST = 32;
    private static MountCarQueue mInstance;
    private volatile long mCurrentGiftSize = 0L;
    private boolean isAnimateShowing = false;
    private boolean isMountCarAnimateShowing = false;
    Handler handler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (null != msg && null != msg.obj && msg.obj instanceof EventMountCarUserIn && null != MountCarQueue.this.mVipBannerDisplay) {
                MountCarQueue.this.doShowVipBanner((EventMountCarUserIn)msg.obj, msg.arg1 == 1);
            }
        }
    };
    private VipAnimBannerCallback bannerCallback = new VipAnimBannerCallback(){

        @Override
        public void onBannerDismissed() {
            MountCarQueue.this.isAnimateShowing = false;
            if (!MountCarQueue.this.isMountCarAnimateShowing) {
                MountCarQueue.this.callLoop();
            }
        }
    };

    public MountCarQueue(Context context, VipUserArrivedDisplay vipUserArrivedDisplay, GiftAnimationLayout mountCarLayout) {
        if (vipUserArrivedDisplay != null) {
            this.mVipBannerDisplay = vipUserArrivedDisplay;
            if (null != this.mVipBannerDisplay && null != this.mMountCarLayout) {
                this.mVipBannerDisplay.initView();
                this.mVipBannerDisplay.setCallback(this.bannerCallback);
                this.mVipBannerDisplay.visibleChange(this.mMountCarLayout.getVisibility() == 0);
            }
            this.mVipBannerDisplay.initView();
            this.mVipBannerDisplay.setCallback(this.bannerCallback);
        }
        this.mMountCarLayout = mountCarLayout;
        if (null != this.mMountCarLayout) {
            this.mLiveCarAnimateDecoder = new LiveCarAnimateDecoder(context, (ViewGroup)this.mMountCarLayout, this);
            this.mMountCarLayout.setMountCarDecoder(this.mLiveCarAnimateDecoder);
        }
    }

    public void setLiveUnifyDispatcherFragment(VipUserArrivedDisplay vipUserArrivedDisplay) {
        if (null != this.mVipBannerDisplay) {
            this.mVipBannerDisplay.clear();
            this.mVipBannerDisplay = null;
        }
        this.isAnimateShowing = false;
        if (null != vipUserArrivedDisplay) {
            this.mVipBannerDisplay = vipUserArrivedDisplay;
        }
        if (null != this.mVipBannerDisplay && null != this.mMountCarLayout) {
            this.mVipBannerDisplay.initView();
            this.mVipBannerDisplay.setCallback(this.bannerCallback);
            this.mVipBannerDisplay.visibleChange(this.mMountCarLayout.getVisibility() == 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewUserInfo(EventMountCarUserIn eventMountCarUserIn) {
        if (null == eventMountCarUserIn || eventMountCarUserIn.getType() == 2) {
            return;
        }
        MountCarQueue mountCarQueue = this;
        synchronized (mountCarQueue) {
            if ((eventMountCarUserIn.getType() & 8) == 8) {
                this.mountCarList.add(eventMountCarUserIn);
                Log.e((String)"VipUserArrivedDisplay", (String)"addNewUserInfo\uff1amountCarList");
            } else if ((eventMountCarUserIn.getType() & 0x10) == 16 || (eventMountCarUserIn.getType() & 4) == 4 || (eventMountCarUserIn.getType() & 0x20) == 32) {
                this.vipBannerList.add(eventMountCarUserIn);
                MLog.info((Object)"VipUserArrivedDisplay", (String)"addNewUserInfo\uff1avipbanner", (Object[])new Object[0]);
            }
        }
        this.callLoop();
    }

    private void callLoop() {
        if (this.isAnimateShowing || this.isMountCarAnimateShowing) {
            return;
        }
        Log.e((String)"VipUserArrivedDisplay", (String)("isAnimateShowing\uff1a" + this.isAnimateShowing + ",isMountCarAnimateShowing:" + this.isMountCarAnimateShowing));
        if (this.mountCarList.size() > 0) {
            EventMountCarUserIn eventMountCarUserIn = this.mountCarList.pollFirst();
            if (this.checkEventEnable(eventMountCarUserIn, true)) {
                this.isAnimateShowing = true;
                this.isMountCarAnimateShowing = true;
                this.doShowMountCar(eventMountCarUserIn);
                return;
            }
            this.callLoop();
            return;
        }
        if (this.vipBannerList.size() > 0) {
            EventMountCarUserIn eventMountCarUserIn = this.vipBannerList.pollFirst();
            if (this.checkEventEnable(eventMountCarUserIn, false)) {
                this.isAnimateShowing = true;
                if (null != this.handler) {
                    Message message = new Message();
                    message.obj = eventMountCarUserIn;
                    message.arg1 = 0;
                    this.handler.sendMessage(message);
                }
                return;
            }
            this.callLoop();
            return;
        }
    }

    @Override
    public INGiftAnimateDecoder findDecoderDealGiftMessage(GiftMessage message) {
        return this.mLiveCarAnimateDecoder;
    }

    private boolean checkEventEnable(EventMountCarUserIn eventMountCarUserIn, boolean isMount) {
        if (null == eventMountCarUserIn) {
            return false;
        }
        if (isMount) {
            MountCar mountCar = eventMountCarUserIn.getMounts();
            return this.checkUserInfo(eventMountCarUserIn) && this.checkMountCar(mountCar);
        }
        return this.checkUserInfo(eventMountCarUserIn);
    }

    private boolean checkUserInfo(EventMountCarUserIn eventMountCarUserIn) {
        UserIn user = eventMountCarUserIn.getUser();
        return user != null && !TextUtils.isEmpty((CharSequence)user.getNick());
    }

    private boolean checkMountCar(MountCar mountCar) {
        if (null == mountCar) {
            return false;
        }
        return mountCar.getId() > 0L && this.isAimPathExistMaterial(this.getMaterialPath(mountCar.getId()));
    }

    private void doShowMountCar(EventMountCarUserIn eventMountCarUserIn) {
        if (null == this.mLiveCarAnimateDecoder) {
            return;
        }
        if (null != this.handler) {
            Message message = new Message();
            message.obj = eventMountCarUserIn;
            message.arg1 = 1;
            this.handler.sendMessage(message);
        }
        MountCar mountCar = eventMountCarUserIn.getMounts();
        GiftMessage giftMessage = new GiftMessage(mountCar.getId() + "", this.getMaterialPath(mountCar.getId()));
        giftMessage.setGift_type(1);
        new LoadMountCarResourceTask().execute(new GiftMessage[]{giftMessage});
    }

    private void doShowVipBanner(EventMountCarUserIn eventMountCarUserIn, boolean isMount) {
        UserIn user = eventMountCarUserIn.getUser();
        MountCar mountCar = eventMountCarUserIn.getMounts();
        String action = isMount ? mountCar.getAction() : "";
        String mount_name = isMount ? mountCar.getName() : "";
        boolean isGuard = false;
        Medals medals = null;
        if (null != user) {
            medals = user.getMedals();
            isGuard = this.isGuard(user);
        }
        VipUserArrivedDisplay.VipUser vipUser = new VipUserArrivedDisplay.VipUser(user.getLevel(), user.getNick(), action, mount_name, isMount, null != medals ? medals.getGuard() : 0, isGuard);
        if (eventMountCarUserIn.getType() == 32) {
            vipUser.isGiftEggBroadCast = true;
            vipUser.giftEggTaskName = user.getExtendsInfoByKey("GiftEggTaskNameKey");
        }
        if (null != this.mVipBannerDisplay) {
            this.mVipBannerDisplay.addUser(vipUser);
        }
    }

    private boolean isGuard(UserIn user) {
        Medals medals = user.getMedals();
        boolean isGuard = null != medals && (medals.getGuard() == 2 || medals.getGuard() == 1);
        return isGuard;
    }

    public boolean receivedGiftMessage(GiftMessage giftMessage) {
        return true;
    }

    public boolean receivedGiftMessage(ArrayList<GiftMessage> list2) {
        return true;
    }

    public void visibleChange(boolean isShow) {
        if (null != this.mMountCarLayout) {
            this.mMountCarLayout.setVisibility(isShow ? 0 : 8);
        }
    }

    public void clearWhenOutRoom() {
        this.handler.removeCallbacksAndMessages(null);
        this.clear();
        this.isAnimateShowing = false;
        this.isMountCarAnimateShowing = false;
    }

    public void callOnGiftImageAnimDismisss() {
        this.isMountCarAnimateShowing = false;
        if (this.isAnimateShowing && this.mVipBannerDisplay != null) {
            this.mVipBannerDisplay.clear();
            this.isAnimateShowing = false;
        }
        if (this.mountCarList.size() > 0 || this.vipBannerList.size() > 0) {
            this.callLoop();
        }
    }

    public void clear() {
        if (null != this.mountCarList) {
            this.mountCarList.clear();
        }
        if (null != this.vipBannerList) {
            this.vipBannerList.clear();
        }
        this.setMemorySizeZero();
        this.callHasEmptyImagePlayer();
        if (this.mVipBannerDisplay != null) {
            this.mVipBannerDisplay.clear();
            this.mVipBannerDisplay = null;
        }
        if (null != this.mLiveCarAnimateDecoder) {
            this.mLiveCarAnimateDecoder.clear();
        }
    }

    public void release() {
        this.clear();
        if (null != this.mLiveCarAnimateDecoder) {
            this.mLiveCarAnimateDecoder.release();
        }
    }

    public synchronized void setMemorySizeZero() {
        this.mCurrentGiftSize = 0L;
    }

    public synchronized void addMemoryUsage(long used) {
        this.mCurrentGiftSize += used;
    }

    public synchronized void callHasEmptyImagePlayer() {
    }

    public synchronized void reduceMemoryUsage(long used) {
        this.mCurrentGiftSize -= used;
    }

    private String getMaterialPath(long id2) {
        StringBuilder sb = new StringBuilder();
        sb.append(VehicleManager.STICKER_PATH);
        sb.append(id2);
        sb.append(File.separator);
        return sb.toString();
    }

    private boolean isAimPathExistMaterial(String path) {
        if (!FileUtils.isFileExist(path) || FileUtils.judgeFileIsNull(path)) {
            return false;
        }
        ArrayList<String> files2 = this.getListFilesOnExternalStorage(path);
        if (files2 != null && !files2.isEmpty()) {
            for (String f : files2) {
                if (!f.contains(".zip") && !f.contains(".ZIP")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private ArrayList<String> getListFilesOnExternalStorage(String filePath) {
        if (!FileUtils.isFileExist(filePath)) {
            return null;
        }
        ArrayList<String> fileArray = new ArrayList<String>();
        File file = new File(filePath);
        File[] files2 = file.listFiles();
        if (null != files2) {
            int count = files2.length;
            for (int i = 0; i < count; ++i) {
                fileArray.add(files2[i].getPath());
            }
        }
        return fileArray;
    }

    private class LoadMountCarResourceTask
    extends AsyncTask<GiftMessage, Void, Boolean> {
        GiftTarget giftTarget;

        private LoadMountCarResourceTask() {
        }

        protected Boolean doInBackground(GiftMessage ... giftMessages) {
            if (null == giftMessages) {
                return false;
            }
            GiftMessage mountCarMsg = null;
            this.giftTarget = null;
            if (giftMessages.length >= 1) {
                mountCarMsg = giftMessages[0];
            }
            if (mountCarMsg == null) {
                return false;
            }
            GiftMessageDispatcher.GiftDispatchMessage message = MountCarQueue.this.mLiveCarAnimateDecoder.checkGiftNeedWatitForDispatch(mountCarMsg);
            if (null == message || null == message) {
                return false;
            }
            this.giftTarget = MountCarQueue.this.mLiveCarAnimateDecoder.loadGiftImageTarget(mountCarMsg, message.rule);
            if (this.giftTarget != null) {
                this.giftTarget.setMount(true);
                GiftMessageDispatcher.DispatcherAttachMessage dispatcherAttachMessage = new GiftMessageDispatcher.DispatcherAttachMessage();
                MountCarQueue.this.mLiveCarAnimateDecoder.doSomeWithGiftTargetByDispatcher(this.giftTarget, dispatcherAttachMessage);
            }
            return true;
        }

        protected void onPostExecute(Boolean aBoolean) {
            super.onPostExecute((Object)aBoolean);
            if (MountCarQueue.this.mLiveCarAnimateDecoder != null && this.giftTarget != null) {
                MountCarQueue.this.mLiveCarAnimateDecoder.addGiftTargetToGroup(this.giftTarget);
            }
        }
    }
}

