/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view.opengl;

import android.opengl.GLES20;
import com.unionyy.mobile.meipai.gift.animation.view.opengl.GLGraph;
import com.unionyy.mobile.meipai.gift.animation.view.opengl.GlProgramUtil;
import com.unionyy.mobile.meipai.gift.animation.view.opengl.MatrixState;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class GLCanvas {
    private static final int DEFAULT_VERTICES_COUNT = 2020;
    private static final int GRAPH_COUNT = 100;
    private int mProgram;
    private int maPositionHandle;
    private int maTexCoorHandle;
    private int usTexHandle;
    private int mAlphaHandle;
    private MatrixState mMatrixState;
    private FloatBuffer mVertexBuffer;
    private ShortBuffer mIndicesBuffer;
    private GLGraph[] mGlGraphs;
    private int mCount = 0;
    private int mVerticesCount = 0;

    public GLCanvas(MatrixState matrixState) {
        int verticesCount = 2020;
        ByteBuffer vbb = ByteBuffer.allocateDirect(verticesCount * 4);
        vbb.order(ByteOrder.nativeOrder());
        this.mVertexBuffer = vbb.asFloatBuffer();
        ByteBuffer ibb = ByteBuffer.allocateDirect(verticesCount * 4);
        ibb.order(ByteOrder.nativeOrder());
        this.mIndicesBuffer = ibb.asShortBuffer();
        this.mGlGraphs = new GLGraph[100];
        this.mMatrixState = matrixState;
        this.initShader(GlProgramUtil.getAlphaShaderProgram());
        this.mVertexBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.maPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.mVertexBuffer);
        this.mVertexBuffer.position(3);
        GLES20.glVertexAttribPointer((int)this.maTexCoorHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.mVertexBuffer);
        GLES20.glEnableVertexAttribArray((int)this.maPositionHandle);
        GLES20.glEnableVertexAttribArray((int)this.maTexCoorHandle);
    }

    private void initShader(int program) {
        this.mProgram = program;
        this.maPositionHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aPosition");
        this.maTexCoorHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aTexCoor");
        this.usTexHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"sTexture");
        this.mAlphaHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"alpha");
        GLES20.glUseProgram((int)this.mProgram);
    }

    public MatrixState getMatrixState() {
        return this.mMatrixState;
    }

    public void preDraw() {
        this.mIndicesBuffer.position(0);
        this.mVertexBuffer.position(0);
        this.mCount = 0;
        this.mVerticesCount = 0;
    }

    public void put(GLGraph glGraph) {
        if (this.mCount >= this.mGlGraphs.length) {
            return;
        }
        float[] vertices = glGraph.getVertices();
        short[] indices = glGraph.getIndices();
        int i = 0;
        while (i < indices.length) {
            int n = i++;
            indices[n] = (short)(indices[n] + this.mVerticesCount);
        }
        this.mVerticesCount += vertices.length / 5;
        this.mVertexBuffer.put(vertices);
        this.mIndicesBuffer.put(indices);
        this.mGlGraphs[this.mCount++] = glGraph;
    }

    public void draw() {
        if (this.mCount <= 0) {
            return;
        }
        int coutToDraw = 0;
        this.mIndicesBuffer.position(0);
        for (int i = 0; i < this.mCount; ++i) {
            GLGraph graph = this.mGlGraphs[i];
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)graph.getTextureId());
            GLES20.glUniform1i((int)this.usTexHandle, (int)0);
            GLES20.glUniform1f((int)this.mAlphaHandle, (float)graph.getAlpha());
            GLES20.glDrawElements((int)4, (int)(coutToDraw += graph.getIndices().length), (int)5123, (Buffer)this.mIndicesBuffer);
        }
    }
}

