/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.popularity.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;
import com.yy.mobile.config.BasicConfig;

public class CallProgressView
extends View {
    private static final String TAG = "PopularityGiftIconView";
    private static final int DEFAULT_STROKE_WIDTH = 2;
    private static final int DEFAULT_MAX_PROGRESS = 100;
    private static final int DEFAULT_PROGRESS = 0;
    public static final int NUM_TEXT_SIZE = 13;
    private Paint mRoundPaint;
    private Paint mRoundStrokPaint;
    private Paint mRoundProgressPaint;
    private int mRoundColor;
    private int mRoundStokeColor;
    private int mRoundProgressColorStart;
    private int mRoundProgressColorEnd;
    private float mRoundProgreStrokWidth = 0.0f;
    private int mMax;
    private int[] mGradientColors;
    private int mCurrentProgress;

    public CallProgressView(Context context) {
        this(context, null);
    }

    public CallProgressView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CallProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attributeSet, int defStyleAttr) {
        TypedArray mTypedArray = context.obtainStyledAttributes(attributeSet, R.styleable.live_PopularityGiftProgressView);
        this.mRoundColor = mTypedArray.getColor(R.styleable.live_PopularityGiftProgressView_live_roundColor, this.getResources().getColor(R.color.live_black40));
        this.mRoundStokeColor = mTypedArray.getColor(R.styleable.live_PopularityGiftProgressView_live_roundStokeColor, this.getResources().getColor(R.color.live_white10));
        this.mRoundProgressColorStart = mTypedArray.getColor(R.styleable.live_PopularityGiftProgressView_live_roundProgressColorStart, -16711936);
        this.mRoundProgressColorEnd = mTypedArray.getColor(R.styleable.live_PopularityGiftProgressView_live_roundProgressColorEnd, -65536);
        this.mRoundProgreStrokWidth = mTypedArray.getDimension(R.styleable.live_PopularityGiftProgressView_live_roundWidth, DeviceUtils.dip2fpx(BasicConfig.getInstance().getAppContext(), 2.0f));
        this.mMax = mTypedArray.getInteger(R.styleable.live_PopularityGiftProgressView_live_maxProgress, 100);
        this.mCurrentProgress = mTypedArray.getInt(R.styleable.live_PopularityGiftProgressView_live_curProgress, 0);
        mTypedArray.recycle();
        this.initPaint();
    }

    private void initPaint() {
        this.mRoundPaint = new Paint();
        this.mRoundPaint.setColor(this.mRoundColor);
        this.mRoundPaint.setAntiAlias(true);
        this.mRoundPaint.setStyle(Paint.Style.FILL);
        this.mRoundProgressPaint = new Paint();
        this.mRoundStrokPaint = new Paint();
        this.mRoundStrokPaint.setColor(this.mRoundStokeColor);
        this.mRoundStrokPaint.setStrokeWidth(this.mRoundProgreStrokWidth);
        this.mRoundStrokPaint.setStyle(Paint.Style.STROKE);
        this.mRoundStrokPaint.setAntiAlias(true);
        this.mRoundProgressPaint = new Paint();
        this.mRoundProgressPaint.setAntiAlias(true);
        this.mRoundProgressPaint.setColor(this.mRoundProgressColorStart);
        this.mRoundProgressPaint.setStyle(Paint.Style.STROKE);
        this.mRoundProgressPaint.setStrokeWidth(this.mRoundProgreStrokWidth);
        this.mGradientColors = new int[]{this.mRoundProgressColorStart, this.mRoundProgressColorEnd, this.mRoundProgressColorStart};
        this.mRoundProgressPaint.setDither(true);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int centerX = this.getWidth() / 2;
        int centerY = this.getHeight() / 2;
        int raidus = (int)((float)centerX - this.mRoundProgreStrokWidth / 2.0f);
        canvas.drawCircle((float)centerX, (float)centerY, (float)raidus, this.mRoundPaint);
        canvas.drawCircle((float)centerX, (float)centerY, (float)raidus, this.mRoundStrokPaint);
        float mCurrentDegree = (float)this.mCurrentProgress / (float)this.mMax * 360.0f;
        SweepGradient sweepGradient = new SweepGradient((float)(canvas.getWidth() / 2), (float)(canvas.getHeight() / 2), this.mGradientColors, null);
        Matrix matrix = new Matrix();
        matrix.setRotate(-90.0f, (float)centerX, (float)centerY);
        sweepGradient.setLocalMatrix(matrix);
        this.mRoundProgressPaint.setShader((Shader)sweepGradient);
        RectF rectF = new RectF(this.mRoundProgreStrokWidth / 2.0f, this.mRoundProgreStrokWidth / 2.0f, (float)this.getWidth() - this.mRoundProgreStrokWidth / 2.0f, (float)this.getHeight() - this.mRoundProgreStrokWidth / 2.0f);
        canvas.drawArc(rectF, -90.0f, mCurrentDegree, false, this.mRoundProgressPaint);
    }

    public int getMaxProgress() {
        return this.mMax;
    }

    public void setProgress(int progress) {
        this.mCurrentProgress = progress;
        this.invalidate();
    }
}

