/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.dialog;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.pk.core.IMeiPaiPkCore;
import com.unionyy.mobile.meipai.pk.core.MeiPaiPkProtocols;
import com.unionyy.mobile.meipai.pk.ui.dialog.Adapter.MeiPaiPKInviteOrientRecyclerAdapter;
import com.unionyy.mobile.meipai.pk.ui.dialog.Adapter.Model.MeiPaiPKInviteOrientRecyclerAdapterInfo;
import com.yy.mobile.ui.utils.ViewUtils;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Map;

public class MeiPaiPKInviteRecommendFragment
extends Fragment {
    private RecyclerView recyclerView;
    private RecyclerView.LayoutManager layoutManager;
    private SmartRefreshLayout searchRefresh;
    private TextView loadingTextView;
    private boolean isLoading = false;
    private CompositeDisposable compositeDisposable = new CompositeDisposable();
    private static final String TAG = "MeiPaiPKInviteRecommendFragment";
    public MeiPaiPKInviteOrientRecyclerAdapter recyclerAdapter;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.meipai_fragment_pk_invite_oriented, container, false);
        return rootView;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        MeiPaiPKInviteOrientRecyclerAdapter adapter;
        super.onViewCreated(view, savedInstanceState);
        this.searchRefresh = (SmartRefreshLayout)view.findViewById(R.id.meipai_pk_invate_oriented_smartRefreshLayout);
        this.searchRefresh.setEnableRefresh(false);
        this.searchRefresh.setVisibility(8);
        this.recyclerView = (RecyclerView)view.findViewById(R.id.meipai_pk_invate_oriented_recyclerView);
        this.loadingTextView = (TextView)view.findViewById(R.id.meipai_pk_invate_recommend_loading_textView);
        ViewUtils.clicks((View)this.loadingTextView, (long)300L).subscribe((Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                MeiPaiPKInviteRecommendFragment.this.initData();
            }
        });
        this.layoutManager = new LinearLayoutManager(this.getContext());
        this.recyclerView.setLayoutManager(this.layoutManager);
        this.recyclerAdapter = adapter = new MeiPaiPKInviteOrientRecyclerAdapter(this.recyclerView, this.getActivity());
        this.initData();
        this.recyclerView.setAdapter((RecyclerView.Adapter)adapter);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.compositeDisposable.dispose();
    }

    private void initData() {
        if (this.isLoading) {
            Toast.makeText((Context)this.getContext(), (CharSequence)"\u6b63\u5728\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e", (int)0).show();
            return;
        }
        this.isLoading = true;
        this.loadingTextView.setText((CharSequence)"\u52a0\u8f7d\u4e2d...");
        this.loadingTextView.setVisibility(0);
        final ArrayList arrayList = new ArrayList();
        Disposable disposable = ((IMeiPaiPkCore)CoreFactory.getCore(IMeiPaiPkCore.class)).reqPkFriendReq(2, 1, 50).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<MeiPaiPkProtocols.PMeipaiPKFriendRsp>(){

            public void accept(MeiPaiPkProtocols.PMeipaiPKFriendRsp rsp) throws Exception {
                MLog.info((Object)MeiPaiPKInviteRecommendFragment.TAG, (String)("[PK] PMeipaiPKFriendRsp accept" + rsp), (Object[])new Object[0]);
                MeiPaiPKInviteRecommendFragment.this.searchRefresh.finishRefresh();
                MeiPaiPKInviteRecommendFragment.this.isLoading = false;
                if (rsp.result.intValue() == 0) {
                    if (rsp.dataset.size() == 0) {
                        MeiPaiPKInviteRecommendFragment.this.loadingTextView.setText((CharSequence)"\u5f53\u524d\u6682\u65e0\u53efPK\u4e3b\u64ad");
                    } else {
                        MeiPaiPKInviteRecommendFragment.this.searchRefresh.setVisibility(0);
                        MeiPaiPKInviteRecommendFragment.this.loadingTextView.setVisibility(8);
                        for (Map<String, String> tmp : rsp.dataset) {
                            MeiPaiPKInviteOrientRecyclerAdapterInfo info = new MeiPaiPKInviteOrientRecyclerAdapterInfo();
                            info.uid = StringUtils.safeParseLong((String)tmp.get("uid"));
                            info.imageURL = tmp.get("head_url");
                            info.name = tmp.get("name");
                            info.sex = StringUtils.safeParseInt((String)tmp.get("gender"));
                            info.userState = MeiPaiPKInviteOrientRecyclerAdapter.UserState.init(StringUtils.safeParseInt((String)tmp.get("status")));
                            arrayList.add(info);
                        }
                        MeiPaiPKInviteRecommendFragment.this.recyclerAdapter.setData(arrayList);
                        MeiPaiPKInviteRecommendFragment.this.recyclerAdapter.notifyDataSetChanged();
                    }
                } else {
                    MeiPaiPKInviteRecommendFragment.this.loadingTextView.setText((CharSequence)"\u52a0\u8f7d\u5931\u8d25");
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)MeiPaiPKInviteRecommendFragment.TAG, (String)("[PK] PMeipaiPKFriendRsp throwable = " + throwable), (Object[])new Object[0]);
                MeiPaiPKInviteRecommendFragment.this.searchRefresh.finishRefresh();
                MeiPaiPKInviteRecommendFragment.this.isLoading = false;
                MeiPaiPKInviteRecommendFragment.this.loadingTextView.setText((CharSequence)"\u7f51\u7edc\u5f02\u5e38,\u8bf7\u91cd\u8bd5");
            }
        });
        this.compositeDisposable.add(disposable);
    }
}

