/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.ui;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.DrawableRes;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import com.unionyy.mobile.meipai.R;

public class CircleIndicator
extends LinearLayout {
    private static final int DEFAULT_INDICATOR_WIDTH = 5;
    private ViewPager mViewpager;
    private int mIndicatorMargin = -1;
    private int mIndicatorWidth = -1;
    private int mIndicatorHeight = -1;
    private int mAnimatorResId = 0;
    private int mAnimatorReverseResId = 0;
    private int mIndicatorBackgroundResId = R.drawable.meipai_live_white_radius;
    private int mIndicatorUnselectedBackgroundResId = R.drawable.meipai_live_white_radius;
    private Animator mAnimatorOut;
    private Animator mAnimatorIn;
    private Animator mImmediateAnimatorOut;
    private Animator mImmediateAnimatorIn;
    private int mLastPosition = -1;
    private final ViewPager.OnPageChangeListener mInternalPageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
            View selectedIndicator;
            View currentIndicator;
            if (CircleIndicator.this.mViewpager.getAdapter() == null || CircleIndicator.this.mViewpager.getAdapter().getCount() <= 0) {
                return;
            }
            if (CircleIndicator.this.mAnimatorIn.isRunning()) {
                CircleIndicator.this.mAnimatorIn.end();
                CircleIndicator.this.mAnimatorIn.cancel();
            }
            if (CircleIndicator.this.mAnimatorOut.isRunning()) {
                CircleIndicator.this.mAnimatorOut.end();
                CircleIndicator.this.mAnimatorOut.cancel();
            }
            if (CircleIndicator.this.mLastPosition >= 0 && (currentIndicator = CircleIndicator.this.getChildAt(CircleIndicator.this.mLastPosition)) != null) {
                currentIndicator.setBackgroundResource(CircleIndicator.this.mIndicatorUnselectedBackgroundResId);
                CircleIndicator.this.mAnimatorIn.setTarget((Object)currentIndicator);
                CircleIndicator.this.mAnimatorIn.start();
            }
            if ((selectedIndicator = CircleIndicator.this.getChildAt(position)) != null) {
                selectedIndicator.setBackgroundResource(CircleIndicator.this.mIndicatorBackgroundResId);
                CircleIndicator.this.mAnimatorOut.setTarget((Object)selectedIndicator);
                CircleIndicator.this.mAnimatorOut.start();
            }
            CircleIndicator.this.mLastPosition = position;
        }

        public void onPageScrollStateChanged(int state) {
        }
    };

    public CircleIndicator(Context context) {
        super(context);
        this.init(context, null);
    }

    public CircleIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CircleIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public CircleIndicator(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.handleTypedArray(context, attrs);
        this.checkIndicatorConfig(context);
    }

    private void handleTypedArray(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.meipai_live_CircleIndicator);
        this.mIndicatorWidth = typedArray.getDimensionPixelSize(R.styleable.meipai_live_CircleIndicator_live_ci_width, -1);
        this.mIndicatorHeight = typedArray.getDimensionPixelSize(R.styleable.meipai_live_CircleIndicator_live_ci_height, -1);
        this.mIndicatorMargin = typedArray.getDimensionPixelSize(R.styleable.meipai_live_CircleIndicator_live_ci_margin, -1);
        this.mAnimatorResId = typedArray.getResourceId(R.styleable.meipai_live_CircleIndicator_live_ci_animator, R.anim.meipai_live_scale_with_alpha);
        this.mAnimatorReverseResId = typedArray.getResourceId(R.styleable.meipai_live_CircleIndicator_live_ci_animator_reverse, 0);
        this.mIndicatorBackgroundResId = typedArray.getResourceId(R.styleable.meipai_live_CircleIndicator_live_ci_drawable, R.drawable.meipai_live_white_radius);
        this.mIndicatorUnselectedBackgroundResId = typedArray.getResourceId(R.styleable.meipai_live_CircleIndicator_live_ci_drawable_unselected, this.mIndicatorBackgroundResId);
        int orientation = typedArray.getInt(R.styleable.meipai_live_CircleIndicator_live_ci_orientation, -1);
        this.setOrientation(orientation == 1 ? 1 : 0);
        int gravity = typedArray.getInt(R.styleable.meipai_live_CircleIndicator_live_ci_gravity, -1);
        this.setGravity(gravity >= 0 ? gravity : 17);
        typedArray.recycle();
    }

    private void checkIndicatorConfig(Context context) {
        this.mIndicatorWidth = this.mIndicatorWidth < 0 ? this.dip2px(5.0f) : this.mIndicatorWidth;
        this.mIndicatorHeight = this.mIndicatorHeight < 0 ? this.dip2px(5.0f) : this.mIndicatorHeight;
        this.mIndicatorMargin = this.mIndicatorMargin < 0 ? this.dip2px(5.0f) : this.mIndicatorMargin;
        this.mAnimatorResId = this.mAnimatorResId == 0 ? R.anim.meipai_live_scale_with_alpha : this.mAnimatorResId;
        this.mAnimatorOut = this.createAnimatorOut(context);
        this.mImmediateAnimatorOut = this.createAnimatorOut(context);
        this.mImmediateAnimatorOut.setDuration(0L);
        this.mAnimatorIn = this.createAnimatorIn(context);
        this.mImmediateAnimatorIn = this.createAnimatorIn(context);
        this.mImmediateAnimatorIn.setDuration(0L);
        this.mIndicatorBackgroundResId = this.mIndicatorBackgroundResId == 0 ? R.drawable.meipai_live_white_radius : this.mIndicatorBackgroundResId;
        this.mIndicatorUnselectedBackgroundResId = this.mIndicatorUnselectedBackgroundResId == 0 ? this.mIndicatorBackgroundResId : this.mIndicatorUnselectedBackgroundResId;
    }

    private Animator createAnimatorOut(Context context) {
        return AnimatorInflater.loadAnimator((Context)context, (int)this.mAnimatorResId);
    }

    private Animator createAnimatorIn(Context context) {
        Animator animatorIn;
        if (this.mAnimatorReverseResId == 0) {
            animatorIn = AnimatorInflater.loadAnimator((Context)context, (int)this.mAnimatorResId);
            animatorIn.setInterpolator((TimeInterpolator)new ReverseInterpolator());
        } else {
            animatorIn = AnimatorInflater.loadAnimator((Context)context, (int)this.mAnimatorReverseResId);
        }
        return animatorIn;
    }

    public void setViewPager(ViewPager viewPager) {
        this.mViewpager = viewPager;
        if (this.mViewpager != null && this.mViewpager.getAdapter() != null) {
            this.mLastPosition = -1;
            this.createIndicators();
            this.mViewpager.removeOnPageChangeListener(this.mInternalPageChangeListener);
            this.mViewpager.addOnPageChangeListener(this.mInternalPageChangeListener);
            this.mInternalPageChangeListener.onPageSelected(this.mViewpager.getCurrentItem());
        }
    }

    @Deprecated
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener onPageChangeListener) {
        if (this.mViewpager == null) {
            throw new NullPointerException("can not find Viewpager , setViewPager first");
        }
        this.mViewpager.removeOnPageChangeListener(onPageChangeListener);
        this.mViewpager.addOnPageChangeListener(onPageChangeListener);
    }

    private void createIndicators() {
        this.removeAllViews();
        int count = this.mViewpager.getAdapter().getCount();
        if (count <= 0) {
            return;
        }
        int currentItem = this.mViewpager.getCurrentItem();
        for (int i = 0; i < count; ++i) {
            if (currentItem == i) {
                this.addIndicator(this.mIndicatorBackgroundResId, this.mImmediateAnimatorOut);
                continue;
            }
            this.addIndicator(this.mIndicatorUnselectedBackgroundResId, this.mImmediateAnimatorIn);
        }
    }

    private void addIndicator(@DrawableRes int backgroundDrawableId, Animator animator) {
        if (animator.isRunning()) {
            animator.end();
            animator.cancel();
        }
        View Indicator = new View(this.getContext());
        Indicator.setBackgroundResource(backgroundDrawableId);
        this.addView(Indicator, this.mIndicatorWidth, this.mIndicatorHeight);
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)Indicator.getLayoutParams();
        lp.leftMargin = this.mIndicatorMargin;
        lp.rightMargin = this.mIndicatorMargin;
        Indicator.setLayoutParams((ViewGroup.LayoutParams)lp);
        animator.setTarget((Object)Indicator);
        animator.start();
    }

    public int dip2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public void setIndicatorMargin(int indicatorMargin) {
        this.mIndicatorMargin = indicatorMargin;
    }

    public void setIndicatorWidth(int indicatorWidth) {
        this.mIndicatorWidth = indicatorWidth;
    }

    private static class ReverseInterpolator
    implements Interpolator {
        private ReverseInterpolator() {
        }

        public float getInterpolation(float value) {
            return Math.abs(1.0f - value);
        }
    }
}

