/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.gift.animation.utils.GlideUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.imageloader.ImageLoader;
import java.util.HashMap;

public class AnimateResourceLoader {
    private static final int[] NUMBER_RESOURCES = new int[]{R.drawable.meipai_live_combo_num_0, R.drawable.meipai_live_combo_num_1, R.drawable.meipai_live_combo_num_2, R.drawable.meipai_live_combo_num_3, R.drawable.meipai_live_combo_num_4, R.drawable.meipai_live_combo_num_5, R.drawable.meipai_live_combo_num_6, R.drawable.meipai_live_combo_num_7, R.drawable.meipai_live_combo_num_8, R.drawable.meipai_live_combo_num_9, R.drawable.meipai_live_combo_num_x};
    private static AnimateResourceLoader mAnimateResourceLoader;
    private HashMap<String, int[]> mBitmapSizeMap = new HashMap();
    private int[] mNumberBitmapSize = new int[22];

    public static AnimateResourceLoader getInstance() {
        if (mAnimateResourceLoader == null) {
            mAnimateResourceLoader = new AnimateResourceLoader();
        }
        return mAnimateResourceLoader;
    }

    public void loadBitmap(String path, ImageLoader.BitmapLoadListener simpleTarget) {
        ImageLoader.loadBitmap((Context)BasicConfig.getInstance().getAppContext(), (String)path, (ImageLoader.BitmapLoadListener)simpleTarget);
    }

    public Bitmap synLoadSdCardImage(String path) {
        Drawable drawable2 = GlideUtil.synLoadSdCardImage(BasicConfig.getInstance().getAppContext(), path);
        if (drawable2 == null) {
            return null;
        }
        return ((BitmapDrawable)drawable2).getBitmap();
    }

    public Bitmap loadBitmap(int resourceId) {
        Drawable drawable2 = BasicConfig.getInstance().getAppContext().getResources().getDrawable(resourceId);
        if (drawable2 == null) {
            return null;
        }
        return ((BitmapDrawable)drawable2).getBitmap();
    }

    public int[] decodeBitmapSize(Integer resourceId) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)BasicConfig.getInstance().getAppContext().getResources(), (int)resourceId, (BitmapFactory.Options)options);
        int[] size = new int[]{this.scaleFromDensity(options.outWidth, options.inDensity, options.inTargetDensity), this.scaleFromDensity(options.outHeight, options.inDensity, options.inTargetDensity)};
        return size;
    }

    public int[] decodeBitmapSize(String path) {
        int[] size = this.mBitmapSizeMap.get(path);
        if (size != null) {
            return size;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        size = new int[]{options.outWidth, options.outHeight};
        this.mBitmapSizeMap.put(path, size);
        return size;
    }

    public Bitmap loadNumberBitmap(int number) {
        int index = number;
        if (index < 0) {
            index = NUMBER_RESOURCES.length - 1;
        }
        int resourceId = NUMBER_RESOURCES[index];
        Bitmap bitmap = this.loadBitmap(resourceId);
        return bitmap;
    }

    public int[] getNumberBitmapSize(int number) {
        if (number < 0) {
            number = NUMBER_RESOURCES.length - 1;
        }
        int[] size = new int[2];
        if (this.mNumberBitmapSize[number * 2] <= 0 || this.mNumberBitmapSize[number * 2 + 1] <= 0) {
            int resourceId = NUMBER_RESOURCES[number];
            size = this.decodeBitmapSize(resourceId);
            this.mNumberBitmapSize[number * 2] = size[0];
            this.mNumberBitmapSize[number * 2 + 1] = size[1];
        }
        size[0] = this.mNumberBitmapSize[number * 2];
        size[1] = this.mNumberBitmapSize[number * 2 + 1];
        return size;
    }

    public int scaleFromDensity(int size, int sdensity, int tdensity) {
        if (sdensity == 0 || tdensity == 0 || sdensity == tdensity) {
            return size;
        }
        return (size * tdensity + (sdensity >> 1)) / sdensity;
    }

    public int getNumberResourceId(int number) {
        int index = number;
        if (index < 0) {
            index = NUMBER_RESOURCES.length - 1;
        }
        return NUMBER_RESOURCES[index];
    }

    public static void clearCache() {
        if (mAnimateResourceLoader != null) {
            mAnimateResourceLoader.clearMemoryCache();
        }
        mAnimateResourceLoader = null;
    }

    private void clearMemoryCache() {
        this.mBitmapSizeMap.clear();
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                GlideUtil.clearMemoryCache(BasicConfig.getInstance().getAppContext());
            }
        });
    }
}

