/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.viewdelegate;

import android.app.Activity;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.pk.ui.model.PkStatusInfo;
import com.unionyy.mobile.meipai.pk.ui.view.LivePKSeekBar;
import com.unionyy.mobile.meipai.pk.ui.viewdelegate.BaseViewUpdateDelegate;
import com.yy.mobile.util.ScreenUtil;

public class PKBarViewUpdateDelegate
extends BaseViewUpdateDelegate {
    private static final String TAG = "PKBarViewUpdateDelegate";
    private LivePKSeekBar mPkSeekBar;
    private boolean isShowPkBar;

    public PKBarViewUpdateDelegate(View rootView, FragmentActivity activity, int videoMarginTop) {
        super(rootView, activity, videoMarginTop);
        this.mPkSeekBar = (LivePKSeekBar)rootView.findViewById(R.id.live_pk_seek_bar_layout);
    }

    @Override
    public void onInit() {
        super.onInit();
        int seekbarHigth = 76;
        this.setPKTitleTopMargin(this.videoMarginTop - ScreenUtil.getInstance().dip2px(seekbarHigth) + 4);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        PkStatusInfo info = this.core.getPkStatusInfo();
        if (info.result != 0) {
            return;
        }
        if (info.type == 5 || info.type == 6) {
            if (!this.isShowPkBar) {
                this.isShowPkBar = true;
                this.showPKSeekbar(info.leftNum, info.rightnum, info.needChangeColor);
            } else {
                this.updatePKProgess(info.leftNum, info.rightnum);
            }
            this.mPkSeekBar.startVsTitleCountDown(info.leftTime, (Activity)this.mActivity, info.type == 5);
        } else {
            this.mPkSeekBar.release();
            this.mPkSeekBar.setVisibility(8);
            this.isShowPkBar = false;
        }
    }

    @Override
    public void onStateChanged(int lastState, int curState) {
        super.onStateChanged(lastState, curState);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.onClosePk();
    }

    @Override
    public void onClosePk() {
        super.onClosePk();
        this.mPkSeekBar.release();
        this.mPkSeekBar.setVisibility(8);
        this.isShowPkBar = false;
    }

    private void setPKTitleTopMargin(int topMargin) {
        FrameLayout.LayoutParams seekbarLayoutParams;
        if (topMargin > 0 && null != (seekbarLayoutParams = (FrameLayout.LayoutParams)this.mPkSeekBar.getLayoutParams())) {
            seekbarLayoutParams.topMargin = topMargin;
            this.mPkSeekBar.setLayoutParams((ViewGroup.LayoutParams)seekbarLayoutParams);
        }
    }

    private void showPKSeekbar(long leftCounts, long rightCounts, boolean needChangeRedBlue) {
        this.needChangeRedBlueBg(needChangeRedBlue);
        if (this.mPkSeekBar != null) {
            this.mPkSeekBar.resetPosition();
            this.mPkSeekBar.setVisibility(0);
            this.mPkSeekBar.updatePrograss(leftCounts, rightCounts);
        }
    }

    private void needChangeRedBlueBg(boolean needChangeRedBlueBg) {
        this.mPkSeekBar.setSeekbarRedBlueProgressDrawable(needChangeRedBlueBg);
    }

    private void updatePKProgess(long leftCounts, long rightCounts) {
        if (this.mPkSeekBar != null) {
            this.mPkSeekBar.updatePrograss(leftCounts, rightCounts);
        }
    }
}

