/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view.guard;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.transition.Transition;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;
import com.unionyy.mobile.meipai.gift.animation.utils.GlideUtil;
import com.unionyy.mobile.meipai.gift.animation.view.guard.GuardLightView;
import com.unionyy.mobile.meipai.gift.animation.view.guard.GuardLoveHeartView;
import com.unionyy.mobile.meipai.gift.animation.view.guard.GuardStarView;
import com.unionyy.mobile.meipai.gift.animation.view.guard.GuardUserInfo;
import com.unionyy.mobile.meipai.gift.animation.view.percent.PercentFrameLayout;

public class GuardLoveAnimationLayout
extends RelativeLayout {
    private final float VALUE_ANIMATOR_END_VALUE = 0.533f;
    private final int VALUE_ANIMATOR_DURATION = 2000;
    private final int TOTAL_DURATION = 6000;
    private View viewBackground;
    private View viewArrow;
    private View viewColorBar;
    private GuardLightView viewLight;
    private GuardStarView viewStar;
    private GuardLoveHeartView viewBubble;
    private PercentFrameLayout layoutLovingHeartMale;
    private PercentFrameLayout layoutLovingHeartFeMale;
    private TextView textViewMaleName;
    private TextView textViewFemaleName;
    private ImageView imageMaleAvatar;
    private ImageView imageFemaleAvatar;
    private Point malePosition;
    private Point femalePosition;
    private Path malePath = new Path();
    private Path femalePath = new Path();
    private ValueAnimator enterAnimator;
    private ValueAnimator endAnimator;
    private ValueAnimator colorBarAnimator;
    private AnimatorSet arrowAnimatorSet;

    public GuardLoveAnimationLayout(Context context) {
        super(context);
        this.init();
    }

    public GuardLoveAnimationLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GuardLoveAnimationLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        GuardLoveAnimationLayout.inflate((Context)this.getContext(), (int)R.layout.meipai_live_layout_animation_guard_love, (ViewGroup)this);
        this.viewBackground = this.findViewById(R.id.view_background);
        this.viewArrow = this.findViewById(R.id.view_arrow);
        this.viewColorBar = this.findViewById(R.id.view_color_bar);
        this.viewLight = (GuardLightView)this.findViewById(R.id.view_light);
        this.layoutLovingHeartMale = (PercentFrameLayout)this.findViewById(R.id.layout_loving_heart_male);
        this.layoutLovingHeartFeMale = (PercentFrameLayout)this.findViewById(R.id.layout_loving_heart_female);
        this.viewStar = (GuardStarView)this.findViewById(R.id.view_star);
        this.viewBubble = (GuardLoveHeartView)this.findViewById(R.id.view_bubble);
        this.textViewMaleName = (TextView)this.findViewById(R.id.text_male_name);
        this.textViewFemaleName = (TextView)this.findViewById(R.id.text_female_name);
        this.imageMaleAvatar = (ImageView)this.findViewById(R.id.image_male_avatar);
        this.imageFemaleAvatar = (ImageView)this.findViewById(R.id.image_female_avatar);
        int width = Math.min(DeviceUtils.getScreenWidth(), DeviceUtils.getScreenHeight());
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(width, -2);
        this.setLayoutParams(layoutParams);
        this.setAlpha(0.0f);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setBackgroundByUrl(this.viewBackground, "http://mpstatic.bs2cdn.yy.com/live_guard_love_animation_bg.png?id=4615");
        this.setBackgroundByUrl(this.viewArrow, "http://mpstatic.bs2cdn.yy.com/live_guard_love_arrow.png?id=4616");
        this.setBackgroundByUrl(this.viewColorBar, "http://mpstatic.bs2cdn.yy.com/live_guard_love_color_bar.png?id=4618");
        this.setBackgroundByUrl((View)this.layoutLovingHeartFeMale, "http://mpstatic.bs2cdn.yy.com/live_guard_love_female_bg.png?id=4619");
        this.setBackgroundByUrl((View)this.layoutLovingHeartMale, "http://mpstatic.bs2cdn.yy.com/live_guard_love_male_bg.png?id=4621");
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.setBackgroundVisible(newConfig);
    }

    private void setBackgroundVisible(Configuration newConfig) {
        if (newConfig.orientation == 2) {
            this.viewBackground.setVisibility(8);
        } else {
            this.viewBackground.setVisibility(0);
        }
    }

    private void setBackgroundByUrl(final View view, String url) {
        GlideUtil.loadImage(this, url, new SimpleTarget<Drawable>(){

            public void onResourceReady(@NonNull Drawable drawable2, @Nullable Transition<? super Drawable> transition) {
                view.setBackground(drawable2);
            }
        });
    }

    public void setGuardUserInfo(GuardUserInfo guardUserInfo) {
        if (this.getContext() == null || Build.VERSION.SDK_INT >= 17 && ((Activity)this.getContext()).isDestroyed()) {
            return;
        }
        this.textViewMaleName.setText((CharSequence)guardUserInfo.getMaleName());
        this.textViewFemaleName.setText((CharSequence)guardUserInfo.getFemaleName());
        if (TextUtils.isEmpty((CharSequence)guardUserInfo.getMaleAvatar())) {
            GlideUtil.loadCircleImage(this.getContext(), this.imageMaleAvatar, R.drawable.live_icon_avatar_large);
        } else {
            GlideUtil.loadCircleImage(this.getContext(), this.imageMaleAvatar, guardUserInfo.getMaleAvatar());
        }
        if (TextUtils.isEmpty((CharSequence)guardUserInfo.getFemaleAvatar())) {
            GlideUtil.loadCircleImage(this.getContext(), this.imageFemaleAvatar, R.drawable.live_icon_avatar_large);
        } else {
            GlideUtil.loadCircleImage(this.getContext(), this.imageFemaleAvatar, guardUserInfo.getFemaleAvatar());
        }
    }

    public void startLovingAnimation(final AnimatorListenerAdapter listener2) {
        if (this.enterAnimator != null && this.enterAnimator.isRunning()) {
            return;
        }
        if (this.malePosition == null || this.femalePosition == null) {
            this.malePosition = new Point((int)this.layoutLovingHeartMale.getX(), (int)this.layoutLovingHeartMale.getY());
            this.femalePosition = new Point((int)this.layoutLovingHeartFeMale.getX(), (int)this.layoutLovingHeartFeMale.getY());
        }
        this.resetView();
        this.enterAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.533f});
        this.enterAnimator.setDuration(2000L);
        this.enterAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.malePath.reset();
        this.malePath.moveTo((float)(-this.layoutLovingHeartMale.getWidth()), (float)this.malePosition.y);
        this.malePath.cubicTo((float)this.malePosition.x / 5.0f, (float)(this.malePosition.y * 2), (float)this.malePosition.x / 5.0f * 3.0f, 0.0f, (float)this.malePosition.x, (float)this.malePosition.y);
        this.femalePath.reset();
        this.femalePath.moveTo((float)this.getWidth(), (float)this.femalePosition.y);
        this.femalePath.cubicTo((float)this.getWidth() - (float)this.femalePosition.x / 5.0f, (float)(this.femalePosition.y * 2), (float)this.getWidth() - (float)this.femalePosition.x / 5.0f * 3.0f, 0.0f, (float)this.femalePosition.x, (float)this.femalePosition.y);
        final PathMeasure malePathMeasure = new PathMeasure(this.malePath, true);
        final PathMeasure femalePathMeasure = new PathMeasure(this.femalePath, true);
        this.enterAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            float[] malePoint = new float[2];
            float[] femalePoint = new float[2];

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                if (value == 0.533f) {
                    this.malePoint[0] = ((GuardLoveAnimationLayout)GuardLoveAnimationLayout.this).malePosition.x;
                    this.malePoint[1] = ((GuardLoveAnimationLayout)GuardLoveAnimationLayout.this).malePosition.y;
                    this.femalePoint[0] = ((GuardLoveAnimationLayout)GuardLoveAnimationLayout.this).femalePosition.x;
                    this.femalePoint[1] = ((GuardLoveAnimationLayout)GuardLoveAnimationLayout.this).femalePosition.y;
                } else {
                    float[] point = new float[2];
                    malePathMeasure.getPosTan(malePathMeasure.getLength() * value, point, null);
                    if (this.malePoint[0] == 0.0f || point[0] > this.malePoint[0]) {
                        this.malePoint[0] = point[0];
                        this.malePoint[1] = point[1];
                    }
                    femalePathMeasure.getPosTan(femalePathMeasure.getLength() * value, point, null);
                    if (this.femalePoint[0] == 0.0f || point[0] < this.femalePoint[0]) {
                        this.femalePoint[0] = point[0];
                        this.femalePoint[1] = point[1];
                    }
                }
                GuardLoveAnimationLayout.this.layoutLovingHeartMale.setX(this.malePoint[0]);
                GuardLoveAnimationLayout.this.layoutLovingHeartMale.setY(this.malePoint[1]);
                GuardLoveAnimationLayout.this.layoutLovingHeartFeMale.setX(this.femalePoint[0]);
                GuardLoveAnimationLayout.this.layoutLovingHeartFeMale.setY(this.femalePoint[1]);
            }
        });
        this.enterAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (GuardLoveAnimationLayout.this.getHandler() == null) {
                    return;
                }
                GuardLoveAnimationLayout.this.viewLight.setVisibility(0);
                GuardLoveAnimationLayout.this.viewArrow.setVisibility(0);
                GuardLoveAnimationLayout.this.startArrowAnimation();
                GuardLoveAnimationLayout.this.viewBubble.setVisibility(0);
                GuardLoveAnimationLayout.this.getHandler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        GuardLoveAnimationLayout.this.viewStar.setVisibility(0);
                        GuardLoveAnimationLayout.this.viewStar.startAnimation();
                        GuardLoveAnimationLayout.this.startColorBarAnimation();
                        GuardLoveAnimationLayout.this.viewBubble.startHeartAnimation();
                    }
                }, 400L);
            }
        });
        this.enterAnimator.start();
        if (this.getHandler() != null) {
            this.getHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    GuardLoveAnimationLayout.this.startEndAnimation(listener2);
                }
            }, 6000L);
        }
    }

    private void startEndAnimation(AnimatorListenerAdapter listener2) {
        this.endAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        this.endAnimator.setDuration(200L);
        this.endAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float animatedValue = ((Float)animation.getAnimatedValue()).floatValue();
                GuardLoveAnimationLayout.this.setAlpha(animatedValue);
            }
        });
        this.endAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                GuardLoveAnimationLayout.this.setVisibility(8);
            }
        });
        this.endAnimator.addListener((Animator.AnimatorListener)listener2);
        this.endAnimator.start();
    }

    private void startColorBarAnimation() {
        this.colorBarAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.1f, 0.95f, 1.05f, 1.0f});
        this.colorBarAnimator.setDuration(800L);
        this.colorBarAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.colorBarAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float currentValue = ((Float)animation.getAnimatedValue()).floatValue();
                GuardLoveAnimationLayout.this.viewColorBar.setScaleX(currentValue);
                GuardLoveAnimationLayout.this.viewColorBar.setScaleY(currentValue);
            }
        });
        this.colorBarAnimator.start();
    }

    private void startArrowAnimation() {
        ObjectAnimator xAnimator = ObjectAnimator.ofFloat((Object)this.viewArrow, (String)"x", (float[])new float[]{-this.viewArrow.getWidth(), this.viewArrow.getX()});
        ObjectAnimator yAnimator = ObjectAnimator.ofFloat((Object)this.viewArrow, (String)"y", (float[])new float[]{this.viewArrow.getY() + (float)this.viewArrow.getHeight(), this.viewArrow.getY()});
        this.arrowAnimatorSet = new AnimatorSet();
        this.arrowAnimatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.arrowAnimatorSet.setDuration(500L);
        this.arrowAnimatorSet.playTogether(new Animator[]{xAnimator, yAnimator});
        this.arrowAnimatorSet.start();
    }

    private void resetView() {
        this.setVisibility(0);
        this.viewLight.setVisibility(8);
        this.viewArrow.setVisibility(8);
        this.viewStar.setVisibility(8);
        this.viewColorBar.setScaleX(0.0f);
        this.viewColorBar.setScaleY(0.0f);
        this.setAlpha(1.0f);
        this.setBackgroundVisible(this.getContext().getResources().getConfiguration());
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.enterAnimator != null && this.enterAnimator.isRunning()) {
            this.enterAnimator.cancel();
        }
        if (this.endAnimator != null && this.endAnimator.isRunning()) {
            this.endAnimator.cancel();
        }
        if (this.colorBarAnimator != null && this.colorBarAnimator.isRunning()) {
            this.colorBarAnimator.cancel();
        }
        if (this.arrowAnimatorSet != null && this.arrowAnimatorSet.isRunning()) {
            this.arrowAnimatorSet.cancel();
        }
    }
}

