/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatTextView;
import android.text.TextPaint;
import android.util.AttributeSet;
import com.unionyy.mobile.meipai.R;

public class StrokeTextView
extends AppCompatTextView {
    private int mStokeColor;
    private int mStokeSize;
    private TextPaint mStokePaint;

    public StrokeTextView(Context context) {
        this(context, null);
    }

    public StrokeTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public StrokeTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attributeSet) {
        TypedArray ta = context.obtainStyledAttributes(attributeSet, R.styleable.meipai_live_StrokeTextView);
        this.mStokeSize = ta.getDimensionPixelSize(R.styleable.meipai_live_StrokeTextView_live_stoke_size, 0);
        this.mStokeColor = ta.getColor(R.styleable.meipai_live_StrokeTextView_live_stoke_color, -1);
        ta.recycle();
    }

    protected void onDraw(Canvas canvas) {
        if (this.mStokePaint == null) {
            this.mStokePaint = new TextPaint();
        }
        TextPaint paint = this.getPaint();
        this.mStokePaint.setTextSize(paint.getTextSize());
        this.mStokePaint.setTypeface(paint.getTypeface());
        this.mStokePaint.setFlags(paint.getFlags());
        this.mStokePaint.setAlpha(paint.getAlpha());
        this.mStokePaint.setStyle(Paint.Style.STROKE);
        this.mStokePaint.setColor(this.mStokeColor);
        this.mStokePaint.setStrokeWidth((float)this.mStokeSize);
        String text = this.getText().toString();
        canvas.drawText(text, ((float)this.getWidth() - this.mStokePaint.measureText(text)) / 2.0f, (float)this.getBaseline(), (Paint)this.mStokePaint);
        super.onDraw(canvas);
    }
}

