/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.controller;

import com.unionyy.mobile.meipai.gift.animation.decoder.INGiftAnimateDecoder;
import com.unionyy.mobile.meipai.gift.animation.model.GiftMessage;
import com.unionyy.mobile.meipai.gift.animation.utils.GiftTargetRecyclePool;
import com.unionyy.mobile.meipai.gift.dispatcher.GiftMessageDispatcher;
import java.util.ArrayList;

public class GiftAnimateController
implements GiftMessageDispatcher.IGiftDispatcherListener {
    private ArrayList<INGiftAnimateDecoder> mDecoderList = new ArrayList();
    private GiftMessageDispatcher mMessageDispatcher;
    private int mOrientation = 1;

    public GiftAnimateController() {
    }

    public GiftAnimateController(boolean isLiveController) {
        if (isLiveController) {
            this.mMessageDispatcher = new GiftMessageDispatcher(this);
        }
    }

    public void registerDecoder(INGiftAnimateDecoder decoder) {
        if (decoder != null) {
            this.mDecoderList.add(decoder);
        }
    }

    public boolean sendGift(ArrayList<GiftMessage> messages) {
        boolean result = false;
        for (int i = 0; i < this.mDecoderList.size(); ++i) {
            INGiftAnimateDecoder decoder = this.mDecoderList.get(i);
            if (!decoder.dispatchGiftMessage(messages)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean sendGift(GiftMessage message) {
        boolean result = false;
        for (int i = 0; i < this.mDecoderList.size(); ++i) {
            INGiftAnimateDecoder decoder = this.mDecoderList.get(i);
            if (!decoder.dispatchGiftMessage(message)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void clear() {
        for (int i = 0; i < this.mDecoderList.size(); ++i) {
            INGiftAnimateDecoder decoder = this.mDecoderList.get(i);
            decoder.clear();
        }
        if (this.mMessageDispatcher != null) {
            this.mMessageDispatcher.clear();
        }
    }

    public void release() {
        for (int i = 0; i < this.mDecoderList.size(); ++i) {
            INGiftAnimateDecoder decoder = this.mDecoderList.get(i);
            decoder.release();
        }
        this.mDecoderList.clear();
        if (this.mMessageDispatcher != null) {
            this.mMessageDispatcher.release();
        }
        GiftTargetRecyclePool.getInstance().clear();
    }

    public void setPause(boolean isPause) {
        for (int i = 0; i < this.mDecoderList.size(); ++i) {
            INGiftAnimateDecoder decoder = this.mDecoderList.get(i);
            decoder.setPause(isPause);
        }
    }

    public void setBottomMargin(int marginBottom) {
        for (int i = 0; i < this.mDecoderList.size(); ++i) {
            INGiftAnimateDecoder decoder = this.mDecoderList.get(i);
            decoder.setBottomMargin(marginBottom);
        }
    }

    public void onDisplaySizeChanged(int w, int h) {
        for (int i = 0; i < this.mDecoderList.size(); ++i) {
            INGiftAnimateDecoder decoder = this.mDecoderList.get(i);
            decoder.onDisplaySizeChanged(w, h);
        }
    }

    public void onConfigurationChanged(int orientation) {
        if (this.mOrientation != orientation) {
            this.mOrientation = orientation;
            this.clearScreen();
            for (int i = 0; i < this.mDecoderList.size(); ++i) {
                INGiftAnimateDecoder decoder = this.mDecoderList.get(i);
                decoder.onConfigurationChanged(orientation);
            }
        }
    }

    @Override
    public INGiftAnimateDecoder findDecoderDealGiftMessage(GiftMessage message) {
        for (int i = 0; i < this.mDecoderList.size(); ++i) {
            INGiftAnimateDecoder decoder = this.mDecoderList.get(i);
            if (null == decoder || !decoder.checkGiftMessageFitDecoder(message)) continue;
            return decoder;
        }
        return null;
    }

    public void clearScreen() {
        for (int i = 0; i < this.mDecoderList.size(); ++i) {
            INGiftAnimateDecoder decoder = this.mDecoderList.get(i);
            decoder.clear();
        }
        if (this.mMessageDispatcher != null) {
            this.mMessageDispatcher.clear();
        }
    }

    public static int getGiftValue(GiftMessage message) {
        if (message != null) {
            int comboTo = message.getComboTo();
            int weight = message.getWeight();
            return GiftAnimateController.computeGiftValue(comboTo, weight);
        }
        return -1;
    }

    public static int computeGiftValue(int combo, int weight) {
        if (combo > 0) {
            return combo * weight;
        }
        return weight;
    }

    public GiftMessageDispatcher getGiftMessageDispatcher() {
        return this.mMessageDispatcher;
    }
}

