/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation;

import android.animation.Animator;
import android.animation.PropertyValuesHolder;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.view.animation.AnimationUtils;
import java.util.ArrayList;

public class FrameAnimator
extends ValueAnimator {
    private long mStartTime = -1L;
    private long mCurrentPlayTime;
    private boolean isAnimationEnd = false;
    private int mCurrentIteration;

    public static FrameAnimator ofInt(int ... values) {
        FrameAnimator anim2 = new FrameAnimator();
        anim2.setIntValues(values);
        return anim2;
    }

    public static FrameAnimator ofFloat(float ... values) {
        FrameAnimator anim2 = new FrameAnimator();
        anim2.setFloatValues(values);
        return anim2;
    }

    public static FrameAnimator ofPropertyValuesHolder(PropertyValuesHolder ... values) {
        FrameAnimator anim2 = new FrameAnimator();
        anim2.setValues(values);
        return anim2;
    }

    public static FrameAnimator ofObject(TypeEvaluator evaluator, Object ... values) {
        FrameAnimator anim2 = new FrameAnimator();
        anim2.setObjectValues(values);
        anim2.setEvaluator(evaluator);
        return anim2;
    }

    public void requestUpdate() {
        if (this.isAnimationEnd) {
            return;
        }
        long currentTime = AnimationUtils.currentAnimationTimeMillis();
        if (this.mStartTime < 0L) {
            this.mCurrentIteration = 0;
            this.mStartTime = currentTime;
        }
        this.mCurrentPlayTime = currentTime - this.mStartTime;
        this.setCurrentPlayTime(this.mCurrentPlayTime);
        if (this.mCurrentPlayTime >= this.getDuration()) {
            if (this.mCurrentIteration >= this.getRepeatCount() && this.getRepeatCount() != -1) {
                this.endAnimation();
            } else {
                this.mStartTime = currentTime;
                ++this.mCurrentIteration;
            }
        }
    }

    private void endAnimation() {
        if (!this.isAnimationEnd && this.getListeners() != null) {
            ArrayList tmpListeners = (ArrayList)this.getListeners().clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd((Animator)this);
            }
        }
        this.isAnimationEnd = true;
    }

    public boolean isAnimatorEnd() {
        return this.isAnimationEnd;
    }
}

