/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.utils;

import android.util.SparseArray;
import android.util.SparseIntArray;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftTarget;
import java.util.ArrayList;

public class GiftTargetRecyclePool {
    private SparseArray<ArrayList<GiftTarget>> mScrap = new SparseArray();
    private SparseIntArray mMaxScrap = new SparseIntArray();
    private static final int DEFAULT_MAX_SCRAP = 5;
    private static GiftTargetRecyclePool mRecyclePool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GiftTargetRecyclePool getInstance() {
        if (mRecyclePool != null) return mRecyclePool;
        Class<GiftTargetRecyclePool> clazz = GiftTargetRecyclePool.class;
        synchronized (GiftTargetRecyclePool.class) {
            mRecyclePool = new GiftTargetRecyclePool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mRecyclePool;
        }
    }

    public void clear() {
        if (this.mScrap != null) {
            this.mScrap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GiftTarget getRecycledView(int viewType) {
        SparseArray<ArrayList<GiftTarget>> sparseArray = this.mScrap;
        synchronized (sparseArray) {
            ArrayList scrapHeap = (ArrayList)this.mScrap.get(viewType);
            if (scrapHeap != null && !scrapHeap.isEmpty()) {
                int index = scrapHeap.size() - 1;
                GiftTarget scrap = (GiftTarget)scrapHeap.get(index);
                scrapHeap.remove(index);
                return scrap;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRecycledView(GiftTarget scrap, int viewType) {
        SparseArray<ArrayList<GiftTarget>> sparseArray = this.mScrap;
        synchronized (sparseArray) {
            ArrayList<GiftTarget> scrapHeap = this.getScrapHeapForType(viewType);
            if (this.mMaxScrap.get(viewType) > scrapHeap.size()) {
                scrapHeap.add(scrap);
            }
        }
    }

    private ArrayList<GiftTarget> getScrapHeapForType(int viewType) {
        ArrayList scrap = (ArrayList)this.mScrap.get(viewType);
        if (scrap == null) {
            scrap = new ArrayList();
            this.mScrap.put(viewType, scrap);
            if (this.mMaxScrap.indexOfKey(viewType) < 0) {
                this.mMaxScrap.put(viewType, 5);
            }
        }
        return scrap;
    }

    public void setMaxRecycledViews(int viewType, int max) {
        this.mMaxScrap.put(viewType, max);
        ArrayList scrapHeap = (ArrayList)this.mScrap.get(viewType);
        if (scrapHeap != null) {
            while (scrapHeap.size() > max) {
                scrapHeap.remove(scrapHeap.size() - 1);
            }
        }
    }
}

