/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.decoder.sub;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.gift.animation.SinPathAnimation;
import com.unionyy.mobile.meipai.gift.animation.decoder.AnimationDecoder;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GlImageTarget;
import com.unionyy.mobile.meipai.gift.animation.utils.BitmapUtil;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;
import com.unionyy.mobile.meipai.gift.animation.utils.DipUtils;
import com.unionyy.mobile.meipai.gift.animation.utils.FileUtils;
import com.unionyy.mobile.meipai.gift.animation.utils.ResourcesUtils;
import com.unionyy.mobile.meipai.gift.animation.view.GlAnimationView;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import okhttp3.internal.NamedRunnable;

public class PraiseAnimteDecoder
extends AnimationDecoder<GlAnimationView> {
    private static final String TAG = "PraiseAnimteDecoder";
    public static final int LIST_LENGTH = 100;
    private int mWidth;
    private int mHeight;
    private int mOnSizeChangeH;
    private int dNormalPicSize;
    private int mXOffsetValue;
    private int mYOffsetValue;
    private int mInitXOffsetValue;
    private int mInitYOffsetValue;
    private int[] drawables;
    private boolean mIsUseExtendResource = false;
    private String mExtendResourcePath;
    private int mDiffYOffset;
    private boolean isFaceShow = false;
    private int mOrientation = 1;
    private ArrayList<GlImageTarget> mGlImageTargets = new ArrayList();
    private Object mLock = new Object();
    private Random random = new Random();

    public PraiseAnimteDecoder() {
        this.init();
    }

    private void init() {
        this.drawables = new int[12];
        this.drawables[0] = R.drawable.meipai_live_ic_praise_sm1;
        this.drawables[1] = R.drawable.meipai_live_ic_praise_sm2;
        this.drawables[2] = R.drawable.meipai_live_ic_praise_sm3;
        this.drawables[3] = R.drawable.meipai_live_ic_praise_sm4;
        this.drawables[4] = R.drawable.meipai_live_ic_praise_sm5;
        this.drawables[5] = R.drawable.meipai_live_ic_praise_sm6;
        this.drawables[6] = R.drawable.meipai_live_ic_praise_sm7;
        this.drawables[7] = R.drawable.meipai_live_ic_praise_sm8;
        this.drawables[8] = R.drawable.meipai_live_ic_praise_sm9;
        this.drawables[9] = R.drawable.meipai_live_ic_praise_sm10;
        this.drawables[10] = R.drawable.meipai_live_ic_praise_sm11;
        this.drawables[11] = R.drawable.meipai_live_ic_praise_sm12;
        this.dNormalPicSize = ResourcesUtils.getDrawable(R.drawable.meipai_live_ic_praise_sm1).getIntrinsicWidth();
    }

    private int getDeviceScreenHeight(boolean isLandspace) {
        return isLandspace ? DeviceUtils.getScreenWidth() : DeviceUtils.getScreenHeight();
    }

    @Override
    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mDiffYOffset = Math.abs(h - oldh);
        this.mOnSizeChangeH = h;
        if (this.mOrientation == 1) {
            this.mHeight = DipUtils.dip2px(170.0f);
            this.mInitXOffsetValue = (int)ResourcesUtils.getDimension(R.dimen.meipai_live_live_praise_x_offset_portrait);
            this.mInitYOffsetValue = (int)((float)this.dNormalPicSize * this.getInitScaleRadio() / 2.0f);
        } else {
            this.mHeight = DipUtils.dip2px(173.0f);
            this.mInitXOffsetValue = (int)ResourcesUtils.getDimension(R.dimen.meipai_live_live_praise_x_offset_landspace);
            this.mInitYOffsetValue = (int)((float)this.dNormalPicSize * this.getInitScaleRadio() / 2.0f + (float)DipUtils.dip2px(14.0f));
        }
        this.mYOffsetValue = this.mOnSizeChangeH - this.mInitYOffsetValue - (this.isFaceShow ? this.mDiffYOffset : 0);
        this.mXOffsetValue = this.mWidth - this.mInitXOffsetValue;
    }

    public void onConfigurationChanged(int orientation) {
        this.mOrientation = orientation;
    }

    public void changeAnimYOffset(boolean show2) {
        this.isFaceShow = show2;
        this.mYOffsetValue = this.mOnSizeChangeH - this.mInitYOffsetValue - (this.isFaceShow ? this.mDiffYOffset : 0);
    }

    public void doNormalPraise(boolean isLianmaiing) {
        if (!isLianmaiing) {
            if (this.mWidth <= 0 || this.mHeight <= 0) {
                return;
            }
            if (this.getAnimationListSize() >= 100) {
                return;
            }
            GlImageTarget view = new GlImageTarget();
            if (!this.mIsUseExtendResource) {
                this.useDefaultNormalLike(view);
            } else if (!TextUtils.isEmpty((CharSequence)this.mExtendResourcePath)) {
                File smallIconFile = new File(this.mExtendResourcePath);
                if (smallIconFile.exists()) {
                    File[] smallIcons = smallIconFile.listFiles();
                    if (smallIcons != null && smallIcons.length > 0) {
                        ArrayList<File> smallIconImages = new ArrayList<File>();
                        for (File file : smallIcons) {
                            if (!FileUtils.isImageFile(file.getAbsolutePath())) continue;
                            smallIconImages.add(file);
                        }
                        File[] smallArr = smallIconImages.toArray(new File[smallIconImages.size()]);
                        if (smallArr != null && smallArr.length > 0) {
                            int smaalIconsCount = smallArr.length;
                            String path = smallArr[this.random.nextInt(smaalIconsCount)].getAbsolutePath();
                            YYTaskExecutor.execute((Runnable)((Object)new DecodeExtendResourceRunnable(TAG, path, view)));
                        } else {
                            this.useDefaultNormalLike(view);
                        }
                    } else {
                        this.useDefaultNormalLike(view);
                    }
                } else {
                    this.useDefaultNormalLike(view);
                }
            }
        }
    }

    private void useDefaultNormalLike(GlImageTarget view) {
        if (view == null) {
            return;
        }
        this.dNormalPicSize = ResourcesUtils.getDrawable(R.drawable.meipai_live_ic_praise_sm1).getIntrinsicWidth();
        view.setLayoutParams(this.dNormalPicSize, this.dNormalPicSize);
        float scaleValue = this.getInitScaleRadio();
        view.setScaleX(scaleValue);
        view.setScaleY(scaleValue);
        view.setX(this.mXOffsetValue);
        view.setY(this.mYOffsetValue);
        view.addDrawable((Object)this.drawables[this.random.nextInt(this.drawables.length)]);
        SinPathAnimation sinPathAnimation = new SinPathAnimation(view, this.mXOffsetValue, this.mYOffsetValue, this.getHighestEndY(), this.getScaleRadio(), ResourcesUtils.getResources(), this.getAnimDuration());
        view.setAnimation(sinPathAnimation);
        this.addImageTarget(view);
    }

    public int getAnimationListSize() {
        return this.mGlImageTargets.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageTarget(GlImageTarget target) {
        Object object = this.mLock;
        synchronized (object) {
            this.mGlImageTargets.add(target);
        }
        this.requestAutoInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeTarget() {
        int size;
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mGlImageTargets.size(); ++i) {
                GlImageTarget glImageTarget = this.mGlImageTargets.get(i);
                if (glImageTarget == null || !glImageTarget.isAnimationEnd()) continue;
                this.mGlImageTargets.remove(i);
                --i;
            }
            size = this.mGlImageTargets.size();
        }
        return size;
    }

    @Override
    public boolean onTextureDraw(GlAnimationView gl) {
        for (int i = 0; i < this.mGlImageTargets.size(); ++i) {
            GlImageTarget glImageTarget = this.mGlImageTargets.get(i);
            if (glImageTarget == null) continue;
            glImageTarget.onTextureDraw(gl, i);
        }
        return this.removeTarget() != 0;
    }

    private float getHighestEndY() {
        float maxHeight;
        float size = this.getTypeImageSize();
        float radius = size / 2.0f;
        float hightY = 0.75f * maxHeight + (float)this.random.nextInt((maxHeight = (float)this.mHeight - radius) <= 0.0f ? 1 : (int)(maxHeight * 0.25f));
        return hightY;
    }

    public int getTypeImageSize() {
        return this.dNormalPicSize;
    }

    public long getAnimDuration() {
        return 5000L;
    }

    public float getScaleRadio() {
        return 4.0f;
    }

    public float getInitScaleRadio() {
        return 0.2f;
    }

    public void updateResource(boolean isUseSpecial, String small) {
        this.mIsUseExtendResource = isUseSpecial;
        this.mExtendResourcePath = small;
    }

    private class DecodeExtendResourceRunnable
    extends NamedRunnable {
        private String mPath;
        private GlImageTarget mGlImageTarget;

        public DecodeExtendResourceRunnable(String name, String path, GlImageTarget view) {
            super(name, new Object[0]);
            this.mPath = path;
            this.mGlImageTarget = view;
        }

        public void execute() {
            if (this.mGlImageTarget != null) {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)this.mPath, (BitmapFactory.Options)options);
                float detisty = 1.0f;
                if (ResourcesUtils.getResources() != null) {
                    detisty = (float)ResourcesUtils.getDisplayMetrics().densityDpi / 320.0f;
                }
                int width = (int)((double)((float)BitmapUtil.scaleFromDensity(options.outWidth, options.inDensity, options.inTargetDensity) * detisty) + 0.5);
                int height = (int)((double)((float)BitmapUtil.scaleFromDensity(options.outHeight, options.inDensity, options.inTargetDensity) * detisty) + 0.5);
                PraiseAnimteDecoder.this.dNormalPicSize = width;
                this.mGlImageTarget.setLayoutParams(width, height);
                float scaleValue = PraiseAnimteDecoder.this.getInitScaleRadio();
                this.mGlImageTarget.setScaleX(scaleValue);
                this.mGlImageTarget.setScaleY(scaleValue);
                this.mGlImageTarget.setX(PraiseAnimteDecoder.this.mXOffsetValue);
                this.mGlImageTarget.setY(PraiseAnimteDecoder.this.mYOffsetValue);
                options.inJustDecodeBounds = false;
                Bitmap bitmap = BitmapFactory.decodeFile((String)this.mPath, (BitmapFactory.Options)options);
                this.mGlImageTarget.addDrawable(bitmap);
                SinPathAnimation sinPathAnimation = new SinPathAnimation(this.mGlImageTarget, PraiseAnimteDecoder.this.mXOffsetValue, PraiseAnimteDecoder.this.mYOffsetValue, PraiseAnimteDecoder.this.getHighestEndY(), PraiseAnimteDecoder.this.getScaleRadio(), ResourcesUtils.getResources(), PraiseAnimteDecoder.this.getAnimDuration());
                this.mGlImageTarget.setAnimation(sinPathAnimation);
                PraiseAnimteDecoder.this.addImageTarget(this.mGlImageTarget);
            }
        }
    }
}

