/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.gift.animation.decoder.sub;

import android.content.Context;
import android.view.ViewGroup;
import com.unionyy.mobile.meipai.gift.animation.decoder.AbstractAnimateDecoder;
import com.unionyy.mobile.meipai.gift.animation.gifttarget.GiftTarget;
import com.unionyy.mobile.meipai.gift.animation.model.GiftMessage;
import com.unionyy.mobile.meipai.gift.animation.model.GiftRule;
import com.unionyy.mobile.meipai.gift.controller.GiftAnimateController;
import com.unionyy.mobile.meipai.gift.dispatcher.GiftMessageDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;

public abstract class LiveLargeAnimateDecoder
extends AbstractAnimateDecoder {
    private static final String TAG = "LiveLargeAnimateDecoder";
    private static int LARGE_GIFT_VIEW_PARTS = 3;
    private ArrayList<GiftTarget> mLargeGiftTargets = new ArrayList(10);
    private GiftMessageDispatcher mGiftMessageDispatcher;
    private Comparator<GiftTarget> mTargetValueComparator = new Comparator<GiftTarget>(){

        @Override
        public int compare(GiftTarget lhs, GiftTarget rhs) {
            GiftMessage lMessage = lhs.getGiftMessage();
            GiftMessage rMessage = rhs.getGiftMessage();
            if (lMessage != null && rMessage != null) {
                return GiftAnimateController.getGiftValue(lMessage) - GiftAnimateController.getGiftValue(rMessage);
            }
            return 0;
        }
    };
    private GiftTarget.GiftImageDismissListener mLargeGiftDismissListener = new GiftTarget.GiftImageDismissListener(){

        @Override
        public void onGiftDismiss(GiftTarget target) {
            if (target != null) {
                LiveLargeAnimateDecoder.this.mGiftMessageDispatcher.reduceMemoryUsage(target.getMemoryUsage());
                if (target.getType() == 3 || target.getType() == 4) {
                    LiveLargeAnimateDecoder.this.mGiftMessageDispatcher.callHasEmptyImagePlayer();
                }
            }
            LiveLargeAnimateDecoder.this.removeRecycledGiftTarget();
            LiveLargeAnimateDecoder.this.mGiftMessageDispatcher.callOnGiftImageAnimDismisss();
        }
    };

    public LiveLargeAnimateDecoder(Context context, ViewGroup viewGroup, GiftMessageDispatcher dispatcher) {
        super(context, viewGroup);
        this.mGiftMessageDispatcher = dispatcher;
    }

    @Override
    protected float getGiftViewHeight() {
        return this.mHeight;
    }

    @Override
    public boolean dealWithGiftMessage(GiftMessage giftMessage) {
        return this.mGiftMessageDispatcher.receivedGiftMessage(giftMessage);
    }

    @Override
    public boolean dealWithGiftMessage(ArrayList<GiftMessage> giftMessages) {
        return this.mGiftMessageDispatcher.receivedGiftMessage(giftMessages);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.mLargeGiftTargets.size(); ++i) {
            GiftTarget target = this.mLargeGiftTargets.get(i);
            this.recycleGiftTarget(target);
        }
        this.mLargeGiftTargets.clear();
    }

    @Override
    public int desireGiftMessageType() {
        return 1;
    }

    @Override
    public void addGiftTargetToGroup(ArrayList<GiftTarget> targetList) {
        if (null == this.mGiftViewGroup) {
            return;
        }
        int baseIndexPos = this.mGiftViewGroup.getChildCount() - this.mLargeGiftTargets.size() * LARGE_GIFT_VIEW_PARTS;
        Collections.sort(targetList, this.mTargetValueComparator);
        this.mLargeGiftTargets.addAll(targetList);
        Collections.sort(this.mLargeGiftTargets, this.mTargetValueComparator);
        for (int i = 0; i < targetList.size(); ++i) {
            GiftTarget target = targetList.get(i);
            int imageHeight = target.getGiftImageHeight();
            int imageWidth = target.getGiftImageWidth();
            float x = this.mWidth / 2 - imageWidth / 2;
            float y = ((float)this.mHeight - this.marginBottom - this.marginTop) / 2.0f - (float)(imageHeight / 2);
            int index = this.getTargetIndex(target);
            target.addTo(this.mContext, this.mGiftViewGroup, x, y, baseIndexPos + index * LARGE_GIFT_VIEW_PARTS, this.mWidth, GiftTarget.GiftFrom.LARGE, this.mOrientation == 2);
            target.setGiftImageDismissListener(this.mLargeGiftDismissListener);
            this.mGiftMessageDispatcher.addMemoryUsage(target.getMemoryUsage());
        }
        this.requestAutoInvalidate();
    }

    @Override
    public void doSomeWithGiftTargetByDispatcher(GiftTarget target, GiftMessageDispatcher.DispatcherAttachMessage message) {
        GiftRule rule = target.getGiftRule();
        boolean forceShowInCenter = rule.type == 3 || rule.type == 4;
        int addSize = message != null ? message.arg1 : -1;
        this.randomCreateStartPoint(target, forceShowInCenter || this.mLargeGiftTargets.size() == 0 && addSize == 0);
    }

    @Override
    public GiftMessageDispatcher.GiftDispatchMessage checkGiftNeedWatitForDispatch(GiftMessage giftMessage) {
        String giftId = giftMessage.getGiftId();
        String path = giftMessage.getGiftLocalPath();
        GiftRule rule = this.loadGiftRule(giftId, path, "rule.json", giftMessage);
        GiftMessageDispatcher.GiftDispatchMessage message = new GiftMessageDispatcher.GiftDispatchMessage();
        message.rule = rule;
        message.isNeedDispatch = rule != null && (rule.type == 3 || rule.type == 4);
        return message;
    }

    private void randomCreateStartPoint(GiftTarget target, boolean putOnMid) {
        int dy;
        int dx;
        GiftRule rule = target.getGiftRule();
        if (rule == null) {
            return;
        }
        Random random = new Random();
        float viewWidth = this.mWidth;
        float viewHeight = this.getGiftViewHeight();
        float areaWidth = 0.0f;
        float areaHeight = 0.0f;
        if (rule.moving_area != null) {
            areaWidth = viewWidth * rule.moving_area[0];
            areaHeight = viewHeight * rule.moving_area[1];
        }
        float showAreaLeft = 0.0f;
        float showAreaTop = 0.0f;
        float showAreaWidth = viewWidth;
        float showAreaHeight = viewHeight;
        if (rule.showing_area != null) {
            showAreaLeft = viewWidth * rule.showing_area[0];
            showAreaTop = viewHeight * rule.showing_area[1];
            showAreaWidth = viewWidth * rule.showing_area[2];
            showAreaHeight = viewHeight * rule.showing_area[3];
        }
        if (!target.hasInitImagePosition()) {
            target.setGiftImagePosition(-target.getGiftImageWidth() / 2, -target.getGiftImageHeight() / 2);
        }
        if (putOnMid) {
            dx = (int)((showAreaWidth - areaWidth) / 2.0f + showAreaLeft);
            dy = (int)((showAreaHeight - areaHeight) / 2.0f + showAreaTop);
        } else {
            int maxDx = (int)(showAreaWidth - areaWidth);
            dx = (int)showAreaLeft;
            if (maxDx > 0) {
                dx += random.nextInt(maxDx);
            }
            int maxDy = (int)(showAreaHeight - areaHeight);
            dy = (int)showAreaTop;
            if (maxDy > 0) {
                dy += random.nextInt(maxDy);
            }
            int imageLeft = (int)target.getGiftImageLeft();
            int imageRight = target.getGiftImageWidth() + imageLeft;
            int imageTop = (int)target.getGiftImageTop();
            int imageBottom = target.getGiftImageHeight() + imageTop;
            if ((float)(dx + imageLeft) < showAreaLeft) {
                dx = (int)(showAreaLeft - (float)imageLeft);
            } else if ((float)(dx + imageRight) > showAreaLeft + showAreaWidth) {
                dx = (int)(showAreaLeft + showAreaWidth - (float)imageRight);
            }
            if ((float)(dy + imageTop) < showAreaTop) {
                dy = (int)(showAreaTop - (float)imageTop);
            } else if ((float)(dy + imageBottom) > showAreaTop + showAreaHeight) {
                dy = (int)(showAreaTop + showAreaHeight - (float)imageBottom);
            }
        }
        target.offsetGiftPath(dx, dy, viewWidth, viewHeight);
    }

    private void removeRecycledGiftTarget() {
        for (int i = 0; i < this.mLargeGiftTargets.size(); ++i) {
            GiftTarget target = this.mLargeGiftTargets.get(i);
            if (target == null || !target.isImageTargetDismiss()) continue;
            this.recycleGiftTarget(target);
            this.mLargeGiftTargets.remove(i);
            --i;
        }
    }

    private int getTargetIndex(GiftTarget target) {
        if (target == null) {
            return -1;
        }
        for (int i = 0; i < this.mLargeGiftTargets.size(); ++i) {
            GiftTarget next = this.mLargeGiftTargets.get(i);
            if (next == null || !next.equals(target)) continue;
            return i;
        }
        return -1;
    }
}

