/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.chat.codec.img.span;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.support.annotation.NonNull;
import android.text.style.ReplacementSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;

public class UserLevelSpan
extends ReplacementSpan {
    private static final float TEXT_PADDING_LEFT_DP = 18.0f;
    private static final float TEXT_PADDING_RIGHT_DP = 6.0f;
    private static final float TEXT_SIZE_DP = 10.0f;
    private static final float MIN_DRAWABLE_WIDTH_DP = 40.0f;
    private static final int LEVEL_1 = 1;
    private static final int LEVEL_2 = 2;
    private static final int LEVEL_16 = 16;
    private static final int LEVEL_26 = 26;
    private static final int LEVEL_41 = 41;
    private static final int LEVEL_60 = 60;
    private static final String LEVER_TEXT = "Lv";
    private int mSpanWith;
    private int mSpanHeight;
    private int mLeftMargin;
    private int mLeftPadding;
    private Rect mDrawableRect;
    private RectF mTargetRectF;
    private Paint mLevelPaint;
    private String mLevelText;
    private NinePatchDrawable mLevelDrawable;
    private float mScale;
    private final Context context;

    public UserLevelSpan(Context context, int level, int leftMargin, int rightMargin, float scale) {
        this.context = context;
        this.mScale = scale;
        this.mLeftMargin = leftMargin;
        this.mLeftPadding = DeviceUtils.dip2px(18.0f);
        int rightPadding = DeviceUtils.dip2px(6.0f);
        this.mLevelDrawable = (NinePatchDrawable)this.getLevelDrawable(level);
        this.mLevelText = LEVER_TEXT + level;
        this.initPaint();
        if (this.mLevelDrawable != null) {
            float textWidth = this.mLevelPaint.measureText(this.mLevelText);
            int drawableWidth = (int)textWidth + this.mLeftPadding + rightPadding;
            if (drawableWidth < DeviceUtils.dip2px(40.0f)) {
                drawableWidth = (int)Math.floor(DeviceUtils.dip2px(40.0f));
            }
            this.mSpanHeight = this.mLevelDrawable.getIntrinsicHeight();
            this.mSpanWith = this.mLeftMargin + rightMargin + drawableWidth;
            this.mDrawableRect = new Rect(0, 0, drawableWidth, this.mSpanHeight);
            this.mTargetRectF = new RectF(0.0f, 0.0f, (float)drawableWidth * this.mScale, (float)this.mSpanHeight * this.mScale);
        }
    }

    private void initPaint() {
        this.mLevelPaint = new Paint(32);
        DisplayMetrics metrics = this.context.getResources().getDisplayMetrics();
        float textSize = TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)metrics);
        this.mLevelPaint.setTextSize(textSize);
        this.mLevelPaint.setColor(-1);
        this.mLevelPaint.setAntiAlias(true);
    }

    private Drawable getLevelDrawable(int level) {
        Resources resources = this.context.getResources();
        if (level >= 1 && level < 2) {
            return resources.getDrawable(R.drawable.meipai_icon_level_gray);
        }
        if (level >= 2 && level < 16) {
            return resources.getDrawable(R.drawable.meipai_icon_level_red);
        }
        if (level >= 16 && level < 26) {
            return resources.getDrawable(R.drawable.meipai_icon_level_purple);
        }
        if (level >= 26 && level < 41) {
            return resources.getDrawable(R.drawable.meipai_icon_level_gold);
        }
        if (level >= 41) {
            return resources.getDrawable(R.drawable.meipai_icon_level_diamond);
        }
        return null;
    }

    public int getSize(@NonNull Paint paint, CharSequence text, int start2, int end, Paint.FontMetricsInt fm) {
        return (int)((float)this.mSpanWith * this.mScale);
    }

    public void draw(@NonNull Canvas canvas, CharSequence text, int start2, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        if (this.mLevelDrawable == null) {
            return;
        }
        float transY = y + paint.getFontMetricsInt().top;
        float transX = x + (float)this.mLeftMargin;
        canvas.save();
        canvas.translate(transX, transY);
        Bitmap bitmap = Bitmap.createBitmap((int)this.mDrawableRect.width(), (int)this.mDrawableRect.height(), (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas bitmapCanvas = new Canvas(bitmap);
        this.mLevelDrawable.setBounds(this.mDrawableRect.left, this.mDrawableRect.top, this.mDrawableRect.right, this.mDrawableRect.bottom);
        this.mLevelDrawable.draw(bitmapCanvas);
        float xCoordinate = this.mLeftPadding;
        Paint.FontMetrics fontMetrics = this.mLevelPaint.getFontMetrics();
        float f1 = fontMetrics.bottom - (fontMetrics.top + fontMetrics.ascent) / 2.0f;
        float yCoordinate = (float)this.mSpanHeight - ((float)this.mSpanHeight - f1) / 2.0f - fontMetrics.bottom;
        bitmapCanvas.drawText(this.mLevelText, xCoordinate, yCoordinate, this.mLevelPaint);
        canvas.drawBitmap(bitmap, this.mDrawableRect, this.mTargetRectF, null);
        canvas.restore();
    }
}

