/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.viewdelegate;

import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.pk.ui.dialog.DialogManager;
import com.unionyy.mobile.meipai.pk.ui.dialog.MeiPaiPKInviteDialogFragment;
import com.unionyy.mobile.meipai.pk.ui.dialog.MeiPaiPKInviteRandom;
import com.unionyy.mobile.meipai.pk.ui.model.PkStatusInfo;
import com.unionyy.mobile.meipai.pk.ui.view.ConnectLoadingView;
import com.unionyy.mobile.meipai.pk.ui.viewdelegate.BaseViewUpdateDelegate;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.ui.utils.ViewUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import io.reactivex.functions.Consumer;

public class PkIconViewUpdateDelegate
extends BaseViewUpdateDelegate {
    private static final String TAG = "PkIconViewUpdateDelegate";
    private TextView mTipsView;
    private ImageView mPkInconView;
    private ConnectLoadingView mLoadingView;
    private View pkIconRootView;
    private int lastType;
    private Handler mHandler = new SafeDispatchHandler(Looper.getMainLooper());

    public PkIconViewUpdateDelegate(View rootView, FragmentActivity activity) {
        super(rootView, activity, 0);
        this.mTipsView = (TextView)this.mActivity.findViewById(R.id.meipai_pkicon_tips_textView);
        if (this.mTipsView == null) {
            View tipsRoot = LayoutInflater.from((Context)BasicConfig.getInstance().getAppContext()).inflate(R.layout.meipai_pkicon_tips, null, false);
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
            this.mActivity.addContentView(tipsRoot, layoutParams);
            this.mTipsView = (TextView)tipsRoot.findViewById(R.id.meipai_pkicon_tips_textView);
        }
        this.pkIconRootView = rootView.findViewById(R.id.meipai_toolbar_pk_btn_root);
        this.mPkInconView = (ImageView)rootView.findViewById(R.id.meipai_toolbar_pk_btn);
        this.mLoadingView = (ConnectLoadingView)rootView.findViewById(R.id.meipai_pk_anim_view);
        ViewUtils.clicks((View)this.mPkInconView, (long)300L).subscribe((Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                MLog.info((Object)PkIconViewUpdateDelegate.TAG, (String)"[PK][\u70b9\u51fbpk\u5165\u53e3]", (Object[])new Object[0]);
                PkStatusInfo info = PkIconViewUpdateDelegate.this.core.getPkStatusInfo();
                if (info.state != 0 && info.type == 1) {
                    DialogManager.getInstence().dismissAllPopupComponents(PkIconViewUpdateDelegate.this.mActivity);
                    DialogManager.getInstence().showPopupComponent(new MeiPaiPKInviteRandom(), PkIconViewUpdateDelegate.this.mActivity);
                } else {
                    DialogManager.getInstence().dismissAllPopupComponents(PkIconViewUpdateDelegate.this.mActivity);
                    DialogManager.getInstence().showPopupComponent(new MeiPaiPKInviteDialogFragment(), PkIconViewUpdateDelegate.this.mActivity);
                }
            }
        });
        if (!this.core.isPkIconOpen()) {
            this.pkIconRootView.setVisibility(8);
        }
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mPkInconView.post(new Runnable(){

            @Override
            public void run() {
                Rect rect = PkIconViewUpdateDelegate.this.locateView((View)PkIconViewUpdateDelegate.this.mPkInconView);
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)PkIconViewUpdateDelegate.this.mTipsView.getLayoutParams();
                params.rightMargin = ScreenUtil.getInstance().getWidthPixels() - rect.centerX() - PkIconViewUpdateDelegate.this.mTipsView.getWidth() / 2;
                PkIconViewUpdateDelegate.this.mTipsView.setLayoutParams((ViewGroup.LayoutParams)params);
                MLog.info((Object)PkIconViewUpdateDelegate.TAG, (String)("[PK]post rightMargin:" + ((RelativeLayout.LayoutParams)((PkIconViewUpdateDelegate)PkIconViewUpdateDelegate.this).mTipsView.getLayoutParams()).rightMargin), (Object[])new Object[0]);
            }
        });
        this.mPkInconView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View view, int l, int t, int r, int b, int i4, int i5, int i6, int i7) {
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)PkIconViewUpdateDelegate.this.mTipsView.getLayoutParams();
                params.rightMargin = ScreenUtil.getInstance().getWidthPixels() - (r + l) / 2 - PkIconViewUpdateDelegate.this.mTipsView.getWidth() / 2;
                PkIconViewUpdateDelegate.this.mTipsView.setLayoutParams((ViewGroup.LayoutParams)params);
                MLog.info((Object)PkIconViewUpdateDelegate.TAG, (String)("[PK]onLayoutChange rightMargin:" + ((RelativeLayout.LayoutParams)((PkIconViewUpdateDelegate)PkIconViewUpdateDelegate.this).mTipsView.getLayoutParams()).rightMargin), (Object[])new Object[0]);
            }
        });
        PkStatusInfo info = this.core.getPkStatusInfo();
        this.updateIconState(info);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        PkStatusInfo info = this.core.getPkStatusInfo();
        this.updateIconState(info);
    }

    @Override
    public void onStateChanged(int lastState, int curState) {
        super.onStateChanged(lastState, curState);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void onClosePk() {
        super.onClosePk();
        this.mTipsView.setVisibility(4);
        this.mPkInconView.setEnabled(true);
        this.mPkInconView.setClickable(true);
        this.mHandler.removeCallbacksAndMessages(null);
        if (!this.core.isPkIconOpen()) {
            this.pkIconRootView.setVisibility(8);
        } else {
            this.pkIconRootView.setVisibility(0);
        }
        this.lastType = 0;
    }

    @Override
    protected void showTips(String tips) {
        super.showTips(tips);
    }

    private void updateIconState(PkStatusInfo info) {
        if (info.type == 4 || info.type == 5 || info.type == 6) {
            this.mPkInconView.setEnabled(false);
            this.mPkInconView.setClickable(false);
            if (this.lastType == 1 && info.type == 4) {
                this.mLoadingView.showMark();
                this.mHandler.removeCallbacksAndMessages(null);
                this.mTipsView.setVisibility(0);
                this.mPkInconView.setVisibility(4);
                this.mTipsView.setText((CharSequence)"\u5339\u914d\u6210\u529f");
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (PkIconViewUpdateDelegate.this.mTipsView != null) {
                            PkIconViewUpdateDelegate.this.mTipsView.setVisibility(4);
                        }
                        if (PkIconViewUpdateDelegate.this.mPkInconView != null) {
                            PkIconViewUpdateDelegate.this.mPkInconView.setVisibility(0);
                        }
                    }
                }, 2000L);
            }
        } else {
            if (info.type == 1) {
                this.mTipsView.setText((CharSequence)"\u5339\u914d\u4e2d...");
                this.mTipsView.setVisibility(0);
            } else {
                this.mTipsView.setVisibility(4);
            }
            this.mPkInconView.setEnabled(true);
            this.mPkInconView.setClickable(true);
        }
        if (!this.core.isPkIconOpen() && info.state == 0) {
            this.pkIconRootView.setVisibility(8);
        } else {
            this.pkIconRootView.setVisibility(0);
        }
        this.lastType = info.type;
    }

    private Rect locateView(View v) {
        Rect location = new Rect();
        int[] locInt = new int[2];
        if (v == null) {
            return location;
        }
        try {
            v.getLocationOnScreen(locInt);
        }
        catch (NullPointerException npe) {
            return location;
        }
        location.left = locInt[0];
        location.top = locInt[1];
        location.right = location.left + v.getWidth();
        location.bottom = location.top + v.getHeight();
        return location;
    }
}

