/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.vehicle;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.unionyy.mobile.meipai.gift.data.bean.Medals;
import com.unionyy.mobile.meipai.gift.data.bean.MountCar;
import com.unionyy.mobile.meipai.gift.data.bean.UserIn;
import com.unionyy.mobile.meipai.gift.event.EventMountCarUserIn;
import com.unionyy.mobile.meipai.vehicle.BroadcastVehicleBean;
import com.unionyy.mobile.meipai.vehicle.VehicleManagerBean;
import com.unionyy.mobile.meipai.vehicle.VehicleStickerItem;
import com.yy.mobile.RxBus;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.ProgressListener;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.pref2.SharedPreferencesUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.FileUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.mobilelive.MobileLiveFileUtil;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class VehicleManager {
    private static final String TAG = "VehicleManager";
    private static final String PREFERENCE_NAME = "VehicleManagerPreferences";
    private static final String PREFERENCE_KEY_RES_MD5_PRE_FIX = "res_md5_";
    private static final String NOMEDIA = ".nomedia";
    public static final String STICKER_DIR = "vehiclestickers";
    public static final String STICKER_PATH = BasicConfig.getInstance().getRootDir() + File.separator + "config" + File.separator + "vehiclestickers" + File.separator;
    private static volatile VehicleManager instance;
    private List<VehicleStickerItem> mVehicleStickeritems = Collections.synchronizedList(new ArrayList());
    private Vector<VehicleManagerBean> showBean = new Vector();
    private List<VehicleStickerItem> mArWhenDowning = Collections.synchronizedList(new ArrayList());
    private SharedPreferences mVehicleManagerPreferences;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VehicleManager getInstance() {
        if (instance != null) return instance;
        Class<VehicleManager> clazz = VehicleManager.class;
        synchronized (VehicleManager.class) {
            if (instance != null) return instance;
            instance = new VehicleManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @SuppressLint(value={"CheckResult"})
    public VehicleManager() {
        try {
            File[] fs;
            this.mVehicleManagerPreferences = SharedPreferencesUtils.getSharedPreferences((Context)BasicConfig.getInstance().getAppContext(), (String)PREFERENCE_NAME, (int)0);
            File file = new File(STICKER_PATH);
            if (!file.exists()) {
                file.mkdirs();
            }
            for (File f : fs = file.listFiles()) {
                String id2 = f.getName();
                String verifyMd5 = this.getPreferenceResourceMd5(id2);
                String cacheMd5 = this.cacheMd5(id2);
                if (!TextUtils.isEmpty((CharSequence)verifyMd5) && !TextUtils.isEmpty((CharSequence)cacheMd5) && verifyMd5.equals(cacheMd5)) {
                    VehicleStickerItem item = new VehicleStickerItem("", id2, VehicleStickerItem.VehicleStickerStatus.DECOMPRESSED);
                    this.mVehicleStickeritems.add(item);
                    continue;
                }
                if (TextUtils.isEmpty((CharSequence)id2) || NOMEDIA.equals(id2)) continue;
                FileUtil.delete((String)(STICKER_PATH + id2));
            }
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)("VehicleManager: " + e), (Object[])new Object[0]);
        }
    }

    public void startVehicle(VehicleManagerBean bean) {
        if (bean == null || bean.vehicleBean == null) {
            MLog.info((Object)TAG, (String)"VehicleManagerBean= null", (Object[])new Object[0]);
            return;
        }
        this.showBean.add(bean);
        this.checkDownLoad(bean.vehicleBean);
        this.openFaceStickerWithInfo(bean.vehicleBean.userCarId + "");
    }

    public void clear() {
        this.showBean.clear();
    }

    private void downloadAllWhatNeed() {
        for (int i = 0; i < this.mVehicleStickeritems.size(); ++i) {
            final VehicleStickerItem item = this.mVehicleStickeritems.get(i);
            if (item.status != VehicleStickerItem.VehicleStickerStatus.UNDOWNLOAD) continue;
            item.status = VehicleStickerItem.VehicleStickerStatus.DOWNLOADING;
            this.downloadStickerFile(item.url, new ResponseListener(){

                @SuppressLint(value={"CheckResult"})
                public void onResponse(Object response) {
                    MLog.info((Object)VehicleManager.TAG, (String)("downloadAllWhatNeed() download succeeded: " + item.url), (Object[])new Object[0]);
                    Observable.just((Object)item).subscribeOn(Schedulers.io()).subscribe((Consumer)new Consumer<VehicleStickerItem>(){

                        public void accept(VehicleStickerItem i) {
                            VehicleManager.this.decompressStickResourceAndExecuteQueue(i);
                        }
                    });
                }
            }, new ResponseErrorListener(){

                public void onErrorResponse(RequestError error) {
                    MLog.info((Object)VehicleManager.TAG, (String)("downloadAllWhatNeed() download failed: " + item.url), (Object[])new Object[0]);
                    item.status = VehicleStickerItem.VehicleStickerStatus.UNDOWNLOAD;
                }
            }, new ProgressListener(){

                public void onProgress(ProgressInfo info) {
                }
            });
        }
    }

    @SuppressLint(value={"CheckResult", "Rx#subscribe\u4f7f\u7528"})
    private void checkDownLoad(BroadcastVehicleBean bean) {
        if (this.containId(bean.userCarId + "")) {
            return;
        }
        VehicleStickerItem item = new VehicleStickerItem(bean.userCarUrl, bean.userCarId + "", VehicleStickerItem.VehicleStickerStatus.UNDOWNLOAD);
        this.mVehicleStickeritems.add(item);
        Observable.just(this.mVehicleStickeritems).subscribeOn(Schedulers.computation()).subscribe((Consumer)new Consumer<List<VehicleStickerItem>>(){

            public void accept(List<VehicleStickerItem> items) {
                VehicleManager.this.removeInaccuracyStickerFileCache(items.toArray(new VehicleStickerItem[0]));
                VehicleManager.this.downloadAllWhatNeed();
            }
        });
    }

    private boolean containId(String id2) {
        for (VehicleStickerItem item : this.mVehicleStickeritems) {
            if (!id2.equals(item.id)) continue;
            return true;
        }
        return false;
    }

    @SuppressLint(value={"CheckResult"})
    private void openFaceStickerWithInfo(String id2) {
        VehicleStickerItem item = null;
        for (VehicleStickerItem i : this.mVehicleStickeritems) {
            if (!id2.equals(i.id)) continue;
            item = i;
            break;
        }
        if (item == null) {
            return;
        }
        Observable.just(item).subscribeOn(Schedulers.io()).subscribe((Consumer)new Consumer<VehicleStickerItem>(){

            public void accept(final VehicleStickerItem item) {
                VehicleManager.this.removeInaccuracyStickerFileCache(new VehicleStickerItem[]{item});
                VehicleManager.this.downloadAllWhatNeed();
                switch (item.status) {
                    case UNDOWNLOAD: {
                        VehicleManager.this.mArWhenDowning.add(item);
                        item.status = VehicleStickerItem.VehicleStickerStatus.DOWNLOADING;
                        VehicleManager.this.downloadStickerFile(item.url, new ResponseListener(){

                            public void onResponse(Object response) {
                                MLog.info((Object)VehicleManager.TAG, (String)("openFaceStickerWithInfo() download succeeded: " + item.url), (Object[])new Object[0]);
                                Observable.just((Object)item).subscribeOn(Schedulers.io()).subscribe((Consumer)new Consumer<VehicleStickerItem>(){

                                    public void accept(VehicleStickerItem i) {
                                        VehicleManager.this.decompressStickResourceAndExecuteQueue(i);
                                    }
                                });
                            }
                        }, new ResponseErrorListener(){

                            public void onErrorResponse(RequestError error) {
                                MLog.info((Object)VehicleManager.TAG, (String)("openFaceStickerWithInfo() download succeeded: " + item.url), (Object[])new Object[0]);
                                item.status = VehicleStickerItem.VehicleStickerStatus.UNDOWNLOAD;
                            }
                        }, new ProgressListener(){

                            public void onProgress(ProgressInfo info) {
                            }
                        });
                        break;
                    }
                    case DOWNLOADING: {
                        VehicleManager.this.mArWhenDowning.add(item);
                        break;
                    }
                    case DECOMPRESSING: {
                        VehicleManager.this.mArWhenDowning.add(item);
                        break;
                    }
                    case DECOMPRESSED: {
                        VehicleManager.this.showArGift(item);
                        break;
                    }
                }
            }
        });
    }

    private synchronized void removeInaccuracyStickerFileCache(VehicleStickerItem ... vehileItems) {
        if (vehileItems == null) {
            return;
        }
        try {
            for (VehicleStickerItem item : vehileItems) {
                if (item.status == VehicleStickerItem.VehicleStickerStatus.DECOMPRESSING) continue;
                File stickerFileDir = new File(STICKER_PATH + item.id);
                File[] resourceFiles = stickerFileDir.listFiles();
                if (!stickerFileDir.exists()) {
                    item.status = VehicleStickerItem.VehicleStickerStatus.UNDOWNLOAD;
                    MLog.info((Object)TAG, (String)("stickerFileDir is not exists. " + item), (Object[])new Object[0]);
                    continue;
                }
                if (resourceFiles == null) {
                    item.status = VehicleStickerItem.VehicleStickerStatus.UNDOWNLOAD;
                    MLog.info((Object)TAG, (String)("resourceFiles is not exists. " + item), (Object[])new Object[0]);
                    FileUtil.delete((File)stickerFileDir);
                    continue;
                }
                String verifyMd5 = this.getPreferenceResourceMd5(item.id);
                String cacheMd5 = this.cacheMd5(item.id);
                if (!TextUtils.isEmpty((CharSequence)verifyMd5) && verifyMd5.equals(cacheMd5)) continue;
                item.status = VehicleStickerItem.VehicleStickerStatus.UNDOWNLOAD;
                MLog.info((Object)TAG, (String)("Md5 verify failed. " + item), (Object[])new Object[0]);
                FileUtil.delete((File)stickerFileDir);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    private void downloadStickerFile(String url, ResponseListener responseListener, ResponseErrorListener errorListener, ProgressListener progressListener) {
        String filePath;
        File file;
        MLog.info((Object)TAG, (String)("downloadStickerFile " + url), (Object[])new Object[0]);
        File stickerPath = new File(STICKER_PATH);
        if (!stickerPath.exists()) {
            stickerPath.mkdir();
        }
        if ((file = new File(filePath = stickerPath.getAbsolutePath() + File.separator + VehicleStickerItem.getFileNameByUrl(url))).exists()) {
            FileUtil.delete((File)file);
        }
        RequestManager.instance().submitDownloadRequest(url, filePath, responseListener, errorListener, progressListener, false);
    }

    private synchronized void decompressStickResourceAndExecuteQueue(VehicleStickerItem info) {
        this.decompressStickResource(info);
        if (this.mArWhenDowning.size() > 0) {
            ArrayList<VehicleStickerItem> deleteData = new ArrayList<VehicleStickerItem>();
            for (VehicleStickerItem item : this.mArWhenDowning) {
                if (!this.showArGift(item)) continue;
                deleteData.add(item);
            }
            for (VehicleStickerItem deleteItem : deleteData) {
                this.mArWhenDowning.remove(deleteItem);
            }
        }
    }

    private boolean showArGift(VehicleStickerItem info) {
        String rootPath = STICKER_PATH + info.id + File.separator;
        File file = new File(rootPath);
        Object[] files2 = file.listFiles();
        if (FP.empty((Object[])files2)) {
            return false;
        }
        int carId = Integer.valueOf(info.id);
        Vector<VehicleManagerBean> tempBeans = new Vector<VehicleManagerBean>();
        for (VehicleManagerBean item : this.showBean) {
            if (item.vehicleBean.userCarId != carId) continue;
            tempBeans.add(item);
        }
        for (VehicleManagerBean bean : tempBeans) {
            MountCar car = new MountCar();
            car.setAction(bean.vehicleBean.userCarAction);
            car.setId(Integer.valueOf(bean.vehicleBean.userCarId).intValue());
            car.setName(bean.vehicleBean.userCarName);
            car.setResource(rootPath);
            Medals medals = new Medals();
            medals.setGuard(bean.vehicleBean.guardType);
            UserIn userIn = new UserIn();
            userIn.setId(bean.uid);
            userIn.setNick(bean.nick);
            userIn.setLevel(bean.vehicleBean.userLevel);
            userIn.setMedals(medals);
            EventMountCarUserIn event = new EventMountCarUserIn();
            event.setType(8);
            event.setUser(userIn);
            event.setMounts(car);
            RxBus.getDefault().post((Object)event);
            MLog.info((Object)TAG, (String)("showArGift() will done! EventMountCarUserIn: " + event.toString()), (Object[])new Object[0]);
            MLog.info((Object)TAG, (String)("showArGift() will done! show vehicle now: " + bean.toString()), (Object[])new Object[0]);
            this.showBean.remove(bean);
        }
        return true;
    }

    private synchronized void decompressStickResource(VehicleStickerItem info) {
        MLog.info((Object)TAG, (String)("method decompressStickResource ready. " + info), (Object[])new Object[0]);
        String zipPath = STICKER_PATH + info.id;
        File zipFile = new File(STICKER_PATH + VehicleStickerItem.getFileNameByUrl(info.url));
        if (!zipFile.exists()) {
            MLog.info((Object)TAG, (String)("method decompressStickResource ops. zip file not exists. " + info), (Object[])new Object[0]);
            info.status = VehicleStickerItem.VehicleStickerStatus.UNDOWNLOAD;
            return;
        }
        try {
            info.status = VehicleStickerItem.VehicleStickerStatus.DECOMPRESSING;
            FileUtil.unzip((File)zipFile, (String)zipPath, (String)"");
            zipFile.delete();
            String md5 = this.cacheMd5(info.id);
            this.setPreferenceResourceMd5(info.id, md5);
            info.status = VehicleStickerItem.VehicleStickerStatus.DECOMPRESSED;
            MLog.info((Object)TAG, (String)("method decompressStickResource decompressed. " + info + " md5=" + md5), (Object[])new Object[0]);
        }
        catch (Exception e) {
            info.status = VehicleStickerItem.VehicleStickerStatus.UNDOWNLOAD;
            MLog.error((Object)TAG, (String)e.toString(), (Object[])new Object[0]);
        }
        MLog.info((Object)TAG, (String)("method decompressStickResource done. " + info), (Object[])new Object[0]);
    }

    private String cacheMd5(String id2) {
        try {
            Object[] resourceFiles = new File(STICKER_PATH + id2).listFiles();
            if (FP.empty((Object[])resourceFiles)) {
                return "";
            }
            return MobileLiveFileUtil.filesMd5((File[])resourceFiles);
        }
        catch (Exception e) {
            MLog.debug((Object)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            return "";
        }
    }

    private String getPreferenceResourceMd5(String id2) {
        return this.mVehicleManagerPreferences.getString(PREFERENCE_KEY_RES_MD5_PRE_FIX + id2, "");
    }

    private void setPreferenceResourceMd5(String id2, String md5) {
        this.mVehicleManagerPreferences.edit().putString(PREFERENCE_KEY_RES_MD5_PRE_FIX + id2, md5).apply();
    }
}

