/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.pk.ui.view.PKFireworksView;
import com.unionyy.mobile.meipai.pk.utils.MeiPaiScreenUtil;

public class PKVersusLayout
extends FrameLayout {
    private final int ANIMATION_DURATION = 2000;
    private final int ALPHA_DURATION = 500;
    private final int TRANSLATION_DURATION = 360;
    private PKFireworksView fireworksView;
    private FrameLayout layoutVersus;
    private ImageView imageViewV;
    private ImageView imageViewS;
    private boolean isFireworksShouldStart = false;
    private boolean isFireworksStarted = false;
    private AnimatorSet animatorSet;
    private PKVSAnimatorListener mPKVSAnimatorListener;
    private RelativeLayout mVSGroup;

    public PKVersusLayout(@NonNull Context context) {
        super(context);
        this.initView();
    }

    public PKVersusLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public PKVersusLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        PKVersusLayout.inflate((Context)this.getContext(), (int)R.layout.meipai_layout_versus_animation_view, (ViewGroup)this);
        this.fireworksView = (PKFireworksView)this.findViewById(R.id.view_fireworks);
        this.imageViewV = (ImageView)this.findViewById(R.id.image_versus_v);
        this.imageViewS = (ImageView)this.findViewById(R.id.image_versus_s);
        this.layoutVersus = (FrameLayout)this.findViewById(R.id.layout_versus);
        this.mVSGroup = (RelativeLayout)this.findViewById(R.id.layout_vs);
        this.layoutVersus.setScaleX(0.0f);
        this.layoutVersus.setScaleY(0.0f);
    }

    public void startAnimation() {
        if (this.animatorSet != null && this.animatorSet.isRunning()) {
            return;
        }
        this.resetView();
        ObjectAnimator objectAnimatorX = ObjectAnimator.ofFloat((Object)this.layoutVersus, (String)"scaleX", (float[])new float[]{0.0f, 1.2f, 0.85f, 1.1f, 0.95f, 1.0f});
        objectAnimatorX.setDuration(2000L);
        ObjectAnimator objectAnimatorY = ObjectAnimator.ofFloat((Object)this.layoutVersus, (String)"scaleY", (float[])new float[]{0.0f, 1.2f, 0.85f, 1.1f, 0.95f, 1.0f});
        objectAnimatorY.setDuration(2000L);
        ObjectAnimator objectAnimatorAlpha = ObjectAnimator.ofFloat((Object)this.layoutVersus, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        objectAnimatorAlpha.setDuration(500L);
        this.animatorSet = new AnimatorSet();
        this.animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        objectAnimatorX.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float animatedValue = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                if (animatedValue >= 1.0f) {
                    PKVersusLayout.this.isFireworksShouldStart = true;
                } else if (animatedValue <= 1.0f && PKVersusLayout.this.isFireworksShouldStart && !PKVersusLayout.this.isFireworksStarted) {
                    PKVersusLayout.this.isFireworksStarted = true;
                    PKVersusLayout.this.isFireworksShouldStart = false;
                    PKVersusLayout.this.fireworksView.startAnimation();
                }
            }
        });
        objectAnimatorX.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                PKVersusLayout.this.startTransitionAnimation();
            }
        });
        this.animatorSet.playTogether(new Animator[]{objectAnimatorX, objectAnimatorY, objectAnimatorAlpha});
        this.animatorSet.start();
    }

    public void customStyle() {
        this.imageViewV.setImageResource(R.drawable.meipai_pk_random_v);
        this.imageViewS.setImageResource(R.drawable.meipai_pk_random_s);
        this.fireworksView.setPINK_STROKE_WIDTH(PKVersusLayout.dip2px(this.getContext(), 4.0f));
        this.fireworksView.setPURPLE_STROKE_WIDTH(PKVersusLayout.dip2px(this.getContext(), 3.0f));
        if (MeiPaiScreenUtil.isLow640Screen()) {
            ViewGroup.LayoutParams params = this.mVSGroup.getLayoutParams();
            params.width = (int)this.getResources().getDimension(R.dimen.meipai_pk_random_width);
            params.height = (int)this.getResources().getDimension(R.dimen.meipai_pk_random_width);
            this.mVSGroup.setLayoutParams(params);
            ViewGroup.LayoutParams fireParams = this.fireworksView.getLayoutParams();
            fireParams.width = (int)this.getResources().getDimension(R.dimen.meipai_pk_random_frie_width);
            fireParams.height = (int)this.getResources().getDimension(R.dimen.meipai_pk_random_frie_width);
            this.fireworksView.setLayoutParams(fireParams);
            ViewGroup.LayoutParams vParams = this.imageViewV.getLayoutParams();
            vParams.width = (int)this.getResources().getDimension(R.dimen.meipai_pk_random_vs_width);
            vParams.height = (int)this.getResources().getDimension(R.dimen.meipai_pk_random_vs_width);
            this.imageViewV.setLayoutParams(vParams);
            ViewGroup.LayoutParams sParams = this.imageViewS.getLayoutParams();
            sParams.width = (int)this.getResources().getDimension(R.dimen.meipai_pk_random_vs_width);
            sParams.height = (int)this.getResources().getDimension(R.dimen.meipai_pk_random_vs_width);
            this.imageViewS.setLayoutParams(sParams);
            RelativeLayout.LayoutParams paramsRondom = (RelativeLayout.LayoutParams)this.layoutVersus.getLayoutParams();
            paramsRondom.setMargins(0, (int)this.getResources().getDimension(R.dimen.meipai_random_top_vs), 0, 0);
            this.layoutVersus.setLayoutParams((ViewGroup.LayoutParams)paramsRondom);
            FrameLayout.LayoutParams vMargin = (FrameLayout.LayoutParams)this.imageViewV.getLayoutParams();
            vMargin.setMargins((int)this.getResources().getDimension(R.dimen.meipai_random_left_vs), 0, 0, 0);
            this.imageViewV.setLayoutParams((ViewGroup.LayoutParams)vMargin);
            FrameLayout.LayoutParams sMargin = (FrameLayout.LayoutParams)this.imageViewS.getLayoutParams();
            sMargin.setMargins(0, 0, (int)this.getResources().getDimension(R.dimen.meipai_random_left_vs), 0);
            this.imageViewS.setLayoutParams((ViewGroup.LayoutParams)sMargin);
        } else {
            ViewGroup.LayoutParams params = this.mVSGroup.getLayoutParams();
            params.width = (int)this.getResources().getDimension(R.dimen.meipai_pk_random_width);
            params.height = (int)this.getResources().getDimension(R.dimen.meipai_pk_random_width);
            this.mVSGroup.setLayoutParams(params);
            ViewGroup.LayoutParams fireParams = this.fireworksView.getLayoutParams();
            fireParams.width = (int)this.getResources().getDimension(R.dimen.meipai_pk_random_frie_width_big);
            fireParams.height = (int)this.getResources().getDimension(R.dimen.meipai_pk_random_frie_width_big);
            this.fireworksView.setLayoutParams(fireParams);
            ViewGroup.LayoutParams vParams = this.imageViewV.getLayoutParams();
            vParams.width = (int)this.getResources().getDimension(R.dimen.meipai_pk_random_vs_width_big);
            vParams.height = (int)this.getResources().getDimension(R.dimen.meipai_pk_random_vs_width_big);
            this.imageViewV.setLayoutParams(vParams);
            ViewGroup.LayoutParams sParams = this.imageViewS.getLayoutParams();
            sParams.width = (int)this.getResources().getDimension(R.dimen.meipai_pk_random_vs_width_big);
            sParams.height = (int)this.getResources().getDimension(R.dimen.meipai_pk_random_vs_width_big);
            this.imageViewS.setLayoutParams(sParams);
            RelativeLayout.LayoutParams paramsRondom = (RelativeLayout.LayoutParams)this.layoutVersus.getLayoutParams();
            paramsRondom.setMargins(0, (int)this.getResources().getDimension(R.dimen.meipai_random_top_vs_big), 0, 0);
            this.layoutVersus.setLayoutParams((ViewGroup.LayoutParams)paramsRondom);
            FrameLayout.LayoutParams vMargin = (FrameLayout.LayoutParams)this.imageViewV.getLayoutParams();
            vMargin.setMargins((int)this.getResources().getDimension(R.dimen.meipai_random_left_vs_small), 0, 0, 0);
            this.imageViewV.setLayoutParams((ViewGroup.LayoutParams)vMargin);
            FrameLayout.LayoutParams sMargin = (FrameLayout.LayoutParams)this.imageViewS.getLayoutParams();
            sMargin.setMargins(0, 0, (int)this.getResources().getDimension(R.dimen.meipai_random_left_vs_small), 0);
            this.imageViewS.setLayoutParams((ViewGroup.LayoutParams)sMargin);
        }
    }

    private void resetView() {
        this.isFireworksShouldStart = false;
        this.isFireworksStarted = false;
        this.imageViewV.setTranslationX(0.0f);
        this.imageViewV.setTranslationY(0.0f);
        this.imageViewS.setTranslationX(0.0f);
        this.imageViewS.setTranslationY(0.0f);
        this.imageViewV.setAlpha(1.0f);
        this.imageViewS.setAlpha(1.0f);
    }

    private void startTransitionAnimation() {
        ObjectAnimator imageViewVTranslationX = ObjectAnimator.ofFloat((Object)this.imageViewV, (String)"translationX", (float[])new float[]{0.0f, (float)(-this.getWidth()) * 0.2f});
        ObjectAnimator imageViewVTranslationY = ObjectAnimator.ofFloat((Object)this.imageViewV, (String)"translationY", (float[])new float[]{0.0f, (this.getHeight() - this.imageViewV.getHeight()) / 2});
        ObjectAnimator imageViewSTranslationX = ObjectAnimator.ofFloat((Object)this.imageViewS, (String)"translationX", (float[])new float[]{0.0f, (float)this.getWidth() * 0.2f});
        ObjectAnimator imageViewSTranslationY = ObjectAnimator.ofFloat((Object)this.imageViewS, (String)"translationY", (float[])new float[]{0.0f, -((this.getHeight() - this.imageViewS.getHeight()) / 2)});
        imageViewVTranslationX.setDuration(360L);
        imageViewVTranslationY.setDuration(360L);
        imageViewSTranslationX.setDuration(360L);
        imageViewSTranslationY.setDuration(360L);
        ObjectAnimator imageViewVAlpha = ObjectAnimator.ofFloat((Object)this.imageViewV, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator imageViewSAlpha = ObjectAnimator.ofFloat((Object)this.imageViewS, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        imageViewVAlpha.setDuration(360L);
        imageViewSAlpha.setDuration(360L);
        this.animatorSet = new AnimatorSet();
        this.animatorSet.playTogether(new Animator[]{imageViewVTranslationX, imageViewVTranslationY, imageViewSTranslationX, imageViewSTranslationY, imageViewVAlpha, imageViewSAlpha});
        this.animatorSet.start();
        if (this.mPKVSAnimatorListener != null) {
            this.mPKVSAnimatorListener.vsAnimatorStart();
        }
        this.animatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (PKVersusLayout.this.mPKVSAnimatorListener != null) {
                    PKVersusLayout.this.mPKVSAnimatorListener.vsAnimatorEnd();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public void setPKVSAnimatorListener(PKVSAnimatorListener pkvsAnimatorListener) {
        this.mPKVSAnimatorListener = pkvsAnimatorListener;
    }

    public static int dip2px(Context context, float dipValue) {
        DisplayMetrics dm = context.getApplicationContext().getResources().getDisplayMetrics();
        return (int)(dipValue * dm.density + 0.5f);
    }

    public static interface PKVSAnimatorListener {
        public void vsAnimatorStart();

        public void vsAnimatorEnd();
    }
}

