/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.popularity;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.yy.mobile.config.BasicConfig;

public class SharedPreferencesUtils {
    public static void clearSharedPreferences(Context context, String tableName) {
        context.getApplicationContext().getSharedPreferences(tableName, 0).edit().clear().commit();
    }

    public static void clearSharedPreferences(String tableName) {
        BasicConfig.getInstance().getAppContext().getSharedPreferences(tableName, 0).edit().clear().commit();
    }

    public static SharedPreferences getSharedPreferences(String tableName) {
        return BasicConfig.getInstance().getAppContext().getSharedPreferences(tableName, 0);
    }

    public static boolean getSharedPreferencesBoolean(String tableName, String pKey, boolean pDefValue) {
        return SharedPreferencesUtils.getSharedPreferences(tableName).getBoolean(pKey, pDefValue);
    }

    public static int getSharedPreferencesInt(String tableName, String pKey) {
        return SharedPreferencesUtils.getSharedPreferences(tableName).getInt(pKey, -1);
    }

    public static boolean getSharedPreferencesValue(String tableName, String key, boolean defValue) {
        return SharedPreferencesUtils.getSharedPreferences(tableName).getBoolean(key, defValue);
    }

    public static float getSharedPreferencesValue(String tableName, String key, float defValue) {
        return SharedPreferencesUtils.getSharedPreferences(tableName).getFloat(key, defValue);
    }

    public static int getSharedPreferencesValue(String tableName, String key, int defValue) {
        return SharedPreferencesUtils.getSharedPreferences(tableName).getInt(key, defValue);
    }

    public static long getSharedPreferencesValue(String tableName, String key, long defValue) {
        return SharedPreferencesUtils.getSharedPreferences(tableName).getLong(key, defValue);
    }

    public static String getSharedPreferencesValue(String tableName, String key, String defValue) {
        return SharedPreferencesUtils.getSharedPreferences(tableName).getString(key, defValue);
    }

    public static void setSharedPreferences(String tableName, String key, boolean value) {
        if (Build.VERSION.SDK_INT >= 9) {
            SharedPreferencesUtils.getSharedPreferences(tableName).edit().putBoolean(key, value).apply();
        } else {
            SharedPreferencesUtils.getSharedPreferences(tableName).edit().putBoolean(key, value).commit();
        }
    }

    public static void setSharedPreferences(String tableName, String key, float value) {
        if (Build.VERSION.SDK_INT >= 9) {
            SharedPreferencesUtils.getSharedPreferences(tableName).edit().putFloat(key, value).apply();
        } else {
            SharedPreferencesUtils.getSharedPreferences(tableName).edit().putFloat(key, value).commit();
        }
    }

    public static void setSharedPreferences(String tableName, String key, int value) {
        if (Build.VERSION.SDK_INT >= 9) {
            SharedPreferencesUtils.getSharedPreferences(tableName).edit().putInt(key, value).apply();
        } else {
            SharedPreferencesUtils.getSharedPreferences(tableName).edit().putInt(key, value).commit();
        }
    }

    public static void setSharedPreferences(String tableName, String key, long value) {
        if (Build.VERSION.SDK_INT >= 9) {
            SharedPreferencesUtils.getSharedPreferences(tableName).edit().putLong(key, value).apply();
        } else {
            SharedPreferencesUtils.getSharedPreferences(tableName).edit().putLong(key, value).commit();
        }
    }

    public static void setSharedPreferences(String tableName, String key, String value) {
        if (Build.VERSION.SDK_INT >= 9) {
            SharedPreferencesUtils.getSharedPreferences(tableName).edit().putString(key, value).apply();
        } else {
            SharedPreferencesUtils.getSharedPreferences(tableName).edit().putString(key, value).commit();
        }
    }
}

