/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.viewdelegate;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.unionyy.mobile.meipai.R;
import com.unionyy.mobile.meipai.pk.ui.model.PkStatusInfo;
import com.unionyy.mobile.meipai.pk.ui.view.PKVersusLayout;
import com.unionyy.mobile.meipai.pk.ui.viewdelegate.BaseViewUpdateDelegate;
import com.unionyy.mobile.meipai.pk.utils.AvatarRoundUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.ScreenUtil;

public class PKVersusViewUpdateDelegate
extends BaseViewUpdateDelegate {
    private static final String TAG = "PKVersusViewUpdateDelegate";
    private static int USER_LABEL_INTO_ANIM_TIME = 1000;
    private static float USER_LABEL_INTO_RATIO = 0.35f;
    private static int USER_LABEL_INTO_WAVE = 13;
    private static int USER_LABEL_OUT_ANIM_TIME = 300;
    private static int USER_LABEL_OUT_LIGHT_ANIM_TIME = 400;
    private PKVersusLayout mPkVSLayout;
    private View mLeftNickLayout;
    private View mRightNickLayout;
    private View mLeftLightView;
    private TextView mLeftRedText;
    private ImageView mLeftRedAvatar;
    private View mRightLightView;
    private TextView mRightBlueText;
    private ImageView mRightBlueAvatar;
    private Handler mHandler;
    private boolean isPlayed;

    public PKVersusViewUpdateDelegate(View rootView, FragmentActivity activity, int videoMarginTop) {
        super(rootView, activity, videoMarginTop);
        this.mPkVSLayout = (PKVersusLayout)rootView.findViewById(R.id.live_pk_versus_layout);
        this.mLeftNickLayout = rootView.findViewById(R.id.live_pk_left_nick_group);
        this.mRightNickLayout = rootView.findViewById(R.id.live_pk_right_nick_group);
        this.mLeftLightView = rootView.findViewById(R.id.view_left_light);
        this.mRightLightView = rootView.findViewById(R.id.view_right_light);
        this.mLeftRedAvatar = (ImageView)rootView.findViewById(R.id.live_pk_red_anchor_avatar);
        this.mLeftRedText = (TextView)rootView.findViewById(R.id.live_pk_red_nick);
        this.mRightBlueText = (TextView)rootView.findViewById(R.id.live_pk_blue_nick);
        this.mRightBlueAvatar = (ImageView)rootView.findViewById(R.id.live_pk_blue_anchor_avatar);
        this.mHandler = new SafeDispatchHandler(Looper.getMainLooper());
        this.mLeftRedAvatar.setImageDrawable(AvatarRoundUtil.getRoundAvatar(BasicConfig.getInstance().getAppContext(), R.drawable.meipai_default_avatar_small));
        this.mRightBlueAvatar.setImageDrawable(AvatarRoundUtil.getRoundAvatar(BasicConfig.getInstance().getAppContext(), R.drawable.meipai_default_avatar_small));
    }

    @Override
    public void onInit() {
        super.onInit();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        PkStatusInfo info = this.core.getPkStatusInfo();
        if (!this.isPlayed && info.type == 5 && info.leftTime >= 3) {
            this.needChangeRedBlueBg(info.needChangeColor);
            String leftname = info.leftName == null ? "" : info.leftName;
            String rightname = info.rightName == null ? "" : info.rightName;
            this.setUserLabelData(info.leftUrl, leftname, info.rightUrl, rightname);
            this.startVsAnimation();
            this.isPlayed = true;
        } else if (info.type != 5) {
            this.isPlayed = false;
        }
    }

    @Override
    public void onStateChanged(int lastState, int curState) {
        super.onStateChanged(lastState, curState);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.onClosePk();
    }

    @Override
    public void onClosePk() {
        super.onClosePk();
        if (null != this.mLeftNickLayout) {
            this.mLeftNickLayout.clearAnimation();
            this.mLeftNickLayout.setVisibility(8);
        }
        if (null != this.mRightNickLayout) {
            this.mRightNickLayout.clearAnimation();
            this.mRightNickLayout.setVisibility(8);
        }
        if (null != this.mPkVSLayout) {
            this.mPkVSLayout.clearAnimation();
            this.mPkVSLayout.setVisibility(8);
        }
    }

    private void startVsAnimation() {
        this.mLeftNickLayout.setVisibility(0);
        this.mRightNickLayout.setVisibility(0);
        this.startUserLabelIntoAnimation();
        this.mPkVSLayout.setVisibility(0);
        this.mPkVSLayout.setPKVSAnimatorListener(new PKVersusLayout.PKVSAnimatorListener(){

            @Override
            public void vsAnimatorStart() {
                PKVersusViewUpdateDelegate.this.startUserLabelOutAnimation();
            }

            @Override
            public void vsAnimatorEnd() {
            }
        });
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                PKVersusViewUpdateDelegate.this.mPkVSLayout.startAnimation();
            }
        }, 800L);
    }

    private void startUserLabelIntoAnimation() {
        if (this.mRightNickLayout == null) {
            return;
        }
        if (this.mRightNickLayout.getContext() == null) {
            return;
        }
        float width = ScreenUtil.getInstance().getWidthPixels();
        float position = -BasicConfig.getInstance().getAppContext().getResources().getDimension(R.dimen.meipai_pk_user_tag);
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)this.mLeftNickLayout, (String)"translationX", (float[])new float[]{position, width / 2.0f + position, 0.0f, USER_LABEL_INTO_WAVE, 0.0f});
        animator.setInterpolator((TimeInterpolator)new AccelerateInterpolator(USER_LABEL_INTO_RATIO));
        animator.setDuration((long)USER_LABEL_INTO_ANIM_TIME);
        animator.start();
        float curTranslationRX = width;
        ObjectAnimator animatorRight = ObjectAnimator.ofFloat((Object)this.mRightNickLayout, (String)"translationX", (float[])new float[]{curTranslationRX, -(width / 2.0f) - position, 0.0f, -USER_LABEL_INTO_WAVE, 0.0f});
        animatorRight.setInterpolator((TimeInterpolator)new AccelerateInterpolator(USER_LABEL_INTO_RATIO));
        animatorRight.setDuration((long)USER_LABEL_INTO_ANIM_TIME);
        animatorRight.start();
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                PKVersusViewUpdateDelegate.this.startLightAnim();
            }
        }, (long)(USER_LABEL_INTO_ANIM_TIME + 100));
    }

    private void startLightAnim() {
        this.mLeftLightView.setVisibility(0);
        this.mRightLightView.setVisibility(0);
        float position = -BasicConfig.getInstance().getAppContext().getResources().getDimension(R.dimen.meipai_pk_user_light_width);
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)this.mLeftLightView, (String)"translationX", (float[])new float[]{0.0f, 2.0f * position});
        animator.setInterpolator((TimeInterpolator)new AccelerateInterpolator(USER_LABEL_INTO_RATIO));
        animator.setDuration((long)USER_LABEL_OUT_LIGHT_ANIM_TIME);
        animator.start();
        ObjectAnimator animatorRight = ObjectAnimator.ofFloat((Object)this.mRightLightView, (String)"translationX", (float[])new float[]{0.0f, -(2.0f * position)});
        animatorRight.setInterpolator((TimeInterpolator)new AccelerateInterpolator(USER_LABEL_INTO_RATIO));
        animatorRight.setDuration((long)USER_LABEL_OUT_LIGHT_ANIM_TIME);
        animatorRight.start();
    }

    private void startUserLabelOutAnimation() {
        if (this.mRightNickLayout == null) {
            return;
        }
        if (this.mLeftNickLayout == null) {
            return;
        }
        float translationXL = this.mLeftNickLayout.getTranslationX();
        float position = -BasicConfig.getInstance().getAppContext().getResources().getDimension(R.dimen.meipai_pk_user_tag);
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)this.mLeftNickLayout, (String)"translationX", (float[])new float[]{translationXL, position});
        animator.setInterpolator((TimeInterpolator)new AccelerateInterpolator(USER_LABEL_INTO_RATIO));
        animator.setDuration((long)USER_LABEL_OUT_ANIM_TIME);
        animator.start();
        ObjectAnimator animatorRight = ObjectAnimator.ofFloat((Object)this.mRightNickLayout, (String)"translationX", (float[])new float[]{0.0f, -position});
        animatorRight.setInterpolator((TimeInterpolator)new AccelerateInterpolator(USER_LABEL_INTO_RATIO));
        animatorRight.setDuration((long)USER_LABEL_OUT_ANIM_TIME);
        animatorRight.start();
    }

    private void needChangeRedBlueBg(boolean needChangeRedBlueBg) {
        if (needChangeRedBlueBg) {
            this.mLeftNickLayout.setBackgroundResource(R.drawable.meipai_pk_blue_nick_bg2);
            this.mRightNickLayout.setBackgroundResource(R.drawable.meipai_pk_red_nick_bg2);
        } else {
            this.mLeftNickLayout.setBackgroundResource(R.drawable.meipai_pk_red_nick_bg);
            this.mRightNickLayout.setBackgroundResource(R.drawable.meipai_pk_blue_nick_bg);
        }
    }

    public void setUserLabelData(String leftPhotoUrl, String leftName, String rightPhotoUrl, String rightName) {
        if (!TextUtils.isEmpty((CharSequence)leftPhotoUrl) && this.mLeftRedAvatar != null) {
            Glide.with((Context)this.mLeftRedAvatar.getContext()).load(leftPhotoUrl).apply(RequestOptions.circleCropTransform().placeholder(AvatarRoundUtil.getRoundAvatar(this.mLeftRedAvatar.getContext(), R.drawable.meipai_default_avatar_small))).into(this.mLeftRedAvatar);
        }
        if (!TextUtils.isEmpty((CharSequence)rightPhotoUrl) && this.mRightBlueAvatar != null) {
            Glide.with((Context)this.mRightBlueAvatar.getContext()).load(rightPhotoUrl).apply(RequestOptions.circleCropTransform().placeholder(AvatarRoundUtil.getRoundAvatar(this.mRightBlueAvatar.getContext(), R.drawable.meipai_default_avatar_small))).into(this.mRightBlueAvatar);
        }
        if (this.mLeftRedText != null) {
            this.mLeftRedText.setText((CharSequence)leftName);
        }
        if (this.mRightBlueText != null) {
            this.mRightBlueText.setText((CharSequence)rightName);
        }
    }
}

