/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.meipai.pk.ui.dialog.RandomView;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.unionyy.mobile.meipai.gift.animation.utils.DeviceUtils;

public class PKFireworksView
extends View {
    private final int LINE_COUNT = 6;
    private final int MAX_LENGTH = DeviceUtils.dip2px(20.0f);
    private final int ANIMATION_DURATION = 800;
    private final int ALPHA_DURATION = 120;
    private final float DIFFERENCE_SCALE = 0.1f;
    private int PINK_STROKE_WIDTH = DeviceUtils.dip2px(6.0f);
    private final int PINK_COLOR = Color.parseColor((String)"#FF53C2");
    private int PURPLE_STROKE_WIDTH = DeviceUtils.dip2px(5.0f);
    private final int PURPLE_COLOR = Color.parseColor((String)"#8F43FA");
    private Paint paint;
    private boolean isAnimationStart = false;
    private ValueAnimator valueAnimator;
    private int animatedValue;

    public PKFireworksView(Context context) {
        super(context);
        this.init();
    }

    public PKFireworksView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PKFireworksView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeCap(Paint.Cap.ROUND);
    }

    protected void onDraw(Canvas canvas) {
        int i;
        super.onDraw(canvas);
        if (!this.isAnimationStart) {
            return;
        }
        float diameter = Math.max(this.getWidth(), this.getHeight());
        int stepAngel = 60;
        int alpha = this.animatedValue < 680 ? 255 : (int)((float)(800 - this.animatedValue) / 120.0f * 255.0f);
        this.paint.setStrokeWidth((float)this.PINK_STROKE_WIDTH);
        this.paint.setColor(this.PINK_COLOR);
        this.paint.setAlpha(alpha);
        float minRadius = diameter / 2.0f - (float)this.MAX_LENGTH;
        for (i = 0; i < 6; ++i) {
            this.drawLineByPosition(canvas, diameter, stepAngel, minRadius, i, this.PINK_STROKE_WIDTH, stepAngel / 2);
        }
        this.paint.setStrokeWidth((float)this.PURPLE_STROKE_WIDTH);
        this.paint.setColor(this.PURPLE_COLOR);
        this.paint.setAlpha(alpha);
        minRadius = diameter / 2.0f - (float)this.MAX_LENGTH - diameter * 0.1f;
        for (i = 0; i < 6; ++i) {
            this.drawLineByPosition(canvas, diameter, stepAngel, minRadius, i, this.PURPLE_STROKE_WIDTH, 0);
        }
    }

    private void drawLineByPosition(Canvas canvas, float diameter, int stepAngel, float minRadius, int index, int strokeWidth, int deviationAngel) {
        float stopY;
        float stopX;
        float startY;
        float startX;
        float longDuration = 170.0f;
        if (this.animatedValue < 680) {
            if ((float)this.animatedValue < longDuration) {
                startX = (float)((double)(diameter / 2.0f) + (double)minRadius * Math.cos((double)(stepAngel * index + deviationAngel) * Math.PI / 180.0));
                startY = (float)((double)(diameter / 2.0f) + (double)minRadius * Math.sin((double)(stepAngel * index + deviationAngel) * Math.PI / 180.0));
                float currentLength = (float)(this.MAX_LENGTH - strokeWidth) * ((float)this.animatedValue / longDuration);
                stopX = (float)((double)(diameter / 2.0f) + (double)(minRadius + currentLength) * Math.cos((double)(stepAngel * index + deviationAngel) * Math.PI / 180.0));
                stopY = (float)((double)(diameter / 2.0f) + (double)(minRadius + currentLength) * Math.sin((double)(stepAngel * index + deviationAngel) * Math.PI / 180.0));
            } else {
                float subductionLength = (float)(this.MAX_LENGTH - strokeWidth) * (((float)this.animatedValue - longDuration) / (800.0f - longDuration));
                startX = (float)((double)(diameter / 2.0f) + (double)(minRadius + subductionLength) * Math.cos((double)(stepAngel * index + deviationAngel) * Math.PI / 180.0));
                startY = (float)((double)(diameter / 2.0f) + (double)(minRadius + subductionLength) * Math.sin((double)(stepAngel * index + deviationAngel) * Math.PI / 180.0));
                stopX = (float)((double)(diameter / 2.0f) + (double)(minRadius + (float)this.MAX_LENGTH - (float)strokeWidth) * Math.cos((double)(stepAngel * index + deviationAngel) * Math.PI / 180.0));
                stopY = (float)((double)(diameter / 2.0f) + (double)(minRadius + (float)this.MAX_LENGTH - (float)strokeWidth) * Math.sin((double)(stepAngel * index + deviationAngel) * Math.PI / 180.0));
            }
        } else {
            startX = (float)((double)(diameter / 2.0f) + (double)(minRadius + (float)this.MAX_LENGTH - (float)strokeWidth) * Math.cos((double)(stepAngel * index + deviationAngel) * Math.PI / 180.0));
            startY = (float)((double)(diameter / 2.0f) + (double)(minRadius + (float)this.MAX_LENGTH - (float)strokeWidth) * Math.sin((double)(stepAngel * index + deviationAngel) * Math.PI / 180.0));
            stopX = startX;
            stopY = startY + 0.1f;
        }
        canvas.drawLine(startX, startY, stopX, stopY, this.paint);
    }

    public void startAnimation() {
        if (this.valueAnimator != null && this.valueAnimator.isRunning()) {
            return;
        }
        this.isAnimationStart = true;
        this.valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, 800});
        this.valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.valueAnimator.setDuration(800L);
        this.valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                PKFireworksView.this.animatedValue = (Integer)animation.getAnimatedValue();
                PKFireworksView.this.invalidate();
            }
        });
        this.valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                PKFireworksView.this.isAnimationStart = false;
            }
        });
        this.valueAnimator.start();
    }

    public void setPINK_STROKE_WIDTH(int PINK_STROKE_WIDTH) {
        this.PINK_STROKE_WIDTH = PINK_STROKE_WIDTH;
    }

    public void setPURPLE_STROKE_WIDTH(int PURPLE_STROKE_WIDTH) {
        this.PURPLE_STROKE_WIDTH = PURPLE_STROKE_WIDTH;
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility != 0 && this.valueAnimator != null && this.valueAnimator.isRunning()) {
            this.valueAnimator.cancel();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.valueAnimator != null && this.valueAnimator.isRunning()) {
            this.valueAnimator.cancel();
        }
    }
}

